/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Memo.cpp,v 1.6 2004/05/10 09:58:17 randy Exp $
 */

#include <clx.h>
#pragma hdrstop

#include "soopyg.h"

/*
 * class TSpMemo
 */

void __fastcall TSpMemo::Click(void)
{
    TWinControl::Click();        // nȟĂяoȂǕWIȏs
    SpValue onClick  = ns->lookup(SymOnClick);
    if(onClick.isFunc()){
        SpFunc* f = onClick.asFunc();
        (*f)(NilObject);
    }
}

void __fastcall TSpMemo::Change(void)
{
    TCustomMemo::Change();        // nȟĂяoȂǕWIȏs
    SpValue onChange  = ns->lookup(SymOnChange);
    if(onChange.isFunc()){
        SpFunc* f = onChange.asFunc();
        (*f)(NilObject);
    }
}


/*
 * class SpMemo
 */

SpValue& SpMemo::make()
{
    SpMemo* memo = new SpMemo(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(memo);
//    return result;
  return SpObjectResult(memo);
}

// Caption
SpValue& SpMemo::getCaption(TWidgetControl* w)
{
    throw SpCaptionException("can't get edit.caption");
}

void SpMemo::setCaption(TWidgetControl* w, const char* str)
{
    throw SpCaptionException("can't set edit.caption");
}

void SpMemo::creation(SpValue& parentNS, TWidgetControl* parent)
{
    SpNameSpace* assoc = ns.asNameSpace();
    widget = new TSpMemo(parent, assoc);

    SpComponent::after_creation(assoc, parentNS, parent, (TWidgetControl*)widget);

    ((TMemo*)widget)->ScrollBars = ssBoth;
    // set text
    SpValue vtext  = assoc->lookup(SymText);
    if(vtext.isString()){
        ((TMemo*)widget)->Text = vtext.toCStringWithEncoder();
    }

    // set self
    SpValue self(this);
    assoc->internConst(SymSelf, self);

    initProperties(assoc); // SpComponent::initProperties
//    ((TSpMemo*)widget)->initProperties();
}

// primitives
SpValue& SpMemo::primClear()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    ((TMemo*)comp->widget)->Clear();
    return TrueObject;
}

SpValue& SpMemo::primGetText()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result.setNewObject(new SpString(AnsiString(((TMemo*)comp->widget)->Text).c_str()));
//    return result;
  return SpObjectResult(new SpString(AnsiString(((TMemo*)comp->widget)->Text).c_str()));
}

SpValue& SpMemo::primSetText(SpValue& v)
{
    if(v.isString()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        ((TMemo*)comp->widget)->Text = v.toCStringWithEncoder();
    }
    return TrueObject;
}

SpValue& SpMemo::primGetModified()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    if(((TMemo*)comp->widget)->Modified){
        return TrueObject;
    }
    return FalseObject;
}

SpValue& SpMemo::primSetModified(SpValue& v)
{
    if(v.isBool()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        if(v.isTrue()){
          ((TMemo*)comp->widget)->Modified = true;
        }else{
          ((TMemo*)comp->widget)->Modified = false;
          return FalseObject;
        }
    }
    return TrueObject;
}

SpValue& SpMemo::primAppend(SpValue& v)
{
    if(v.isString()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        ((TMemo*)comp->widget)->Append(v.toCStringWithEncoder());
    }
    return TrueObject;
}


// init
static SpValue Clear;
static SpValue GetText;
static SpValue SetText;
static SpValue GetModified;
static SpValue SetModified;
static SpValue Append;

void SpMemo::initProperties(SpNameSpace* pNS)
{
    SpComponent::initProperties(pNS);
    // Text
    pNS->internPrimProperty(SymText, NilObject, GetText, SetText);
    pNS->internPrimProperty(SymModifiedP, NilObject, GetModified, SetModified);
    pNS->internFunc(SymClear, Clear);
    pNS->internFunc(SymAppend, Append);
}

void SpMemo::init()
{
    // set namespace to symbol 'std_edit'.
    PMemoNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    MemoNS.setNewObject(PMemoNameSpace);
    SpValue SymStdField(new SpSymbol("std_edit"));
    PMainNameSpace->internConst(SymStdField, MemoNS);

    GetText.setNewObject(new SpPrim0(primGetText));
    SetText.setNewObject(new SpPrim1(primSetText));
    GetModified.setNewObject(new SpPrim0(primGetModified));
    SetModified.setNewObject(new SpPrim1(primSetModified));
    Append.setNewObject(new SpPrim1(primAppend));
    Clear.setNewObject(new SpPrim0(primClear));

    SpValue PrimMake(new SpPrim0(make));
    PMemoNameSpace->internFunc(SymMake, PrimMake);
}

