/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Panel.cpp,v 1.4 2004/05/10 09:58:17 randy Exp $
 */

#include <clx.h>
#pragma hdrstop

#include "soopyg.h"

/*
 * class TSpPanel
 */

void __fastcall TSpPanel::Click(void)
{
    TWinControl::Click();        // nȟĂяoȂǕWIȏs
    SpValue onClick  = ns->lookup(SymOnClick);
    if(onClick.isFunc()){
        SpFunc* f = onClick.asFunc();
        (*f)(NilObject);
    }
}


/*
 * class SpPanel
 */

SpValue& SpPanel::make()
{
    SpPanel* panel = new SpPanel(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(panel);
//    return result;
  return SpObjectResult(panel);
}

// Caption
SpValue& SpPanel::getCaption(TWidgetControl* w)
{
//    static SpValue result;
//    result.setNewObject(new SpString(AnsiString(((TPanel*)w)->Caption).c_str()));
//    return result;
  return SpObjectResult(new SpString(AnsiString(((TPanel*)w)->Caption).c_str()));
}

void SpPanel::setCaption(TWidgetControl* w, const char* str)
{
    ((TPanel*)w)->Caption = str;
}

void SpPanel::creation(SpValue& parentNS, TWidgetControl* parent)
{
    SpNameSpace* assoc = ns.asNameSpace();
    widget = new TSpPanel(parent, assoc);

    SpComponent::after_creation(assoc, parentNS, parent, (TWidgetControl*)widget);

    SpValue self(this);
    assoc->internConst(SymSelf, self);

    initProperties(assoc); // SpComponent::initProperties

    // create components
    SpValue vcomps = assoc->lookup(SymComponents);
    create_components((TWidgetControl*)widget, ns, vcomps);
}

void SpPanel::init()
{
    // set namespace to symbol 'std_window'.
    PPanelNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    PanelNS.setNewObject(PPanelNameSpace);
    SpValue SymStdPanel(new SpSymbol("std_panel"));
    PMainNameSpace->internConst(SymStdPanel, PanelNS);

    // set default top, left, width, height
    DefaultTop.setInt(0);
    PPanelNameSpace->internConst(SymTop, DefaultTop);
    DefaultLeft.setInt(0);
    PPanelNameSpace->internConst(SymLeft, DefaultLeft);
    DefaultWidth.setInt(200);
    PPanelNameSpace->internConst(SymWidth, DefaultWidth);
    DefaultHeight.setInt(80);
    PPanelNameSpace->internConst(SymHeight, DefaultHeight);

    SpValue PrimMake(new SpPrim0(make));
    PPanelNameSpace->internFunc(SymMake, PrimMake);
}

