/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: RadioGroup.cpp,v 1.5 2004/05/10 09:58:17 randy Exp $
 */

#include <clx.h>
#pragma hdrstop

#include "soopyg.h"

/*
 * class TSpRadioGroup
 */

void __fastcall TSpRadioGroup::Click(void)
{
    TWinControl::Click();        // nȟĂяoȂǕWIȏs
    SpValue onClick  = ns->lookup(SymOnClick);
    if(onClick.isFunc()){
        SpFunc* f = onClick.asFunc();
        (*f)(NilObject);
    }
}


/*
 * class SpRadioGroup
 */

SpValue& SpRadioGroup::make()
{
    SpRadioGroup* group = new SpRadioGroup(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(group);
//    return result;
  return SpObjectResult(group);
}

// primitives

// Caption
SpValue& SpRadioGroup::getCaption(TWidgetControl* w)
{
//    static SpValue result;
//    result.setNewObject(new SpString(AnsiString(((TRadioGroup*)w)->Caption).c_str()));
//    return result;
  return SpObjectResult(new SpString(AnsiString(((TRadioGroup*)w)->Caption).c_str()));
}

void SpRadioGroup::setCaption(TWidgetControl* w, const char* str)
{
    ((TRadioGroup*)w)->Caption = str;
}

// Index
SpValue& SpRadioGroup::primGetIndex()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    TRadioGroup* ptr = (TRadioGroup*)comp->widget;
//    static SpValue result;
//    result.setInt(ptr->ItemIndex);
//    return result;
    SpValue result;
    result.setInt(ptr->ItemIndex);
    return SpValueResult(result);
}

SpValue& SpRadioGroup::primSetIndex(SpValue& v)
{
    if(!v.isInt()){
        throw SpException("not integer (radiogroup.index)");
    }
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    TRadioGroup* ptr = (TRadioGroup*)comp->widget;
    ptr->ItemIndex = v.asInt();
    return v;
}

// Text of selected radio button
SpValue& SpRadioGroup::primGetText()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    TRadioGroup* ptr = (TRadioGroup*)comp->widget;
    if(ptr->ItemIndex < 0){
        return NilObject;
    }
//    static SpValue result;
//    result.setNewObject(new SpString(ptr->Items->Strings[ptr->ItemIndex].c_str()));
//    return result;
  return SpObjectResult(new SpString(ptr->Items->Strings[ptr->ItemIndex].c_str()));
}

// creation
void SpRadioGroup::creation(SpValue& parentNS, TWidgetControl* parent)
{
    SpNameSpace* assoc = ns.asNameSpace();
    widget = new TSpRadioGroup(parent, assoc);

    SpComponent::after_creation(assoc, parentNS, parent, (TWidgetControl*)widget);

    SpValue self(this);
    assoc->internConst(SymSelf, self);

    initProperties(assoc); // SpComponent::initProperties

    // setup items
    SpValue vitems = assoc->lookup(SymItems);
    if(vitems.isList()){
        while(!vitems.isNil()){
            SpList* ptr = vitems.asList();
            SpValue v = ptr->value();
            if(!v.isString()){
                throw SpException("not string (radiogroup items:)");
            }
            SpString* str = v.asString();
            ((TSpRadioGroup*)widget)->Items->Add(str->toCStringWithEncoder());
            vitems = ptr->nextList();
        }
    }
/*
    // create components
    SpValue vcomps = assoc->lookup(SymComponents);
    create_components((TWidgetControl*)widget, ns, vcomps);
*/
}

// init
static SpValue GetText;
static SpValue GetIndex;
static SpValue SetIndex;

void SpRadioGroup::initProperties(SpNameSpace* pNS)
{
    SpComponent::initProperties(pNS);
    // Text
    pNS->internPrimProperty(SymText, NilObject, GetText, NilObject);
    // Index
    pNS->internPrimProperty(SymIndex, NilObject, GetIndex, SetIndex);
}

void SpRadioGroup::init()
{
    // set namespace to symbol 'std_window'.
    PRadioGroupNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    RadioGroupNS.setNewObject(PRadioGroupNameSpace);
    SpValue SymStdRadioGroup(new SpSymbol("std_radiogroup"));
    PMainNameSpace->internConst(SymStdRadioGroup, RadioGroupNS);

    // set default top, left, width, height
    DefaultTop.setInt(0);
    PRadioGroupNameSpace->internConst(SymTop, DefaultTop);
    DefaultLeft.setInt(0);
    PRadioGroupNameSpace->internConst(SymLeft, DefaultLeft);
    DefaultWidth.setInt(200);
    PRadioGroupNameSpace->internConst(SymWidth, DefaultWidth);
    DefaultHeight.setInt(80);
    PRadioGroupNameSpace->internConst(SymHeight, DefaultHeight);

    GetText.setNewObject(new SpPrim0(primGetText));
    GetIndex.setNewObject(new SpPrim0(primGetIndex));
    SetIndex.setNewObject(new SpPrim1(primSetIndex));

    SpValue PrimMake(new SpPrim0(make));
    PRadioGroupNameSpace->internFunc(SymMake, PrimMake);
}

