/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Combo.mm,v 1.3 2004/05/10 12:52:12 randy Exp $
 */

#include "soopyg.h"

/*
 * class SpNSComboBox
 */

@implementation SpNSComboBox

-(id)initWithNameSpace:(SpNameSpace*)assoc parent:(NSObject*)parent comp:(SpComponent*)spc
{
    ns = assoc;
    spcomp = spc;
    // set window origin & size
    SpValue vtop = assoc->lookup(SymTop);
    SpValue vleft = assoc->lookup(SymLeft);
    SpValue vwidth = assoc->lookup(SymWidth);
    SpValue vheight = assoc->lookup(SymHeight);

    NSRect rect = [(NSView*)[parent contentView] frame];
    float left = (float)vleft.getInt();
    float width = (float)vwidth.getInt();
    float height = (float)vheight.getInt();
    float top = rect.size.height - (float)vtop.getInt() - height;
    //[self initWithFrame: NSMakeRect(left, top, width, height) pullsDown:NO];
    [self initWithFrame: NSMakeRect(left, top, width, height)];

    return self;
}

-(SpNameSpace*)getNameSpace
{
  return ns;
}

-(SpComponent*)getSpComponent
{
  return spcomp;
}

-(void)change:(NSObject*)sender
{
    SpValue onChange  = ns->lookup(SymOnChange);
    if(onChange.isFunc()){
        SpFunc* f = onChange.asFunc();
        (*f)(NilObject);
    }
}

@end

/*
 * class SpComboBox
 */

SpValue& SpComboBox::make()
{
    SpComboBox* box = new SpComboBox(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(box);
//    return result;
    return SpObjectResult(box);
}

// Caption
SpValue& SpComboBox::getCaption(NSObject* w)
{
    throw SpException("can't get combobox.caption");
}

void SpComboBox::setCaption(NSObject* w, const char* str)
{
    throw SpException("can't set combobox.caption");
}

void SpComboBox::creation(SpValue& parentNS, NSObject* p)
{
    parentNameSpace = parentNS;
    parent = p;
    SpNameSpace* assoc = ns.asNameSpace();
    SpNSComboBox* cbox = [[SpNSComboBox alloc] initWithNameSpace:assoc parent:parent comp:this];
    widget = (NSObject*)cbox;
    [[parent contentView] addSubview: (NSView*)cbox];
    [cbox setAutoresizesSubviews:NO];
    [cbox setAutoresizingMask: NSViewMinYMargin];
    [cbox setTarget: (id)cbox];
    [cbox setAction:@selector(change:)];

    // set self
    SpValue self(this);
    assoc->internConst(SymSelf, self);

    // set text
    SpValue vtext  = assoc->lookup(SymText);
    if(vtext.isString()){
      [(SpNSComboBox*)widget setTitle: [NSString stringWithCString:vtext.toCString()]];
    }

    // set items
    SpValue vitems = assoc->lookup(SymItems);
    if(vitems.isList()){
        while(!vitems.isNil()){
            SpList* ptr = vitems.asList();
            //[(SpNSComboBox*)widget addItemWithTitle: [NSString stringWithCString:ptr->value().toCString()]];
            [(SpNSComboBox*)widget addItemWithObjectValue: [NSString stringWithCString:ptr->value().toCString()]];
            vitems = ptr->nextList();
        }
    }

    initProperties(assoc); // SpComponent::initProperties
}

// primitives
SpValue& SpComboBox::primGetText()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result.setNewObject(new SpString([[(SpNSComboBox*)comp->widget stringValue] cString]));
//    return result;
    return SpObjectResult(new SpString([[(SpNSComboBox*)comp->widget stringValue] cString]));
}

SpValue& SpComboBox::primSetText(SpValue& v)
{
    if(v.isString()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
	[(SpNSComboBox*)comp->widget setStringValue: [NSString stringWithCString:v.toCString()]];
    }
    return TrueObject;
}

// init
static SpValue GetText;
static SpValue SetText;

void SpComboBox::initProperties(SpNameSpace* pNS)
{
    SpComponent::initProperties(pNS);
    // Text
    pNS->internPrimProperty(SymText, NilObject, GetText, SetText);
}

void SpComboBox::init()
{
    // set namespace to symbol 'std_comboBox'.
    PComboBoxNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    ComboBoxNS.setNewObject(PComboBoxNameSpace);
    SpValue SymStdComboBox(new SpSymbol("std_combobox"));
    PMainNameSpace->internConst(SymStdComboBox, ComboBoxNS);

    // set default top, left, width, height
    DefaultWidth.setInt(80);
    PComboBoxNameSpace->internConst(SymWidth, DefaultWidth);
    DefaultHeight.setInt(25);
    PComboBoxNameSpace->internConst(SymHeight, DefaultHeight);

    GetText.setNewObject(new SpPrim0(primGetText));
    SetText.setNewObject(new SpPrim1(primSetText));

    SpValue PrimMake(new SpPrim0(make));
    PComboBoxNameSpace->internFunc(SymMake, PrimMake);
}

