/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Component.mm,v 1.13 2004/05/10 12:52:12 randy Exp $
 */

#include "soopyg.h"

// class SpValue
SpComponent* SpValue::asComponent()
{
    if(!isComponent()){
        throw SpException("not component");
    }
    SpComponent* ptr = dynamic_cast<SpComponent*>(pObject);
    if(ptr == NULL){ throw SpException("system error"); }
    return ptr;
}

/*
 * class SpComponent
 */

void SpComponent::setAlign(Align a)
{
    if(a < alNone || alClient < a){
        throw SpException("illegal align");
    }
    align = a;
    //    resetAlignAllComponents();
}

void SpComponent::resetAlignAllComponents(NSView* parent)
{
  NSArray* ary = [[parent contentView] subviews];
  NSEnumerator *enumerator = [ary objectEnumerator];
  id anObject;
	
  NSRect parent_rect = [[parent contentView] frame];
  parent_rect.origin.x = 0;
  parent_rect.origin.y = 0;
  while(anObject = [enumerator nextObject]){
/*
    SpNameSpace* ns = [anObject getNameSpace];
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
*/
    SpComponent* comp = [anObject getSpComponent];
    comp->resetAlign(parent_rect);
  }
  [[parent contentView] setNeedsDisplay:YES];
}

void SpComponent::resetAlignParentComponents()
{
  resetAlignAllComponents((NSView*)parent);
}

void SpComponent::resetAlign(NSRect& parent_rect)
{
    NSRect rect = [(NSView*)widget frame];

    switch(align){
    case alNone:
      [widget setAutoresizingMask: NSViewMinYMargin];
      break;
    case alTop:
      //rect.origin.x = 0;
      //rect.origin.y = parent_rect.size.height - rect.size.height;
      rect.origin.x = parent_rect.origin.x;
      rect.origin.y = parent_rect.origin.y + parent_rect.size.height - rect.size.height;
      rect.size.width = parent_rect.size.width;
      [widget setFrame:rect];
      [widget setAutoresizingMask: NSViewMinYMargin | NSViewWidthSizable];
      // parent_rect - (top part)
      parent_rect.size.height -= rect.size.height;
      break;
    case alBottom:
      rect.origin.x = parent_rect.origin.x;
      rect.origin.y = parent_rect.origin.y;
      rect.size.width = parent_rect.size.width;
      [widget setFrame:rect];
      [widget setAutoresizingMask: NSViewMaxYMargin | NSViewWidthSizable];
      // parent_rect - (bottom part)
      parent_rect.origin.y += rect.size.height;
      parent_rect.size.height -= rect.size.height;
      break;
    case alLeft:
      rect.origin.x = parent_rect.origin.x;
      rect.origin.y = parent_rect.origin.y;
      rect.size.height = parent_rect.size.height;
      [widget setFrame:rect];
      [widget setAutoresizingMask: NSViewMaxXMargin | NSViewHeightSizable];
      // parent_rect - (left part)
      parent_rect.origin.x += rect.size.width;
      parent_rect.size.width -= rect.size.width;
      break;
    case alRight:
      rect.origin.x = parent_rect.origin.x + parent_rect.size.width - rect.size.width;
      rect.origin.y = parent_rect.origin.y;
      rect.size.height = parent_rect.size.height;
      [widget setFrame:rect];
      [widget setAutoresizingMask: NSViewMinXMargin | NSViewHeightSizable];
      // parent_rect - (right part)
      parent_rect.size.width -= rect.size.width;
      break;
    case alClient:
      rect.origin.x = parent_rect.origin.x;
      rect.origin.y = parent_rect.origin.y;
      rect.size.width = parent_rect.size.width;
      rect.size.height = parent_rect.size.height;
      [widget setFrame:rect];
      [widget setAutoresizingMask: NSViewWidthSizable | NSViewHeightSizable];
      parent_rect.size.width = 0;
      parent_rect.size.height = 0;
      break;
    }
    //    [[parent contentView] setNeedsDisplay:YES];
}

SpValue& SpComponent::primGetTop()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    NSRect parent_rect = [(NSView*)[comp->parent contentView] frame];
    NSRect rect = [(NSView*)comp->widget frame];
    float top = (parent_rect.size.height - rect.origin.y) - rect.size.height;
//    static SpValue result;
//    result.setInt(top);
//    return result;
    SpValue result;
    result.setInt(top);
    return SpValueResult(result);
}

SpValue& SpComponent::primSetTop(SpValue& v)
{
    if(v.isInt()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
	NSRect parent_rect = [(NSView*)[comp->parent contentView] frame];
	NSRect rect = [(NSView*)comp->widget frame];
        rect.origin.y = (parent_rect.size.height - v.getInt()) - rect.size.height;
        [comp->widget setFrame:rect];
	[[comp->parent contentView] setNeedsDisplay:YES];
    }
    return TrueObject;
}

SpValue& SpComponent::primGetLeft()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    NSRect rect = [(NSView*)comp->widget frame];
    float left = rect.origin.x;
//    static SpValue result;
//    result.setInt(left);
//    return result;
    SpValue result;
    result.setInt(left);
    return SpValueResult(result);
}

SpValue& SpComponent::primSetLeft(SpValue& v)
{
    if(v.isInt()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
	NSRect rect = [(NSView*)comp->widget frame];
        rect.origin.x = v.getInt();
        [comp->widget setFrame:rect];
	[[comp->parent contentView] setNeedsDisplay:YES];
    }
    return TrueObject;
}

SpValue& SpComponent::primGetWidth()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    NSRect rect = [(NSView*)comp->widget frame];
    float width = rect.size.width;
//    static SpValue result;
//    result.setInt(width);
//    return result;
    SpValue result;
    result.setInt(width);
    return SpValueResult(result);
}

SpValue& SpComponent::primSetWidth(SpValue& v)
{
    if(v.isInt()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
	NSRect rect = [(NSView*)comp->widget frame];
        rect.size.width = v.getInt();
        [comp->widget setFrame:rect];
	[[comp->parent contentView] setNeedsDisplay:YES];
    }
    return TrueObject;
}

SpValue& SpComponent::primGetHeight()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    NSRect rect = [(NSView*)comp->widget frame];
    float height = rect.size.height;
//    static SpValue result;
//    result.setInt(height);
//    return result;
    SpValue result;
    result.setInt(height);
    return SpValueResult(result);
}

SpValue& SpComponent::primSetHeight(SpValue& v)
{
    if(v.isInt()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
	NSRect rect = [(NSView*)comp->widget frame];
	float height = v.getInt();
	float top = rect.origin.y - (height - rect.size.height);
	rect.origin.y = top;
	rect.size.height = height;
        [comp->widget setFrame:rect];
	[[comp->parent contentView] setNeedsDisplay:YES];
    }
    return TrueObject;
}


// Parent
SpValue& SpComponent::primGetParent()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result = comp->parentNameSpace;
//    return result;
    SpValue result;
    result = comp->parentNameSpace;
    return SpValueResult(result);
}

// Caption
SpValue& SpComponent::primGetCaption()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result = comp->getCaption(comp->widget);
//    return result;
    SpValue result;
    result = comp->getCaption(comp->widget);
    return SpValueResult(result);
}

SpValue& SpComponent::primSetCaption(SpValue& v)
{
    if(v.isString()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        comp->setCaption(comp->widget, v.toCString());
    }
    return TrueObject;
}

// Align
SpValue& SpComponent::primGetAlign()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result.setInt(comp->align);
//    return result;
    SpValue result;
    result.setInt(comp->align);
    return SpValueResult(result);
}

SpValue& SpComponent::primSetAlign(SpValue& v)
{
    if(v.isInt()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        SpInt a = v.getInt();
        comp->setAlign(a);
	comp->resetAlignParentComponents();
    }
    return TrueObject;
}

//
//
//
void SpComponent::after_creation()
{
    // call fun onCreate()
    SpNameSpace* assoc = ns.asNameSpace();
    SpValue onCreate = assoc->lookup(SymOnCreate);
    if(onCreate.isFunc()){
        SpFunc* f = onCreate.asFunc();
        (*f)(NilObject);
    }
}

/*
void SpComponent::after_creation(SpNameSpace* assoc, SpValue& parentNS, TWidgetControl* parent, TWidgetControl* child)
{
    SpValue vtop    = assoc->lookup(SymTop);
    SpValue vleft   = assoc->lookup(SymLeft);
    SpValue vwidth  = assoc->lookup(SymWidth);
    SpValue vheight = assoc->lookup(SymHeight);
    SpValue valign  = assoc->lookup(SymAlign);

    SpInt top    = vtop.asInt();
    SpInt left   = vleft.asInt();
    SpInt width  = vwidth.asInt();
    SpInt height = vheight.asInt();
    SpInt align  = valign.asInt();

    if(parent != NULL){
        child->Parent = parent;
    }
    child->Top = top;
    child->Left = left;
    child->Width = width;
    child->Height = height;
    child->Align = align;

    //SpValue vcaption  = assoc->lookup(SymCaption);
    SpValue vcaption  = assoc->lookup1(SymCaption);
    if(vcaption.isString()){
        setCaption(child, vcaption.toCString());
    }

    parentNameSpace = parentNS;
}
*/

SpValue& SpComponent::toString()
{
    SpString* str;

    str = new SpString("<a ");
    *str += typeString();
    *str += (">");
//    static SpValue s;
//    s.setNewObject(str);
//    return s;
    return SpObjectResult(str);
}

// init
static SpValue GetTop;
static SpValue SetTop;
static SpValue GetLeft;
static SpValue SetLeft;
static SpValue GetWidth;
static SpValue SetWidth;
static SpValue GetHeight;
static SpValue SetHeight;
static SpValue SpGetParent;
static SpValue GetCaption;
static SpValue SetCaption;
static SpValue GetAlign;
static SpValue SetAlign;

void SpComponent::initProperties(SpNameSpace* ns)
{
    // Top
    ns->internPrimProperty(SymTop, NilObject, GetTop, SetTop);
    // Left
    ns->internPrimProperty(SymLeft, NilObject, GetLeft, SetLeft);
    // Width
    ns->internPrimProperty(SymWidth, NilObject, GetWidth, SetWidth);
    // Height
    ns->internPrimProperty(SymHeight, NilObject, GetHeight, SetHeight);
    // Parent
    ns->internPrimProperty(SymParent, NilObject, SpGetParent, NilObject);
    // Caption
    ns->internPrimProperty(SymCaption, NilObject, GetCaption, SetCaption);
    // Align
    ns->internPrimProperty(SymAlign, NilObject, GetAlign, SetAlign);

    after_creation();
}

void SpComponent::init()
{
    // init prims
    GetTop.setNewObject(new SpPrim0(primGetTop));
    SetTop.setNewObject(new SpPrim1(primSetTop));

    GetLeft.setNewObject(new SpPrim0(primGetLeft));
    SetLeft.setNewObject(new SpPrim1(primSetLeft));

    GetWidth.setNewObject(new SpPrim0(primGetWidth));
    SetWidth.setNewObject(new SpPrim1(primSetWidth));
    GetHeight.setNewObject(new SpPrim0(primGetHeight));
    SetHeight.setNewObject(new SpPrim1(primSetHeight));
    SpGetParent.setNewObject(new SpPrim0(primGetParent));
    GetCaption.setNewObject(new SpPrim0(primGetCaption));
    SetCaption.setNewObject(new SpPrim1(primSetCaption));
    GetAlign.setNewObject(new SpPrim0(primGetAlign));
    SetAlign.setNewObject(new SpPrim1(primSetAlign));
}

