/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Field.mm,v 1.8 2004/05/10 12:52:12 randy Exp $
 */

#include "soopyg.h"

/*
 * class SpNSField
 */
@implementation SpNSField

//-(id)initWithNameSpace:(SpNameSpace*)assoc parent: parent
-(id)initWithNameSpace:(SpNameSpace*)assoc parent:(NSObject*)parent comp:(SpComponent*)spc
{
    [super initWithNameSpace:assoc parent:parent comp:spc];
    return self;
}

@end

/*
 * class SpField
 */

SpValue& SpField::make()
{
    SpField* field = new SpField(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(field);
//    return result;
    return SpObjectResult(field);
}

void SpField::creation(SpValue& parentNS, NSObject* p)
{
    parentNameSpace = parentNS;
    parent = p;
    SpNameSpace* assoc = ns.asNameSpace();
    SpNSField* field = [[SpNSField alloc] initWithNameSpace:assoc parent:parent comp:this];
    widget = (NSObject*)field;
    [[parent contentView] addSubview: (NSView*)field];
    [field setAutoresizesSubviews:NO];
    [field setAutoresizingMask: NSViewMinYMargin];
    [field setTarget: (id)field];
    [field setAction:@selector(change:)];

    // set text
    SpValue vtext = assoc->lookup(SymText);
    if(vtext.isString()){
      [widget setStringValue: [NSString stringWithCString: vtext.toCString()]];
    }else{
      [widget setStringValue: [NSString stringWithCString: typeString()]];
    }

    // set self
    SpValue self(this);
    assoc->internConst(SymSelf, self);

    // set align
    SpValue valign  = assoc->lookup(SymAlign);
    setAlign(valign.asInt());

    initProperties(assoc); // SpComponent::initProperties
}

// primitives
SpValue& SpField::primGetText()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result.setNewObject(new SpString([[(SpNSField*)comp->widget stringValue] cString]));
//    return result;
    return SpObjectResult(new SpString([[(SpNSField*)comp->widget stringValue] cString]));
}

SpValue& SpField::primSetText(SpValue& v)
{
    if(v.isString()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
	[(SpNSField*)comp->widget setStringValue: [NSString stringWithCString:v.toCString()]];
    }
    return TrueObject;
}

// init
static SpValue GetText;
static SpValue SetText;

void SpField::initProperties(SpNameSpace* pNS)
{
    SpComponent::initProperties(pNS);
    // Text
    pNS->internPrimProperty(SymText, NilObject, GetText, SetText);
}

void SpField::init()
{
    // set namespace to symbol 'std_field'.
    PFieldNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    FieldNS.setNewObject(PFieldNameSpace);
    SpValue SymStdField(new SpSymbol("std_field"));
    PMainNameSpace->internConst(SymStdField, FieldNS);

    GetText.setNewObject(new SpPrim0(primGetText));
    SetText.setNewObject(new SpPrim1(primSetText));

    SpValue PrimMake(new SpPrim0(make));
    PFieldNameSpace->internFunc(SymMake, PrimMake);
}

