/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Label.mm,v 1.7 2004/05/10 12:52:12 randy Exp $
 */

#include "soopyg.h"

/*
 * class SpNSTextField
 */
@implementation SpNSTextField

//-(id)initWithNameSpace:(SpNameSpace*)assoc parent: parent
-(id)initWithNameSpace:(SpNameSpace*)assoc parent:(NSObject*)parent comp:(SpComponent*)spc
{
    ns = assoc;
    spcomp = spc;
    // set window origin & size
    SpValue vtop = assoc->lookup(SymTop);
    SpValue vleft = assoc->lookup(SymLeft);
    SpValue vwidth = assoc->lookup(SymWidth);
    SpValue vheight = assoc->lookup(SymHeight);

    NSRect rect = [(NSView*)[parent contentView] frame];
    float left = (float)vleft.getInt();
    float width = (float)vwidth.getInt();
    float height = (float)vheight.getInt();
    float top = rect.size.height - (float)vtop.getInt() - height;
    [self initWithFrame: NSMakeRect(left, top, width, height)];

    return self;
}

-(SpNameSpace*)getNameSpace
{
  return ns;
}

-(SpComponent*)getSpComponent
{
  return spcomp;
}

-(void)mouseUp:(NSEvent*)event
{
    if([event clickCount] == 1){
      SpValue onClick  = ns->lookup(SymOnClick);
      if(onClick.isFunc()){
        SpFunc* f = onClick.asFunc();
        (*f)(NilObject);
      }
    }else if([event clickCount] == 2){ // Double click
      SpValue onDblClick  = ns->lookup(SymOnDblClick);
      if(onDblClick.isFunc()){
        SpFunc* f = onDblClick.asFunc();
        (*f)(NilObject);
      }
    }
}

-(void)change:(NSObject*)sender
{
    SpValue onChange  = ns->lookup(SymOnChange);
    if(onChange.isFunc()){
        SpFunc* f = onChange.asFunc();
        (*f)(NilObject);
    }
}

@end

/*
 * class SpTextField
 */

// Caption
SpValue& SpTextField::getCaption(NSObject* w)
{
//    static SpValue result;
//    result.setNewObject(new SpString([[w stringValue] cString]));
//    return result;
    return SpObjectResult(new SpString([[w stringValue] cString]));
}

void SpTextField::setCaption(NSObject* w, const char* str)
{
    [w setStringValue: [NSString stringWithCString: str]];
}

/*
 * class SpNSLabel
 */
@implementation SpNSLabel

//-(id)initWithNameSpace:(SpNameSpace*)assoc parent: parent
-(id)initWithNameSpace:(SpNameSpace*)assoc parent:(NSObject*)parent comp:(SpComponent*)spc
{
    [super initWithNameSpace:assoc parent:parent comp:spc];
    [self setSelectable:NO];
    [self setBezeled:NO];
    [self setBordered:NO];
    [self setDrawsBackground:NO];
    return self;
}

@end

/*
 * class SpLabel
 */

SpValue& SpLabel::make()
{
    SpLabel* label = new SpLabel(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(label);
//    return result;
    return SpObjectResult(label);
}

void SpLabel::creation(SpValue& parentNS, NSObject* p)
{
    parentNameSpace = parentNS;
    parent = p;
    SpNameSpace* assoc = ns.asNameSpace();
    SpNSLabel* label = [[SpNSLabel alloc] initWithNameSpace:assoc parent:parent comp:this];
    widget = (NSObject*)label;
    [[parent contentView] addSubview: (NSView*)label];
    [label setAutoresizesSubviews:NO];
    [label setAutoresizingMask: NSViewMinYMargin];
    [label setTarget: (id)label];
    [label setAction:@selector(change:)];

    // set title
    SpValue vcaption = assoc->lookup(SymCaption);
    if(vcaption.isString()){
      [widget setStringValue: [NSString stringWithCString: vcaption.toCString()]];
    }else{
      [widget setStringValue: [NSString stringWithCString: typeString()]];
    }

    // set self
    SpValue self(this);
    assoc->internConst(SymSelf, self);

    // set align
    SpValue valign  = assoc->lookup(SymAlign);
    setAlign(valign.asInt());

    initProperties(assoc); // SpComponent::initProperties
}

void SpLabel::init()
{
    // set namespace to symbol 'std_label'.
    PLabelNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    LabelNS.setNewObject(PLabelNameSpace);
    SpValue SymStdLabel(new SpSymbol("std_label"));
    PMainNameSpace->internConst(SymStdLabel, LabelNS);

    SpValue PrimMake(new SpPrim0(make));
    PLabelNameSpace->internFunc(SymMake, PrimMake);
}

