/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: OpenDlg.mm,v 1.2 2004/05/10 12:52:12 randy Exp $
 */

#include "soopyg.h"

/*
 * class SpOpenDialog
 */

// Caption
SpValue& SpOpenDialog::getCaption(NSObject* w)
{
//    static SpValue result;
//    result.setNewObject(new SpString([[w title] cString]));
//    return result;
    return SpObjectResult(new SpString([[w title] cString]));
}

void SpOpenDialog::setCaption(NSObject* w, const char* str)
{
    [w setTitle: [NSString stringWithCString: str]];
}

SpValue& SpOpenDialog::primGetFilename()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result.setNewObject(new SpString([[(NSOpenPanel*)comp->widget filename] cString]));
//    return result;
    return SpObjectResult(new SpString([[(NSOpenPanel*)comp->widget filename] cString]));
}

/*
SpValue& SpOpenDialog::primGetFilenames()
{
}
*/

// creation
void SpOpenDialog::creation(SpValue& parentNS, NSObject* p)
{
    SpNameSpace* assoc = ns.asNameSpace();
    widget = [NSOpenPanel openPanel];

    // set self
    SpValue self(this);
    assoc->internConst(SymSelf, self);

    initProperties(assoc);
}

SpValue& SpOpenDialog::make()
{
    SpOpenDialog* win = new SpOpenDialog(getCurrentNS());
    SpValue taker(win);
    //win->creation(getCurrentNS(), Application->MainForm);
    win->creation(getCurrentNS(), NULL);

    // execute dialog
    NSOpenPanel* op = (NSOpenPanel*)win->widget;
    int status = [op runModal];
    if(status == NSOKButton){
        SpNameSpace* assoc = win->ns.asNameSpace();
        assoc->internVar(SymCanceledP, FalseObject);
    }

    return win->ns;
}

// init
static SpValue GetFilename;
static SpValue GetFilenames;

void SpOpenDialog::initProperties(SpNameSpace* pNS)
{
//    SpComponent::initProperties(pNS);

    // filename, filenames
    pNS->internPrimProperty(SymFilename, NilObject, GetFilename, NilObject);
//    pNS->internPrimProperty(SymFilenames, NilObject, GetFilenames, NilObject);
    //
    pNS->internVar(SymCanceledP, TrueObject);
}

void SpOpenDialog::init()
{
    // set namespace to symbol 'std_opendialog'.
    POpenDialogNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    OpenDialogNS.setNewObject(POpenDialogNameSpace);
    SpValue SymStdOpenDialog(new SpSymbol("std_opendialog"));
    PMainNameSpace->internConst(SymStdOpenDialog, OpenDialogNS);

    GetFilename.setNewObject(new SpPrim0(primGetFilename));
//    GetFilenames.setNewObject(new SpPrim0(primGetFilenames));

    SpValue PrimMake(new SpPrim0(make));
    POpenDialogNameSpace->internFunc(SymMake, PrimMake);
}

