/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: SaveDlg.mm,v 1.2 2004/05/10 12:52:12 randy Exp $
 */

#include "soopyg.h"

/*
 * class SpSaveDialog
 */

// Caption
SpValue& SpSaveDialog::getCaption(NSObject* w)
{
//    static SpValue result;
//    result.setNewObject(new SpString([[w title] cString]));
//    return result;
    return SpObjectResult(new SpString([[w title] cString]));
}

void SpSaveDialog::setCaption(NSObject* w, const char* str)
{
    [w setTitle: [NSString stringWithCString: str]];
}

SpValue& SpSaveDialog::primGetFilename()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result.setNewObject(new SpString([[(NSSavePanel*)comp->widget filename] cString]));
//    return result;
    return SpObjectResult(new SpString([[(NSSavePanel*)comp->widget filename] cString]));
}

/*
SpValue& SpSaveDialog::primGetFilenames()
{
}
*/

// creation
void SpSaveDialog::creation(SpValue& parentNS, NSObject* p)
{
    SpNameSpace* assoc = ns.asNameSpace();
    widget = [NSSavePanel savePanel];

    // set self
    SpValue self(this);
    assoc->internConst(SymSelf, self);

    initProperties(assoc);
}

SpValue& SpSaveDialog::make()
{
    SpSaveDialog* win = new SpSaveDialog(getCurrentNS());
    SpValue taker(win);
    //    win->creation(getCurrentNS(), Application->MainForm);
    win->creation(getCurrentNS(), NULL);

    // execute dialog
    NSSavePanel* sp = (NSSavePanel*)win->widget;
    int status = [sp runModal];
    if(status == NSOKButton){
        SpNameSpace* assoc = win->ns.asNameSpace();
        assoc->internVar(SymCanceledP, FalseObject);
    }

    return win->ns;
}

// init
static SpValue GetFilename;
static SpValue GetFilenames;

void SpSaveDialog::initProperties(SpNameSpace* pNS)
{
//    SpComponent::initProperties(pNS);

    // filename, filenames
    pNS->internPrimProperty(SymFilename, NilObject, GetFilename, NilObject);
//    pNS->internPrimProperty(SymFilenames, NilObject, GetFilenames, NilObject);
    //
    pNS->internVar(SymCanceledP, TrueObject);
}

void SpSaveDialog::init()
{
    // set namespace to symbol 'std_savedialog'.
    PSaveDialogNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    SaveDialogNS.setNewObject(PSaveDialogNameSpace);
    SpValue SymStdSaveDialog(new SpSymbol("std_savedialog"));
    PMainNameSpace->internConst(SymStdSaveDialog, SaveDialogNS);

    GetFilename.setNewObject(new SpPrim0(primGetFilename));
//    GetFilenames.setNewObject(new SpPrim0(primGetFilenames));

    SpValue PrimMake(new SpPrim0(make));
    PSaveDialogNameSpace->internFunc(SymMake, PrimMake);
}

