/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: soopyg.mm,v 1.23 2004/05/15 12:15:03 randy Exp $
 */

#import "soopyg.h"

extern SpValue& load(const char* filename);
extern int interaction(bool p=true);

SpValue SymTop;
SpValue SymLeft;
SpValue SymWidth;
SpValue SymHeight;
SpValue SymComponents;
SpValue SymTitle;
SpValue SymCaption;
SpValue SymMake;
SpValue SymOnClick;
SpValue SymOnDblClick;
SpValue SymParent;
SpValue SymAlign;
SpValue SymText;
SpValue SymOnChange;
SpValue SymClear;
SpValue SymCheckedP;
SpValue SymCanceledP;
SpValue SymFilename;
SpValue SymFilenames;
SpValue SymItems;
SpValue SymModifiedP;
SpValue SymMessage;
SpValue SymIndex;
SpValue SymTable;
SpValue SymRow;
SpValue SymCol;
SpValue SymRows;
SpValue SymCols;
SpValue SymHeader;
SpValue SymOnCreate;

SpValue AlNone(alNone);
SpValue AlTop(alTop);
SpValue AlBottom(alBottom);
SpValue AlLeft(alLeft);
SpValue AlRight(alRight);
SpValue AlClient(alClient);

SpNameSpace* PComponentNameSpace;
SpValue ComponentNS;
SpNameSpace* PLabelNameSpace;
SpValue LabelNS;
SpNameSpace* PFieldNameSpace;
SpValue FieldNS;
SpNameSpace* PWindowNameSpace;
SpValue WindowNS;
SpNameSpace* PPanelNameSpace;
SpValue PanelNS;
SpNameSpace* PButtonNameSpace;
SpValue ButtonNS;
SpNameSpace* PEditNameSpace;
SpValue EditNS;
SpNameSpace* PCheckBoxNameSpace;
SpValue CheckBoxNS;
SpNameSpace* PSaveDialogNameSpace;
SpValue SaveDialogNS;
SpNameSpace* POpenDialogNameSpace;
SpValue OpenDialogNS;
SpNameSpace* PComboBoxNameSpace;
SpValue ComboBoxNS;
SpNameSpace* PListBoxNameSpace;
SpValue ListBoxNS;
SpNameSpace* PRadioGroupNameSpace;
SpValue RadioGroupNS;
SpNameSpace* PRadioButtonNameSpace;
SpValue RadioButtonNS;
SpNameSpace* PTableViewNameSpace;
SpValue TableViewNS;

SpValue DefaultTop;
SpValue DefaultLeft;
SpValue DefaultWidth;
SpValue DefaultHeight;


void initEtc()
{
    // set symbols
    SymTop.setNewObject(new SpSymbol("top"));
    SymLeft.setNewObject(new SpSymbol("left"));
    SymWidth.setNewObject(new SpSymbol("width"));
    SymHeight.setNewObject(new SpSymbol("height"));
    SymComponents.setNewObject(new SpSymbol("components"));
    SymTitle.setNewObject(new SpSymbol("title"));
    SymCaption.setNewObject(new SpSymbol("caption"));
    SymMake.setNewObject(new SpSymbol("make"));
    SymOnClick.setNewObject(new SpSymbol("onclick"));
    SymOnDblClick.setNewObject(new SpSymbol("ondblclick"));
    SymParent.setNewObject(new SpSymbol("parent"));;
    SymAlign.setNewObject(new SpSymbol("align"));
    SymText.setNewObject(new SpSymbol("text"));
    SymOnChange.setNewObject(new SpSymbol("onchange"));
    SymClear.setNewObject(new SpSymbol("clear"));
    SymCheckedP.setNewObject(new SpSymbol("checked?"));
    SymCanceledP.setNewObject(new SpSymbol("canceled?"));
    SymFilename.setNewObject(new SpSymbol("filename"));
    SymFilenames.setNewObject(new SpSymbol("filenames"));
    SymItems.setNewObject(new SpSymbol("items"));
    SymModifiedP.setNewObject(new SpSymbol("modified?"));
    SymMessage.setNewObject(new SpSymbol("message"));
    SymIndex.setNewObject(new SpSymbol("index"));
    SymTable.setNewObject(new SpSymbol("table"));
    SymRow.setNewObject(new SpSymbol("row"));
    SymCol.setNewObject(new SpSymbol("col"));
    SymRows.setNewObject(new SpSymbol("rows"));
    SymCols.setNewObject(new SpSymbol("cols"));
    SymHeader.setNewObject(new SpSymbol("header"));
    SymOnCreate.setNewObject(new SpSymbol("oncreate"));

    SpValue SymAlNone(new SpSymbol("alnone"));
    SpValue SymAlTop(new SpSymbol("altop"));
    SpValue SymAlBottom(new SpSymbol("albottom"));
    SpValue SymAlLeft(new SpSymbol("alleft"));
    SpValue SymAlRight(new SpSymbol("alright"));
    SpValue SymAlClient(new SpSymbol("alclient"));
    PMainNameSpace->internConst(SymAlNone, AlNone);
    PMainNameSpace->internConst(SymAlTop, AlTop);
    PMainNameSpace->internConst(SymAlBottom, AlBottom);
    PMainNameSpace->internConst(SymAlLeft, AlLeft);
    PMainNameSpace->internConst(SymAlRight, AlRight);
    PMainNameSpace->internConst(SymAlClient, AlClient);

    PComponentNameSpace = new SpNameSpace;
    ComponentNS.setNewObject(PComponentNameSpace);

    // set default top, left, width, height
    DefaultTop.setInt(0);
    PComponentNameSpace->internConst(SymTop, DefaultTop);
    DefaultLeft.setInt(0);
    PComponentNameSpace->internConst(SymLeft, DefaultLeft);
    DefaultWidth.setInt(50);
    PComponentNameSpace->internConst(SymWidth, DefaultWidth);
    DefaultHeight.setInt(20);
    PComponentNameSpace->internConst(SymHeight, DefaultHeight);
    // set default align to alNone
    PComponentNameSpace->internConst(SymAlign, AlNone);
}

void GuiInit()
{
    extern void initDialogs();

    initEtc();

    SpComponent::init();
    SpLabel::init();
    SpField::init();
    SpButton::init();
    SpCheckBox::init();
    SpRadioGroup::init();
    SpEdit::init();
    SpComboBox::init();
    SpListBox::init();
    SpTableView::init();
    SpPanel::init();
    SpWindow::init();
    SpSaveDialog::init();
    SpOpenDialog::init();
    initDialogs();
}

int main(int argc, char* argv[], char* env[])
{
    extern int yyparse();
    int status;

    SpInit(argc-2, argv+2, env);
    GuiInit();

    if(argc > 1){
        load(argv[1]);
    }else{
        status = interaction();
    }

    return status;
}

