
program = {
  comment:  "file copy in soopy2";
  author:   "$Author: randy $";
  date:     "$Date: 2004/03/27 05:59:44 $";
  revision: "$Revision: 1.6 $";

  fun usage(){
    do: println "usage: soopy cp.sp src_file dist_file";
  };

  fun with_openIn_file(filename, body){
    comment: "open input-file & eval body & close file";
    var: [fin];
    do: [
      fin = openIn filename;
      body eval(fin);
      fin close;
    ];
    rescue: fin close;
  };

  fun with_openOut_file(filename, body){
    comment: "open output-file & eval body & close file";
    var: [fout];
    do: [
      fout = openOut filename;
      body eval(fout);
      fout close;
    ];
    rescue: fout close;
  };

  fun copy(src, dist){
    comment: "copy file from src to dist";
    do: with_openIn_file src {
          arg: [fin];
          var: [ch];
          do: [
                with_openOut_file dist {
                  arg: [fout];
                  do: [
                    loop {
                      until: fin eof?;
                      do: [
                        ch = fin readChar;
                        fout writeChar ch;
                      ];
                    };
                  ];
                };
              ];
        };
  };

  /*
   * Main routine
   */
  fun main(){
    comment: "main routine";
    var: [files];
    do: [
      files = Soopy commandLine;
      match(files){
        [x,y]: copy(x,y);
        _:     usage();
      };
    ];
  };
};

program main();

