unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes,
  System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.Objects;

const
  Wid = 20;
  Hei = 20;
  Size = 32;
  Max = 10;

type
  TMapData = array [0 .. Wid - 1, 0 .. Hei - 1] of integer;

  TDir = (Left, Right, Up, Down);

  TDirs = set of TDir;

  TBeem = class(TObject)
  private
    FX: integer;
    FY: integer;
    FSpeed: integer;
  public
    constructor Create;
    property X: integer read FX write FX;
    property Y: integer read FY write FY;
    property Speed: integer read FSpeed write FSpeed;
  end;

  TChar = class(TBeem)
  private
    FDir: TDirs;
    procedure Clear;
  public
    constructor Create;
    property Dir: TDirs read FDir write FDir;
  end;

  TEnemy = class(TChar)
  private
    FIndex: integer;
    FAX: integer;
    FAY: integer;
    FSpeed: integer;
    FVisible: Boolean;
    FPattern: integer;
  protected
    FFlightData: TMapData;
    procedure Search;
    function HardSearch: Boolean;
    procedure Buffer;
    property AX: integer read FAX write FAX;
    property AY: integer read FAY write FAY;
    property Index: integer read FIndex write FIndex;
    property Pattern: integer read FPattern write FPattern;

  const
    Kind = 3;
    Span = 10;
  public
    constructor Create;
    procedure Clear;
    property Speed: integer read FSpeed write FSpeed;
    property Visible: Boolean read FVisible write FVisible;
  end;

  TAtack = record
    Interval: integer;
    Count: integer;
  end;

  TForm1 = class(TForm)
    PaintBox1: TPaintBox;
    Image1: TImage;
    Image2: TImage;
    Timer1: TTimer;
    procedure PaintBox1Paint(Sender: TObject; Canvas: TCanvas);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
      Shift: TShiftState);
    procedure FormKeyUp(Sender: TObject; var Key: Word; var KeyChar: Char;
      Shift: TShiftState);
  private
    { private 錾 }
  public
    { public 錾 }
    Length: integer;
    Enemy: integer;
    List: TList;
    Beem: Boolean;
    Atack: TList;
    Count: integer;
    function CheckCross: Boolean;
    procedure GameOver;
  end;

var
  Form1: TForm1;
  Char1: TChar;
  Param: TAtack = (Interval: 0; Count: 5);

implementation

{$R *.fmx}
{ TEnemy }

procedure TEnemy.Buffer;
const
  AData: array [0 .. Kind - 1] of TMapData = ((

    (0, 0, 0, 0, 0, 0, 0, 0, 27, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 26, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0),
    (0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0),
    (0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0),
    (0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0),
    (0, 0, 0, 0, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 18, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 15, 14, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)), (

    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 18),
    (0, 0, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 16, 0, 0),
    (0, 0, 0, 0, 5, 6, 0, 0, 0, 0, 0, 0, 0, 13, 14, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 7, 8, 0, 0, 11, 12, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 9, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)), (

    (0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 2, 0, 0, 0, 0, 3, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 4, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0))

    );
var
  i: integer;
  j: integer;
begin
  for i := 0 to Wid - 1 do
    for j := 0 to Hei - 1 do
      FFlightData[i, j] := AData[Pattern][j, i];
end;

procedure TEnemy.Clear;
begin
  Visible := false;
  inc(FPattern);
  if Kind = Pattern then
    Pattern := 0;
  Buffer;
  Index := 0;
  if HardSearch = true then
  begin
    X := AX * Size;
    Y := AY * Size;
    Search;
  end
  else
    Clear;
end;

constructor TEnemy.Create;
begin
  Speed := 4;
  Pattern := -1;
  Clear;
end;

function TForm1.CheckCross: Boolean;
var
  s: TEnemy;
  t: TBeem;
  i, j: integer;
begin
  for i := List.Count - 1 downto 0 do
  begin
    s := List[i];
    if (Char1.X < s.X + Size) and (Char1.X + Size > s.X) and
      (Char1.Y < s.Y + Size) and (Char1.Y + Size > s.Y) then
    begin
      result := true;
      List.Delete(i);
      s.Free;
      Char1.Clear;
    end;
  end;
  for i := Atack.Count - 1 downto 0 do
  begin
    t := Atack[i];
    for j := List.Count - 1 downto 0 do
    begin
      s := List[j];
      if (t.X < s.X + Size) and (t.X + Size > s.X) and (t.Y < s.Y + Size) and
        (t.Y + Size > s.Y) then
      begin
        Atack.Delete(i);
        t.Free;
        List.Delete(j);
        s.Free;
        break;
      end;
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Char1 := TChar.Create;
  List := TList.Create;
  Atack := TList.Create;
  ClientWidth := Wid * Size;
  ClientHeight := Hei * Size;
  Enemy := 10;
  Count := 5;
end;

procedure TForm1.FormDestroy(Sender: TObject);
var
  s: TEnemy;
  t: TChar;
  i: integer;
begin
  for i := 0 to List.Count - 1 do
  begin
    s := List[i];
    s.Free;
  end;
  for i := 0 to Atack.Count - 1 do
  begin
    t := Atack[i];
  end;
  List.Free;
  Atack.Free;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word; var KeyChar: Char;
  Shift: TShiftState);
begin
  case KeyChar of
    'q':
      Beem := true;
    'a':
      Char1.Dir := Char1.Dir + [TDir.Left];
    'd':
      Char1.Dir := Char1.Dir + [Right];
    'w':
      Char1.Dir := Char1.Dir + [Up];
    's':
      Char1.Dir := Char1.Dir + [Down];
  end;
end;

procedure TForm1.FormKeyUp(Sender: TObject; var Key: Word; var KeyChar: Char;
  Shift: TShiftState);
begin
  case KeyChar of
    'q':
      Beem := false;
    'a':
      Char1.Dir := Char1.Dir - [TDir.Left];
    'd':
      Char1.Dir := Char1.Dir - [Right];
    'w':
      Char1.Dir := Char1.Dir - [Up];
    's':
      Char1.Dir := Char1.Dir - [Down];
  end;
end;

procedure TForm1.GameOver;
begin
  dec(Count);
  if Count = 0 then
    Timer1.Enabled := false;
end;

procedure TForm1.PaintBox1Paint(Sender: TObject; Canvas: TCanvas);
var
  s: TEnemy;
  t: TBeem;
  i: integer;
begin
  Canvas.DrawBitmap(Image1.Bitmap, RectF(0, 0, Image1.Bitmap.Width,
    Image1.Bitmap.Height), RectF(0, -Image1.Bitmap.Height + Hei * Size + Length,
    Image1.Bitmap.Width, Hei * Size + Length), 1);
  for i := 0 to List.Count - 1 do
  begin
    s := List[i];
    if s.Visible = true then
      Canvas.DrawBitmap(Image2.Bitmap, RectF(Size, 0, 2 * Size, Size),
        RectF(s.X, s.Y, s.X + Size, s.Y + Size), 1);
  end;
  for i := 0 to Atack.Count - 1 do
  begin
    t := Atack[i];
    Canvas.DrawBitmap(Image2.Bitmap, RectF(2 * Size, 0, 3 * Size, Size),
      RectF(t.X, t.Y, t.X + Size, t.Y + Size), 1);
  end;
  Canvas.DrawBitmap(Image2.Bitmap, RectF(0, 0, Size, Size),
    RectF(Char1.X, Char1.Y, Char1.X + Size, Char1.Y + Size), 1);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
  i: integer;
  s: TEnemy;
  t: TBeem;
  X: Boolean;
begin
  X := false;
  if Length <= Image1.Bitmap.Height - Hei * Size then
  begin
    inc(Length);
    if Length >= Enemy then
    begin
      if List.Count = 0 then
        for i := 1 to 10 do
          List.Add(TEnemy.Create);
      X := true;
      for i := 0 to List.Count - 1 do
      begin
        s := List[i];
        if s.Visible = true then
        begin
          X := false;
          break;
        end;
      end;
    end;
  end
  else
    Length := 0;
  for i := 0 to List.Count - 1 do
  begin
    s := List[i];
    if s.Visible = true then
    begin
      if s.X > s.AX * Size then
        s.X := s.X - s.Speed
      else if s.X < s.AX * Size then
        s.X := s.X + s.Speed;
      if s.Y > s.AY * Size then
        s.Y := s.Y - s.Speed
      else if s.Y < s.AY * Size then
        s.Y := s.Y + s.Speed;
      if (s.X = s.AX * Size) and (s.Y = s.AY * Size) then
      begin
        s.Search;
        X := true;
      end;
    end
    else if X = true then
    begin
      s.Visible := true;
      X := false;
    end;
  end;
  if TDir.Left in Char1.Dir then
    Char1.X := Char1.X - 1;
  if Right in Char1.Dir then
    Char1.X := Char1.X + 1;
  if Up in Char1.Dir then
    Char1.Y := Char1.Y - 1;
  if Down in Char1.Dir then
    Char1.Y := Char1.Y + 1;
  for i := Atack.Count - 1 downto 0 do
  begin
    t := Atack[i];
    t.Y := t.Y - t.Speed;
    if (t.Y + Size) < 0 then
    begin
      Atack.Delete(i);
      t.Free;
    end;
  end;
  if Beem = true then
    if (Param.Interval = 0) and (Atack.Count < Param.Count) then
    begin
      Atack.Add(TBeem.Create);
      Param.Interval := 10;
    end;
  if Param.Interval > 0 then
    dec(Param.Interval);
  PaintBox1.Repaint;
  if CheckCross = true then
    GameOver;
end;

function TEnemy.HardSearch: Boolean;
var
  i, j: integer;
begin
  inc(FIndex);
  result := false;
  for i := 0 to Wid - 1 do
    for j := 0 to Hei - 1 do
      if FFlightData[i, j] = Index then
      begin
        AX := i;
        AY := j;
        result := true;
        Exit;
      end;
end;

procedure TEnemy.Search;
begin
  inc(FIndex);
  if FFlightData[AX - 1, AY - 1] = Index then
  begin
    AX := AX - 1;
    AY := AY - 1;
  end
  else if FFlightData[AX, AY - 1] = Index then
    AY := AY - 1
  else if FFlightData[AX - 1, AY] = Index then
    AX := AX - 1
  else if FFlightData[AX + 1, AY] = Index then
    AX := AX + 1
  else if FFlightData[AX - 1, AY + 1] = Index then
  begin
    AX := AX - 1;
    AY := AY + 1;
  end
  else if FFlightData[AX, AY + 1] = Index then
    AY := AY + 1
  else if FFlightData[AX + 1, AY + 1] = Index then
  begin
    AX := AX + 1;
    AY := AY + 1;
  end
  else
  begin
    dec(FIndex);
    if HardSearch = false then
      Clear;
  end;
end;

{ TChar }

procedure TChar.Clear;
begin
  X := Wid * Size div 2;
  Y := (Hei - 1) * Size;
end;

constructor TChar.Create;
begin
  Clear;
end;

{ TBeem }

constructor TBeem.Create;
begin
  FX := Char1.X;
  FY := Char1.Y - Size;
  FSpeed := 8;
end;

end.
