/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.security;

import flex.messaging.FlexContext;
import flex.messaging.security.AppServerLoginCommand;
import flex.messaging.security.SecurityException;
import flex.messaging.security.TomcatLogin;
import flex.messaging.security.TomcatLoginHolder;
import flex.messaging.util.PropertyStringResourceLoader;
import flex.messaging.util.ResourceLoader;
import java.security.Principal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class TomcatLoginCommand
extends AppServerLoginCommand {
    private static final int NO_VALVE = 20000;

    public Principal doAuthentication(String username, Object credentials) throws SecurityException {
        TomcatLogin login = TomcatLoginHolder.getLogin();
        if (login == null) {
            SecurityException se = new SecurityException((ResourceLoader)new PropertyStringResourceLoader("flex.messaging.vendors"));
            se.setMessage(20000);
            throw se;
        }
        String password = this.extractPassword(credentials);
        if (password != null) {
            HttpServletRequest request = FlexContext.getHttpRequest();
            return login.login(username, password, request);
        }
        return null;
    }

    public boolean doAuthorization(Principal principal, List roles) throws SecurityException {
        boolean authorized = false;
        HttpServletRequest request = FlexContext.getHttpRequest();
        if (request != null && principal != null && ((Object)principal).equals(request.getUserPrincipal())) {
            authorized = this.doAuthorization(principal, roles, request);
        } else {
            TomcatLogin login = TomcatLoginHolder.getLogin();
            if (login == null) {
                SecurityException se = new SecurityException((ResourceLoader)new PropertyStringResourceLoader("flex.messaging.vendors"));
                se.setMessage(20000);
                throw se;
            }
            authorized = login.authorize(principal, roles);
        }
        return authorized;
    }

    public boolean logout(Principal principal) throws SecurityException {
        TomcatLogin login;
        HttpServletRequest request = FlexContext.getHttpRequest();
        if (request != null && (login = TomcatLoginHolder.getLogin()) != null) {
            return login.logout(request);
        }
        return true;
    }
}

