/*
 * Decompiled with CFR 0.152.
 */
package flex2.linker;

import flex2.compiler.util.Visitor;
import flex2.linker.CULinkable;
import flex2.linker.Linkable;
import flex2.linker.LinkerException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import macromedia.abc.Optimizer;

public class DependencyWalker {
    public static void traverse(List defs, LinkState state, boolean allowExternal, boolean exportIncludes, Visitor v) throws LinkerException {
        String def;
        if (defs == null) {
            defs = new LinkedList<String>();
            Iterator it = state.getDefNames().iterator();
            while (it.hasNext()) {
                def = (String)it.next();
                if (state.getExternal().contains(def)) continue;
                defs.add(def);
            }
        }
        if (exportIncludes) {
            Iterator iterator = state.getIncludes().iterator();
            while (iterator.hasNext()) {
                def = (String)iterator.next();
                defs.add(def);
            }
        }
        Stack<LinkableContext> stack = new Stack<LinkableContext>();
        LinkedList<LinkableContext> queue = new LinkedList<LinkableContext>();
        Iterator it = defs.iterator();
        while (it.hasNext()) {
            String defname = (String)it.next();
            LinkableContext start = DependencyWalker.resolve(defname, state, allowExternal, exportIncludes);
            if (start == null) continue;
            queue.add(start);
        }
        while (!queue.isEmpty()) {
            LinkableContext qc = (LinkableContext)queue.removeFirst();
            if (qc.visited) continue;
            qc.progress = true;
            stack.push(qc);
            while (!stack.isEmpty()) {
                LinkableContext c = (LinkableContext)stack.peek();
                if (c.visited) {
                    stack.pop();
                    continue;
                }
                if (c.pi.hasNext()) {
                    LinkableContext prereq = DependencyWalker.resolve((String)c.pi.next(), state, allowExternal, exportIncludes);
                    if (prereq == null) continue;
                    if (prereq.progress) {
                        throw new LinkerException.CircularReferenceException(c.l.getName());
                    }
                    if (prereq.visited) continue;
                    prereq.progress = true;
                    stack.push(prereq);
                    continue;
                }
                v.visit(c.l);
                c.visited = true;
                c.progress = false;
                state.vmap.put(c.l.getName(), c.l);
                stack.pop();
                while (c.di.hasNext()) {
                    LinkableContext dc = DependencyWalker.resolve((String)c.di.next(), state, allowExternal, exportIncludes);
                    if (dc == null || dc.visited) continue;
                    queue.add(dc);
                }
            }
        }
    }

    static LinkableContext resolve(String name, LinkState state, boolean allowExternal, boolean exportIncludes) throws LinkerException {
        LinkableContext lc;
        if (allowExternal && state.extdefs != null && state.extdefs.contains(name)) {
            state.unresolved.add(name);
            return null;
        }
        if (!exportIncludes && state.includes != null && state.includes.contains(name)) {
            state.includes.remove(name);
        }
        if ((lc = (LinkableContext)state.defs.get(name)) == null) {
            if (state.unresolved == null) {
                throw new LinkerException.UndefinedSymbolException(name);
            }
            state.unresolved.add(name);
        } else {
            if (lc.l.isNative()) {
                state.unresolved.add(name);
                return null;
            }
            if (!allowExternal && state.extdefs.contains(name)) {
                state.extdefs.remove(name);
            }
            lc.activate();
        }
        return lc;
    }

    public static String dump(LinkState state) {
        StringBuffer buf = new StringBuffer(2048);
        buf.append("<report>\n");
        buf.append("  <scripts>\n");
        Iterator scripts = state.getVisitedLinkables().iterator();
        while (scripts.hasNext()) {
            CULinkable l = (CULinkable)scripts.next();
            buf.append("    <script name=\"").append(l.getName()).append("\" mod=\"").append(l.getLastModified()).append("\" size=\"").append(l.getSize()).append("\" optimizedsize=\"").append(Optimizer.optimize(l.getUnit().bytes).size()).append("\">\n");
            Iterator defs = l.getDefinitions();
            while (defs.hasNext()) {
                buf.append("      <def id=\"" + (String)defs.next() + "\" />\n");
            }
            Iterator pre = l.getPrerequisites();
            while (pre.hasNext()) {
                buf.append("      <pre id=\"" + (String)pre.next() + "\" />\n");
            }
            Iterator dep = l.getDependencies();
            while (dep.hasNext()) {
                buf.append("      <dep id=\"" + (String)dep.next() + "\" />\n");
            }
            buf.append("    </script>\n");
        }
        buf.append("  </scripts>\n");
        if (state.getExternal() != null || state.getUnresolved() != null) {
            buf.append("  <external-defs>\n");
            Iterator external = state.getExternal().iterator();
            while (external.hasNext()) {
                String ext = (String)external.next();
                if (!state.getUnresolved().contains(ext)) continue;
                buf.append("    <ext id=\"" + ext + "\" />\n");
            }
            Iterator unresolved = state.getUnresolved().iterator();
            while (unresolved.hasNext()) {
                String unr = (String)unresolved.next();
                if (state.getExternal().contains(unr)) continue;
                buf.append("    <missing id=\"" + unr + "\" />\n");
            }
            buf.append("  </external-defs>\n");
        }
        buf.append("</report>\n");
        return buf.toString();
    }

    private static class LinkableContext {
        public final Linkable l;
        public Iterator pi;
        public Iterator di;
        public boolean active = false;
        public boolean visited = false;
        public boolean progress = false;

        public LinkableContext(Linkable l) {
            this.l = l;
        }

        public void activate() {
            if (!this.active) {
                this.active = true;
                this.pi = this.l.getPrerequisites();
                this.di = this.l.getDependencies();
            }
        }

        public String toString() {
            return this.l.getName() + " " + (this.visited ? "v" : "") + (this.progress ? "p" : "");
        }
    }

    public static class LinkState {
        Map vmap = new HashMap();
        Map lmap = new HashMap();
        Map defs = new HashMap();
        Set extdefs;
        Set includes;
        Set unresolved;

        public LinkState(Collection linkables, Set extdefs, Set includes, Set unresolved) throws LinkerException {
            this.extdefs = extdefs;
            this.includes = includes;
            this.unresolved = unresolved;
            Iterator li = linkables.iterator();
            while (li.hasNext()) {
                Linkable l = (Linkable)li.next();
                if (this.lmap.containsKey(l.getName())) {
                    throw new LinkerException.DuplicateSymbolException(l.getName());
                }
                LinkableContext lc = new LinkableContext(l);
                this.lmap.put(l.getName(), lc);
                String external = null;
                Iterator di = l.getDefinitions();
                while (di.hasNext()) {
                    String def = (String)di.next();
                    LinkableContext c = (LinkableContext)this.defs.get(def);
                    if (c != null) {
                        throw new LinkerException.MultipleDefinitionsException(def, l.getName(), c.l.getName());
                    }
                    this.defs.put(def, lc);
                    if (extdefs.contains(def)) {
                        external = def;
                        continue;
                    }
                    if (external == null) continue;
                    throw new LinkerException.PartialExternsException(lc.l.getName(), def, external);
                }
            }
        }

        public Set getUnresolved() {
            return this.unresolved;
        }

        public Set getExternal() {
            return this.extdefs;
        }

        public Set getIncludes() {
            return this.includes;
        }

        public Set getDefNames() {
            return this.defs.keySet();
        }

        public Collection getLinkables() {
            return this.lmap.values();
        }

        public Collection getVisitedLinkables() {
            return this.vmap.values();
        }
    }
}

