/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.we_lab_doc.spacecard.utils

import org.codehaus.groovy.grails.plugins.PluginManagerHolder as PH
import org.codehaus.groovy.grails.plugins.GrailsPlugin

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: March 5, 2008
 */
final class PluginUtils {
    static GrailsPlugin[] getAllPlugins() {
    	return getPluginManager().getAllPlugins()
    }
	static def getPluginManager() {
		return PH.currentPluginManager()
	}
	static def getPlugin(name) {
		assert name != null
		def pm = getPluginManager()
		assert pm != null
		return pm.getGrailsPlugin(name)
	}
	static def getPluginInstance(name) {
		return getPlugin(name)?.instance
	}
	////
	private PluginUtils() {}
}