import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.utils.*

class OrganizationTests extends SpaceCardModelTestCase {

	
    void testDependsTo() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		assertNotNull "0", sv
		def svc = Organization.createCompany("hoge", "hogeDesc")
		assertNotNull svc
		assertTrue "0-1", ModelUtils.flush(svc)
		assertTrue "0-2", svc.addAdmin(sv) != null
		assertTrue "0-3", ModelUtils.flush(svc)
		assertTrue "0-3-1", sv.isAdmin(svc)		
		
		def sub1 = Organization.createSubOrganization("sub1", "desc", svc)
		assertNotNull "0-4", sub1
		def sub2 = Organization.createSubOrganization("sub2", "desc", sub1)
		assertNotNull "0-5",sub2
		assertTrue "1", ModelUtils.flush([sub1,sub2])
		def cardHolder = sub1.createCardHolder("name")
		assertTrue "1", ModelUtils.flush([sub1])
		assertTrue  "1-0", sub1.getCardHolder("name") != null
		def user = User.create("uma", "uma", "uma", "u", User.encodePassword("uma"),"hoge@hoge", true, "i")
		assertTrue "1-1", svc.addUser(user) != null
		assertTrue "1-2", ModelUtils.flush(svc)
		
		assertTrue "2", svc.belongsTo(sv)
		assertFalse "3", sub2.belongsTo(sv)
		assertFalse "4", sub2.deepBelongsTo(sv)
		assertTrue "4-1", sv.getBelongingOrganizations(true, true, null)?.size() == 2
		assertTrue "4-2", sv.getBelongingOrganizations(false, true, null)?.size() == 2
		assertTrue "4-3", sv.getBelongingOrganizations(true, false, null)?.size() == 0
		assertTrue "4-4", sv.getBelongingOrganizations(false, false, null)?.size() == 0
		assertTrue "4-5", svc.getUsers(true, true, null)?.size()  == 2
		assertTrue "4-6", svc.getUsers(true, false, null)?.size() == 1
		assertTrue "4-7", svc.getUsers(false, true, null)?.size()  == 2
		assertTrue "4-8", svc.getUsers(false, false, null)?.size() == 1
		assertTrue "4-9-1", svc.countOfUsers(true, true) == 2
		assertTrue "4-9-2", svc.countOfUsers(true, false) == 1
		assertTrue "4-9-3", svc.countOfUsers(false, true) == 2
		assertTrue "4-9-4", svc.countOfUsers(false, false) == 1
		assertTrue "4-9-5:${svc.countOfAdmins(true)}", svc.countOfAdmins(true) == 1
		assertTrue "4-9-6", svc.countOfAdmins(false) == 1
				
		assertTrue "5", svc.deactivate().id == svc.id
		assertTrue "6", svc.belongsTo(sv)
		assertTrue "7", svc.deepBelongsTo(sv)
		assertFalse "8", svc.belongsTo(sv, false)
		assertFalse "9", svc.deepBelongsTo(sv, false)			
		assertTrue "9-1", sv.getBelongingOrganizations(true, true, null)?.size()  == 2
		assertTrue "9-1-1", sv.countOfBelongingOrganizations(true, true) == 2
		assertTrue "9-2", sv.getBelongingOrganizations(false, true, null)?.size() == 1
		assertTrue "9-2-1", sv.countOfBelongingOrganizations(false, true) == 1
		assertTrue "9-3", sv.getBelongingOrganizations(true, false, null)?.size()  == 0
		assertTrue "9-3-1", sv.countOfBelongingOrganizations(true, false) == 0
		assertTrue "9-4", sv.getBelongingOrganizations(false, false, null)?.size() == 0
		assertTrue "9-4-1", sv.countOfBelongingOrganizations(false, false) == 0
		assertTrue "9-5", svc.getUsers(true, true, null)?.size()  == 2
		assertTrue "9-6", svc.getUsers(true, false, null)?.size() == 1
		assertTrue "9-7", svc.getUsers(false, true, null)?.size()  == 2
		assertTrue "9-8", svc.getUsers(false, false, null)?.size() == 1
		assertTrue "10", svc.activate().id == svc.id
		assertTrue "11", svc.belongsTo(sv)
		assertTrue "12", svc.deepBelongsTo(sv)
		assertTrue "12-1", sv.getBelongingOrganizations(true, true, null)?.size() == 2
		assertTrue "12-1-1", sv.countOfBelongingOrganizations(true, true) == 2				
		assertTrue "12-2", sv.getBelongingOrganizations(false, true, null)?.size() == 2
		assertTrue "12-2-1", sv.countOfBelongingOrganizations(false, true) == 2
		assertTrue "12-3", sv.getBelongingOrganizations(true, false, null)?.size() == 0
		assertTrue "13-3-1", sv.countOfBelongingOrganizations(true, false) == 0				
		assertTrue "12-4", sv.getBelongingOrganizations(false, false, null)?.size() == 0
		assertTrue "12-4-1", sv.countOfBelongingOrganizations(false, false) == 0				
		assertTrue "12-5", svc.getUsers(true, true, null)?.size()  == 2
		assertTrue "12-6", svc.getUsers(true, false, null)?.size() == 1
		assertTrue "12-7", svc.getUsers(false, true, null)?.size()  == 2
		assertTrue "12-8", svc.getUsers(false, false, null)?.size() == 1
		assertTrue "13", svc.belongsTo(sv, false)
		assertTrue "14", svc.deepBelongsTo(sv, false)
		user.deactivate()
		assertTrue "15", ModelUtils.flush([sv])		
		assertTrue "16-1", svc.countOfUsers(true, true) == 2
		assertTrue "16-2", svc.countOfUsers(true, false) == 1
		assertTrue "16-1", svc.countOfUsers(false, true) == 1
		assertTrue "16-2", svc.countOfUsers(false, false) == 0
    }
}
