/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.GlyphBBoxCalculator;
import com.adobe.fontengine.font.GlyphBBoxOutlineConsumer;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.TTParser;
import com.adobe.fontengine.font.opentype.TTScaler;

public class TrueTypeGlyphBBoxCalculator
implements GlyphBBoxCalculator {
    private final boolean hinted;
    private final int scaling;

    TrueTypeGlyphBBoxCalculator(boolean bl, int n) throws InvalidFontException, UnsupportedFontException {
        this.hinted = bl;
        this.scaling = n;
    }

    public Rect calculateBBox(FontData fontData, int n) throws InvalidFontException, UnsupportedFontException {
        GlyphBBoxOutlineConsumer glyphBBoxOutlineConsumer;
        if (this.hinted) {
            TTScaler tTScaler = new TTScaler((OpenTypeFont)fontData, null);
            tTScaler.setScale(this.scaling, this.scaling, this.scaling, 0.0, 0.0);
            glyphBBoxOutlineConsumer = new GlyphBBoxOutlineConsumer(Matrix.IDENTITY_MATRIX);
            glyphBBoxOutlineConsumer.reset();
            glyphBBoxOutlineConsumer.setMatrix(Matrix.IDENTITY_MATRIX);
            tTScaler.getOutline(n, glyphBBoxOutlineConsumer);
        } else {
            glyphBBoxOutlineConsumer = new GlyphBBoxOutlineConsumer(new Matrix(this.scaling, 0.0, 0.0, this.scaling, 0.0, 0.0));
            glyphBBoxOutlineConsumer.reset();
            TTParser tTParser = new TTParser();
            tTParser.parse((OpenTypeFont)fontData, n, glyphBBoxOutlineConsumer);
        }
        return glyphBBoxOutlineConsumer.getBBox();
    }
}

