/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.impl;

import com.adobe.agl.converters.UConverter;
import com.adobe.agl.converters.UErrorCode;
import com.adobe.agl.impl.ICUDebug;
import com.adobe.agl.impl.UConverterDataReader;
import com.adobe.agl.impl.UConverterExt;
import com.adobe.agl.impl.UConverterFromUnicodeArgs;
import com.adobe.agl.impl.UConverterLoadArgs;
import com.adobe.agl.impl.UConverterSharedData;
import com.adobe.agl.impl.UConverterToUnicodeArgs;
import com.adobe.agl.impl.UConverterUTF;
import com.adobe.agl.impl.UConverterUTF16;
import java.io.IOException;
import java.nio.ByteBuffer;

class UConverterSharedData_MBCS
extends UConverterSharedData {
    private static final boolean debug = ICUDebug.enabled("UConverterSharedData_MBCS");
    public static final int MBCS_MAX_STATE_COUNT = 128;
    public static final int MBCS_STATE_VALID_DIRECT_16 = 0;
    public static final int MBCS_STATE_VALID_DIRECT_20 = 1;
    public static final int MBCS_STATE_FALLBACK_DIRECT_16 = 2;
    public static final int MBCS_STATE_FALLBACK_DIRECT_20 = 3;
    public static final int MBCS_STATE_VALID_16 = 4;
    public static final int MBCS_STATE_VALID_16_PAIR = 5;
    public static final int MBCS_STATE_UNASSIGNED = 6;
    public static final int MBCS_STATE_ILLEGAL = 7;
    public static final int MBCS_STATE_CHANGE_ONLY = 8;
    public static final int MBCS_OUTPUT_1 = 0;
    public static final int MBCS_OUTPUT_2 = 1;
    public static final int MBCS_OUTPUT_3 = 2;
    public static final int MBCS_OUTPUT_4 = 3;
    public static final int MBCS_OUTPUT_3_EUC = 8;
    public static final int MBCS_OUTPUT_4_EUC = 9;
    public static final int MBCS_OUTPUT_2_SISO = 12;
    public static final int MBCS_OUTPUT_2_HZ = 13;
    public static final int MBCS_OUTPUT_EXT_ONLY = 14;
    public static final int MBCS_OUTPUT_COUNT = 15;
    public static final int MBCS_OUTPUT_DBCS_ONLY = 219;
    static final long LINEAR_18030_BASE = UConverterSharedData_MBCS.LINEAR_18030(129L, 48L, 129L, 48L);
    static final long[][] gb18030Ranges = new long[][]{{65536L, 0x10FFFFL, UConverterSharedData_MBCS.LINEAR(2419097904L), UConverterSharedData_MBCS.LINEAR(3811744309L)}, {40870L, 55295L, UConverterSharedData_MBCS.LINEAR(2184548147L), UConverterSharedData_MBCS.LINEAR(2201405240L)}, {1106L, 8207L, UConverterSharedData_MBCS.LINEAR(2167460656L), UConverterSharedData_MBCS.LINEAR(2167842097L)}, {59493L, 63787L, UConverterSharedData_MBCS.LINEAR(2201407536L), UConverterSharedData_MBCS.LINEAR(2217772340L)}, {9795L, 11904L, UConverterSharedData_MBCS.LINEAR(2167908409L), UConverterSharedData_MBCS.LINEAR(2167995704L)}, {64042L, 65071L, UConverterSharedData_MBCS.LINEAR(2217778232L), UConverterSharedData_MBCS.LINEAR(2217837879L)}, {15585L, 16469L, UConverterSharedData_MBCS.LINEAR(2184303672L), UConverterSharedData_MBCS.LINEAR(2184359730L)}, {13851L, 14615L, UConverterSharedData_MBCS.LINEAR(2184226355L), UConverterSharedData_MBCS.LINEAR(2184245815L)}, {18872L, 19574L, UConverterSharedData_MBCS.LINEAR(2184487217L), UConverterSharedData_MBCS.LINEAR(2184505139L)}, {16736L, 17206L, UConverterSharedData_MBCS.LINEAR(2184366391L), UConverterSharedData_MBCS.LINEAR(2184378423L)}, {18318L, 18758L, UConverterSharedData_MBCS.LINEAR(2184439864L), UConverterSharedData_MBCS.LINEAR(2184484408L)}, {17623L, 17995L, UConverterSharedData_MBCS.LINEAR(2184422201L), UConverterSharedData_MBCS.LINEAR(2184431921L)}, {65510L, 65535L, UConverterSharedData_MBCS.LINEAR(2217845300L), UConverterSharedData_MBCS.LINEAR(2217845817L)}};
    public static final int _MBCS_OPTION_GB18030 = 32768;

    public UConverterSharedData_MBCS(UConverterDataReader r) {
        super(100, 1, null, false, 0L);
        this.dataReader = r;
    }

    protected void doOpen(UConverter cnv, String name, String locale, long options, int[] pErrorCode) {
        this.ucnv_MBCSOpen(cnv, name, locale, options, pErrorCode);
    }

    protected void doToUnicode(UConverterToUnicodeArgs args, int[] pErrorCode) {
        this.ucnv_MBCSToUnicodeWithOffsets(args, pErrorCode);
    }

    protected void doFromUnicode(UConverterFromUnicodeArgs args, int[] pErrorCode) {
        this.ucnv_MBCSFromUnicodeWithOffsets(args, pErrorCode);
    }

    private final void ucnv_MBCSOpen(UConverter cnv, String name, String locale, long options, int[] pErrorCode) {
        ByteBuffer extIndexes;
        UConverterSharedData.UConverterMBCSTable mbcsTable = cnv.sharedData.mbcs;
        short outputType = mbcsTable.outputType;
        if (outputType == 219) {
            cnv.options = options &= 0xFFFFFFFFFFFFFFEFL;
        }
        if ((options & 0x10L) != 0L) {
            boolean isCached;
            boolean bl = isCached = mbcsTable.swapLFNLStateTable != null;
            if (!isCached) {
                // empty if block
            }
        }
        if (name.indexOf("18030") >= 0 && (name.indexOf("gb18030") >= 0 || name.indexOf("GB18030") >= 0)) {
            cnv.options |= 0x8000L;
        }
        if (outputType == 12) {
            cnv.maxBytesPerUChar = (byte)3;
        }
        if ((extIndexes = mbcsTable.extIndexes) != null) {
            byte maxBytesPerUChar = (byte)UConverterExt.UCNV_GET_MAX_BYTES_PER_UCHAR(extIndexes);
            if (outputType == 12) {
                maxBytesPerUChar = (byte)(maxBytesPerUChar + 1);
            }
            if (maxBytesPerUChar > cnv.maxBytesPerUChar) {
                cnv.maxBytesPerUChar = maxBytesPerUChar;
            }
        }
    }

    protected void doLoad(UConverterLoadArgs pArgs, int[] pErrorCode) {
        this.ucnv_MBCSLoad(pArgs, pErrorCode);
    }

    private final void ucnv_MBCSLoad(UConverterLoadArgs pArgs, int[] pErrorCode) {
        UConverterSharedData.UConverterMBCSTable mbcsTable = this.mbcs;
        UConverterSharedData._MBCSHeader header = new UConverterSharedData._MBCSHeader();
        try {
            this.dataReader.readMBCSHeader(header);
        }
        catch (IOException e) {
            if (debug) {
                System.err.println("Caught IOException: " + e.getMessage());
            }
            pErrorCode[0] = 3;
            return;
        }
        Object extIndexesArray = null;
        String baseNameString = null;
        int[][] stateTableArray = null;
        UConverterSharedData._MBCSToUFallback[] toUFallbacksArray = null;
        char[] unicodeCodeUnitsArray = null;
        char[] fromUnicodeTableArray = null;
        byte[] fromUnicodeBytesArray = null;
        if (header.version[0] != 4) {
            pErrorCode[0] = 13;
            return;
        }
        mbcsTable.outputType = (byte)header.flags;
        int offset = header.flags >>> 8;
        if (mbcsTable.outputType == 14) {
            try {
                baseNameString = this.dataReader.readBaseTableName();
                if (offset != 0) {
                    mbcsTable.extIndexes = this.dataReader.readExtIndexes(offset - 32 - baseNameString.length() - 1);
                }
            }
            catch (IOException e) {
                if (debug) {
                    System.err.println("Caught IOException: " + e.getMessage());
                }
                pErrorCode[0] = 3;
                return;
            }
        }
        if (mbcsTable.extIndexes != null) {
            // empty if block
        }
        if (mbcsTable.outputType == 14) {
            UConverterLoadArgs args = new UConverterLoadArgs();
            UConverterSharedData baseSharedData = null;
            ByteBuffer extIndexes = mbcsTable.extIndexes;
            if (extIndexes == null) {
                pErrorCode[0] = 13;
                return;
            }
            if (pArgs.nestedLoads != 1) {
                pErrorCode[0] = 14;
                return;
            }
            String baseName = baseNameString;
            if (baseName.equals(this.staticData.name)) {
                pErrorCode[0] = 13;
                return;
            }
            args.nestedLoads = 2;
            args.reserved = pArgs.reserved;
            args.options = pArgs.options;
            args.pkg = pArgs.pkg;
            args.name = baseName;
            baseSharedData = UConverterSharedData_MBCS.ucnv_load(args, pErrorCode);
            if (UErrorCode.U_FAILURE(pErrorCode[0])) {
                return;
            }
            if (baseSharedData.staticData.conversionType != 2 || baseSharedData.mbcs.baseSharedData != null) {
                pErrorCode[0] = 13;
                return;
            }
            mbcsTable = this.mbcs = baseSharedData.mbcs;
            mbcsTable.baseSharedData = baseSharedData;
            mbcsTable.extIndexes = extIndexes;
            mbcsTable.swapLFNLStateTable = null;
            mbcsTable.swapLFNLFromUnicodeBytes = null;
            mbcsTable.swapLFNLName = null;
            if (this.staticData.conversionType == 1 || this.staticData.conversionType == 2 && this.staticData.minBytesPerChar >= 2) {
                if (baseSharedData.mbcs.outputType == 12) {
                    int entry = mbcsTable.stateTable[0][14];
                    if (UConverterSharedData_MBCS.MBCS_ENTRY_IS_FINAL(entry) && UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_ACTION(entry) == 8 && UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_STATE(entry) != 0) {
                        mbcsTable.dbcsOnlyState = (byte)UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_STATE(entry);
                        mbcsTable.outputType = (short)219;
                    }
                } else if (baseSharedData.staticData.conversionType == 2 && baseSharedData.staticData.minBytesPerChar == 1 && baseSharedData.staticData.maxBytesPerChar == 2 && mbcsTable.countStates <= 127) {
                    int i;
                    short count = mbcsTable.countStates;
                    int[][] newStateTable = new int[(count + 1) * 1024][256];
                    if (newStateTable == null) {
                        pErrorCode[0] = 7;
                        return;
                    }
                    for (i = 0; i < mbcsTable.stateTable.length; ++i) {
                        System.arraycopy(mbcsTable.stateTable[i], 0, newStateTable[i], 0, mbcsTable.stateTable[i].length);
                    }
                    int[] state = newStateTable[0];
                    for (i = 0; i < 256; ++i) {
                        if (!UConverterSharedData_MBCS.MBCS_ENTRY_IS_FINAL(state[i])) continue;
                        state[i] = this.MBCS_ENTRY_TRANSITION(count, 0);
                    }
                    state = newStateTable[count];
                    for (i = 0; i < 256; ++i) {
                        state[i] = this.MBCS_ENTRY_FINAL(0, 7, 0);
                    }
                    mbcsTable.stateTable = newStateTable;
                    mbcsTable.countStates = (byte)(count + 1);
                    mbcsTable.stateTableOwned = true;
                    mbcsTable.outputType = (short)219;
                }
            }
        } else {
            switch (mbcsTable.outputType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 8: 
                case 9: 
                case 12: {
                    break;
                }
                default: {
                    pErrorCode[0] = 13;
                    return;
                }
            }
            stateTableArray = new int[header.countStates][256];
            toUFallbacksArray = new UConverterSharedData._MBCSToUFallback[header.countToUFallbacks];
            for (int i = 0; i < toUFallbacksArray.length; ++i) {
                toUFallbacksArray[i] = new UConverterSharedData._MBCSToUFallback();
            }
            unicodeCodeUnitsArray = new char[(header.offsetFromUTable - header.offsetToUCodeUnits) / 2];
            fromUnicodeTableArray = new char[(header.offsetFromUBytes - header.offsetFromUTable) / 2];
            fromUnicodeBytesArray = new byte[header.fromUBytesLength];
            try {
                this.dataReader.readMBCSTable(stateTableArray, toUFallbacksArray, unicodeCodeUnitsArray, fromUnicodeTableArray, fromUnicodeBytesArray);
            }
            catch (IOException e) {
                if (debug) {
                    System.err.println("Caught IOException: " + e.getMessage());
                }
                pErrorCode[0] = 3;
            }
            mbcsTable.countStates = (byte)header.countStates;
            mbcsTable.countToUFallbacks = header.countToUFallbacks;
            mbcsTable.stateTable = stateTableArray;
            mbcsTable.toUFallbacks = toUFallbacksArray;
            mbcsTable.unicodeCodeUnits = unicodeCodeUnitsArray;
            mbcsTable.fromUnicodeTable = fromUnicodeTableArray;
            mbcsTable.fromUnicodeBytes = fromUnicodeBytesArray;
            mbcsTable.fromUBytesLength = header.fromUBytesLength;
            mbcsTable.unicodeMask = (short)(this.staticData.unicodeMask & 3);
            if (offset != 0) {
                try {
                    mbcsTable.extIndexes = this.dataReader.readExtIndexes(0);
                }
                catch (IOException e) {
                    if (debug) {
                        System.err.println("Caught IOException: " + e.getMessage());
                    }
                    pErrorCode[0] = 3;
                    return;
                }
            }
        }
    }

    int ucnv_MBCSGetFallback(UConverterSharedData.UConverterMBCSTable mbcsTable, int offset) {
        int limit = mbcsTable.countToUFallbacks;
        if (limit > 0) {
            UConverterSharedData._MBCSToUFallback[] toUFallbacks = mbcsTable.toUFallbacks;
            int start = 0;
            while (start < limit - 1) {
                int i = (start + limit) / 2;
                if (offset < toUFallbacks[i].offset) {
                    limit = i;
                    continue;
                }
                start = i;
            }
            if (offset == toUFallbacks[start].offset) {
                return toUFallbacks[start].codePoint;
            }
        }
        return 65534;
    }

    final void ucnv_MBCSSingleToUnicodeWithOffsets(UConverterToUnicodeArgs pArgs, int[] pErrorCode) {
        UConverter cnv = pArgs.converter;
        byte[] sourceArray = pArgs.sourceArray;
        int sourceArrayIndex = pArgs.sourceBegin;
        int sourceLimit = pArgs.sourceLimit;
        char[] targetArray = pArgs.targetArray;
        int targetArrayIndex = pArgs.targetBegin;
        int targetLimit = pArgs.targetLimit;
        int[] offsetsArray = pArgs.offsetsArray;
        int offsetsArrayIndex = pArgs.offsetsBegin;
        int[][] stateTable = (cnv.options & 0x10L) != 0L ? cnv.sharedData.mbcs.swapLFNLStateTable : cnv.sharedData.mbcs.stateTable;
        int sourceIndex = 0;
        while (sourceArrayIndex < sourceLimit) {
            int entry;
            if (targetArrayIndex >= targetLimit) {
                pErrorCode[0] = 15;
                break;
            }
            if (UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(entry = stateTable[0][sourceArray[sourceArrayIndex++] & 0xFF])) {
                targetArray[targetArrayIndex++] = UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
                if (offsetsArray != null) {
                    offsetsArray[offsetsArrayIndex++] = sourceIndex;
                }
                ++sourceIndex;
                continue;
            }
            byte action = (byte)UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_ACTION(entry);
            if (action == 1 || action == 3 && UConverter.UCNV_TO_U_USE_FALLBACK(cnv)) {
                entry = UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE(entry);
                targetArray[targetArrayIndex++] = (char)(0xD800 | (char)(entry >>> 10));
                if (offsetsArray != null) {
                    offsetsArray[offsetsArrayIndex++] = sourceIndex;
                }
                char c = (char)(0xDC00 | (char)(entry & 0x3FF));
                if (targetArrayIndex < targetLimit) {
                    targetArray[targetArrayIndex++] = c;
                    if (offsetsArray != null) {
                        offsetsArray[offsetsArrayIndex++] = sourceIndex;
                    }
                } else {
                    cnv.UCharErrorBufferArray[0] = c;
                    cnv.UCharErrorBufferLength = 1;
                    pErrorCode[0] = 15;
                    break;
                }
                ++sourceIndex;
                continue;
            }
            if (action == 2) {
                if (UConverter.UCNV_TO_U_USE_FALLBACK(cnv)) {
                    targetArray[targetArrayIndex++] = UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
                    if (offsetsArray != null) {
                        offsetsArray[offsetsArrayIndex++] = sourceIndex;
                    }
                    ++sourceIndex;
                    continue;
                }
            } else if (action != 6) {
                if (action == 7) {
                    pErrorCode[0] = 12;
                } else {
                    ++sourceIndex;
                    continue;
                }
            }
            if (UErrorCode.U_FAILURE(pErrorCode[0])) break;
            pArgs.sourceArray = sourceArray;
            pArgs.sourceBegin = sourceArrayIndex;
            cnv.toUBytesArray[0] = sourceArray[sourceArrayIndex - 1];
            int[] sourceArrayBegin = new int[]{sourceArrayIndex};
            int[] targetArrayBegin = new int[]{targetArrayIndex};
            int[] offsetsArrayBegin = new int[]{offsetsArrayIndex};
            cnv.toULength = this._extToU(cnv, cnv.sharedData, (byte)1, sourceArray, sourceArrayBegin, sourceLimit, targetArray, targetArrayBegin, targetLimit, offsetsArray, offsetsArrayBegin, sourceIndex, pArgs.flush, pErrorCode);
            sourceArrayIndex = sourceArrayBegin[0];
            targetArrayIndex = targetArrayBegin[0];
            offsetsArrayIndex = offsetsArrayBegin[0];
            sourceIndex += 1 + (sourceArrayIndex - pArgs.sourceBegin);
            if (!UErrorCode.U_FAILURE(pErrorCode[0])) continue;
            break;
        }
        pArgs.sourceArray = sourceArray;
        pArgs.sourceBegin = sourceArrayIndex;
        pArgs.targetArray = targetArray;
        pArgs.targetBegin = targetArrayIndex;
        pArgs.offsetsArray = offsetsArray;
        pArgs.offsetsBegin = offsetsArrayIndex;
    }

    final void ucnv_MBCSSingleToBMPWithOffsets(UConverterToUnicodeArgs pArgs, int[] pErrorCode) {
        UConverter cnv = pArgs.converter;
        byte[] sourceArray = pArgs.sourceArray;
        int sourceArrayIndex = pArgs.sourceBegin;
        int sourceLimit = pArgs.sourceLimit;
        char[] targetArray = pArgs.targetArray;
        int targetArrayIndex = pArgs.targetBegin;
        int targetCapacity = pArgs.targetLimit - pArgs.targetBegin;
        int[] offsetsArray = pArgs.offsetsArray;
        int offsetsArrayIndex = pArgs.offsetsBegin;
        int[][] stateTable = (cnv.options & 0x10L) != 0L ? cnv.sharedData.mbcs.swapLFNLStateTable : cnv.sharedData.mbcs.stateTable;
        int sourceIndex = 0;
        int lastSource = sourceArrayIndex;
        int length = sourceLimit - sourceArrayIndex;
        if (length < targetCapacity) {
            targetCapacity = length;
        }
        while (targetCapacity > 0) {
            int entry;
            if (UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(entry = stateTable[0][sourceArray[sourceArrayIndex++] & 0xFF])) {
                targetArray[targetArrayIndex++] = UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
                --targetCapacity;
                continue;
            }
            byte action = (byte)UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_ACTION(entry);
            if (action == 2) {
                if (UConverter.UCNV_TO_U_USE_FALLBACK(cnv)) {
                    targetArray[targetArrayIndex++] = UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
                    --targetCapacity;
                    continue;
                }
            } else if (action != 6) {
                if (action != 7) continue;
                pErrorCode[0] = 12;
            }
            if (offsetsArray != null) {
                int count = sourceArrayIndex - lastSource;
                while (--count > 0) {
                    offsetsArray[offsetsArrayIndex++] = sourceIndex++;
                }
            }
            if (UErrorCode.U_FAILURE(pErrorCode[0])) break;
            lastSource = sourceArrayIndex;
            cnv.toUBytesArray[0] = sourceArray[sourceArrayIndex - 1];
            int[] sourceArrayBegin = new int[]{sourceArrayIndex};
            int[] targetArrayBegin = new int[]{targetArrayIndex};
            int[] offsetsArrayBegin = new int[]{offsetsArrayIndex};
            cnv.toULength = this._extToU(cnv, cnv.sharedData, (byte)1, sourceArray, sourceArrayBegin, sourceLimit, targetArray, targetArrayBegin, targetArrayIndex + targetCapacity, offsetsArray, offsetsArrayBegin, sourceIndex, pArgs.flush, pErrorCode);
            sourceArrayIndex = sourceArrayBegin[0];
            targetArrayIndex = targetArrayBegin[0];
            offsetsArrayIndex = offsetsArrayBegin[0];
            sourceIndex += 1 + (sourceArrayIndex - lastSource);
            if (UErrorCode.U_FAILURE(pErrorCode[0])) break;
            length = sourceLimit - sourceArrayIndex;
            targetCapacity = pArgs.targetLimit - targetArrayIndex;
            if (length >= targetCapacity) continue;
            targetCapacity = length;
        }
        if (UErrorCode.U_SUCCESS(pErrorCode[0]) && sourceArrayIndex < sourceLimit && targetArrayIndex >= pArgs.targetLimit) {
            pErrorCode[0] = 15;
        }
        if (offsetsArray != null) {
            for (int count = sourceArrayIndex - lastSource; count > 0; --count) {
                offsetsArray[offsetsArrayIndex++] = sourceIndex++;
            }
        }
        pArgs.sourceArray = sourceArray;
        pArgs.sourceBegin = sourceArrayIndex;
        pArgs.targetArray = targetArray;
        pArgs.targetBegin = targetArrayIndex;
        pArgs.offsetsArray = offsetsArray;
        pArgs.offsetsBegin = offsetsArrayIndex;
    }

    /*
     * Enabled aggressive block sorting
     */
    void ucnv_MBCSToUnicodeWithOffsets(UConverterToUnicodeArgs pArgs, int[] pErrorCode) {
        int entry = 0;
        UConverter cnv = pArgs.converter;
        if (cnv.preToULength > 0) {
            UConverterExt.ucnv_extContinueMatchToU(cnv, pArgs, -1, pErrorCode);
            if (UErrorCode.U_FAILURE(pErrorCode[0])) return;
            if (cnv.preToULength < 0) {
                return;
            }
        }
        if (cnv.sharedData.mbcs.countStates == 1) {
            if ((cnv.sharedData.mbcs.unicodeMask & 1) == 0) {
                this.ucnv_MBCSSingleToBMPWithOffsets(pArgs, pErrorCode);
                return;
            }
            this.ucnv_MBCSSingleToUnicodeWithOffsets(pArgs, pErrorCode);
            return;
        }
        byte[] sourceArray = pArgs.sourceArray;
        int sourceArrayIndex = pArgs.sourceBegin;
        int sourceLimit = pArgs.sourceLimit;
        char[] targetArray = pArgs.targetArray;
        int targetArrayIndex = pArgs.targetBegin;
        int targetLimit = pArgs.targetLimit;
        int[] offsetsArray = pArgs.offsetsArray;
        int offsetsArrayIndex = pArgs.offsetsBegin;
        int[][] stateTable = (cnv.options & 0x10L) != 0L ? cnv.sharedData.mbcs.swapLFNLStateTable : cnv.sharedData.mbcs.stateTable;
        char[] unicodeCodeUnits = cnv.sharedData.mbcs.unicodeCodeUnits;
        int offset = (int)cnv.toUnicodeStatus;
        byte byteIndex = cnv.toULength;
        byte[] bytes = cnv.toUBytesArray;
        byte state = (byte)cnv.mode;
        if (state == 0) {
            state = cnv.sharedData.mbcs.dbcsOnlyState;
        }
        int sourceIndex = byteIndex == 0 ? 0 : -1;
        int nextSourceIndex = 0;
        while (sourceArrayIndex < sourceLimit) {
            block50: {
                byte action;
                block61: {
                    char c;
                    block58: {
                        block60: {
                            block59: {
                                block57: {
                                    block55: {
                                        block56: {
                                            block54: {
                                                block49: {
                                                    block52: {
                                                        block53: {
                                                            block51: {
                                                                if (targetArrayIndex >= targetLimit) {
                                                                    pErrorCode[0] = 15;
                                                                    break;
                                                                }
                                                                if (byteIndex != 0) break block51;
                                                                if (offsetsArray != null) break block52;
                                                                break block53;
                                                            }
                                                            ++nextSourceIndex;
                                                            byte by = byteIndex;
                                                            byteIndex = (byte)(byteIndex + 1);
                                                            byte by2 = sourceArray[sourceArrayIndex++];
                                                            bytes[by] = by2;
                                                            entry = stateTable[state][by2 & 0xFF];
                                                            break block54;
                                                        }
                                                        do {
                                                            if (UConverterSharedData_MBCS.MBCS_ENTRY_IS_TRANSITION(entry = stateTable[state][sourceArray[sourceArrayIndex] & 0xFF])) {
                                                                state = (byte)UConverterSharedData_MBCS.MBCS_ENTRY_TRANSITION_STATE(entry);
                                                                offset = UConverterSharedData_MBCS.MBCS_ENTRY_TRANSITION_OFFSET(entry);
                                                                if (++sourceArrayIndex < sourceLimit && UConverterSharedData_MBCS.MBCS_ENTRY_IS_FINAL(entry = stateTable[state][sourceArray[sourceArrayIndex] & 0xFF]) && UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_ACTION(entry) == 4 && (c = unicodeCodeUnits[offset + UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE_16(entry)]) < '\ufffe') {
                                                                    ++sourceArrayIndex;
                                                                    targetArray[targetArrayIndex++] = c;
                                                                    state = (byte)UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_STATE(entry);
                                                                    offset = 0;
                                                                    continue;
                                                                }
                                                                bytes[0] = sourceArray[sourceArrayIndex - 1];
                                                                byteIndex = 1;
                                                                break block49;
                                                            }
                                                            if (!UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(entry)) break block49;
                                                            ++sourceArrayIndex;
                                                            targetArray[targetArrayIndex++] = UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
                                                            state = (byte)UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_STATE(entry);
                                                        } while (sourceArrayIndex < sourceLimit && targetArrayIndex < targetLimit);
                                                        break block49;
                                                    }
                                                    do {
                                                        if (UConverterSharedData_MBCS.MBCS_ENTRY_IS_TRANSITION(entry = stateTable[state][sourceArray[sourceArrayIndex]])) {
                                                            state = (byte)UConverterSharedData_MBCS.MBCS_ENTRY_TRANSITION_STATE(entry);
                                                            offset = UConverterSharedData_MBCS.MBCS_ENTRY_TRANSITION_OFFSET(entry);
                                                            if (++sourceArrayIndex < sourceLimit && UConverterSharedData_MBCS.MBCS_ENTRY_IS_FINAL(entry = stateTable[state][sourceArray[sourceArrayIndex]]) && UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_ACTION(entry) == 4 && (c = unicodeCodeUnits[offset + UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE_16(entry)]) < '\ufffe') {
                                                                ++sourceArrayIndex;
                                                                targetArray[targetArrayIndex++] = c;
                                                                if (offsetsArray != null) {
                                                                    offsetsArray[offsetsArrayIndex++] = sourceIndex;
                                                                    sourceIndex = nextSourceIndex += 2;
                                                                }
                                                                state = (byte)UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_STATE(entry);
                                                                offset = 0;
                                                                continue;
                                                            }
                                                            ++nextSourceIndex;
                                                            bytes[0] = sourceArray[sourceArrayIndex - 1];
                                                            byteIndex = 1;
                                                            break;
                                                        }
                                                        if (!UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(entry)) break;
                                                        ++sourceArrayIndex;
                                                        targetArray[targetArrayIndex++] = UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
                                                        if (offsetsArray != null) {
                                                            offsetsArray[offsetsArrayIndex++] = sourceIndex;
                                                            sourceIndex = ++nextSourceIndex;
                                                        }
                                                        state = (byte)UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_STATE(entry);
                                                    } while (sourceArrayIndex < sourceLimit && targetArrayIndex < targetLimit);
                                                }
                                                if (sourceArrayIndex >= sourceLimit) break;
                                                if (targetArrayIndex >= targetLimit) {
                                                    pErrorCode[0] = 15;
                                                    break;
                                                }
                                                ++nextSourceIndex;
                                                byte by = byteIndex;
                                                byteIndex = (byte)(byteIndex + 1);
                                                bytes[by] = sourceArray[sourceArrayIndex++];
                                            }
                                            if (UConverterSharedData_MBCS.MBCS_ENTRY_IS_TRANSITION(entry)) {
                                                state = (byte)UConverterSharedData_MBCS.MBCS_ENTRY_TRANSITION_STATE(entry);
                                                offset += UConverterSharedData_MBCS.MBCS_ENTRY_TRANSITION_OFFSET(entry);
                                                continue;
                                            }
                                            cnv.mode = state;
                                            state = (byte)UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_STATE(entry);
                                            action = (byte)UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_ACTION(entry);
                                            if (action != 4) break block55;
                                            c = unicodeCodeUnits[offset += UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE_16(entry)];
                                            if (c >= '\ufffe') break block56;
                                            targetArray[targetArrayIndex++] = c;
                                            if (offsetsArray != null) {
                                                offsetsArray[offsetsArrayIndex++] = sourceIndex;
                                            }
                                            byteIndex = 0;
                                            break block50;
                                        }
                                        if (c == '\ufffe') {
                                            if (UConverter.UCNV_TO_U_USE_FALLBACK(cnv) && (entry = this.ucnv_MBCSGetFallback(cnv.sharedData.mbcs, offset)) != 65534) {
                                                targetArray[targetArrayIndex++] = (char)entry;
                                                if (offsetsArray != null) {
                                                    offsetsArray[offsetsArrayIndex++] = sourceIndex;
                                                }
                                                byteIndex = 0;
                                            }
                                            break block50;
                                        } else {
                                            pErrorCode[0] = 12;
                                        }
                                        break block50;
                                    }
                                    if (action != 0) break block57;
                                    targetArray[targetArrayIndex++] = UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
                                    if (offsetsArray != null) {
                                        offsetsArray[offsetsArrayIndex++] = sourceIndex;
                                    }
                                    byteIndex = 0;
                                    break block50;
                                }
                                if (action != 5) break block58;
                                offset += UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
                                if ((c = unicodeCodeUnits[offset++]) >= '\ud800') break block59;
                                targetArray[targetArrayIndex++] = c;
                                if (offsetsArray != null) {
                                    offsetsArray[offsetsArrayIndex++] = sourceIndex;
                                }
                                byteIndex = 0;
                                break block50;
                            }
                            if (!(UConverter.UCNV_TO_U_USE_FALLBACK(cnv) ? c <= '\udfff' : c <= '\udbff')) break block60;
                            targetArray[targetArrayIndex++] = (char)(c & 0xDBFF);
                            if (offsetsArray != null) {
                                offsetsArray[offsetsArrayIndex++] = sourceIndex;
                            }
                            byteIndex = 0;
                            if (targetArrayIndex < targetLimit) {
                                targetArray[targetArrayIndex++] = unicodeCodeUnits[offset];
                                if (offsetsArray != null) {
                                    offsetsArray[offsetsArrayIndex++] = sourceIndex;
                                }
                                break block50;
                            } else {
                                cnv.UCharErrorBufferArray[0] = unicodeCodeUnits[offset];
                                cnv.UCharErrorBufferLength = 1;
                                pErrorCode[0] = 15;
                                offset = 0;
                                break;
                            }
                        }
                        if (UConverter.UCNV_TO_U_USE_FALLBACK(cnv) ? (c & 0xFFFE) == 57344 : c == '\ue000') {
                            targetArray[targetArrayIndex++] = unicodeCodeUnits[offset];
                            if (offsetsArray != null) {
                                offsetsArray[offsetsArrayIndex++] = sourceIndex;
                            }
                            byteIndex = 0;
                            break block50;
                        } else if (c == '\uffff') {
                            pErrorCode[0] = 12;
                        }
                        break block50;
                    }
                    if (action != 1 && (action != 3 || !UConverter.UCNV_TO_U_USE_FALLBACK(cnv))) break block61;
                    entry = UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE(entry);
                    targetArray[targetArrayIndex++] = (char)(0xD800 | (char)(entry >> 10));
                    if (offsetsArray != null) {
                        offsetsArray[offsetsArrayIndex++] = sourceIndex;
                    }
                    byteIndex = 0;
                    c = (char)(0xDC00 | (char)(entry & 0x3FF));
                    if (targetArrayIndex < targetLimit) {
                        targetArray[targetArrayIndex++] = c;
                        if (offsetsArray != null) {
                            offsetsArray[offsetsArrayIndex++] = sourceIndex;
                        }
                        break block50;
                    } else {
                        cnv.UCharErrorBufferArray[0] = c;
                        cnv.UCharErrorBufferLength = 1;
                        pErrorCode[0] = 15;
                        offset = 0;
                        break;
                    }
                }
                if (action == 8) {
                    if (cnv.sharedData.mbcs.dbcsOnlyState == 0) {
                        byteIndex = 0;
                    } else {
                        state = (byte)cnv.mode;
                        pErrorCode[0] = 12;
                    }
                } else if (action == 2) {
                    if (UConverter.UCNV_TO_U_USE_FALLBACK(cnv)) {
                        targetArray[targetArrayIndex++] = UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
                        if (offsetsArray != null) {
                            offsetsArray[offsetsArrayIndex++] = sourceIndex;
                        }
                        byteIndex = 0;
                    }
                } else if (action != 6) {
                    if (action == 7) {
                        pErrorCode[0] = 12;
                    } else {
                        byteIndex = 0;
                    }
                }
            }
            offset = 0;
            if (byteIndex == 0) {
                sourceIndex = nextSourceIndex;
                continue;
            }
            if (UErrorCode.U_FAILURE(pErrorCode[0])) break;
            pArgs.sourceArray = sourceArray;
            pArgs.sourceBegin = sourceArrayIndex;
            int[] sourceArrayBegin = new int[]{sourceArrayIndex};
            int[] targetArrayBegin = new int[]{targetArrayIndex};
            int[] offsetsArrayBegin = new int[]{offsetsArrayIndex};
            byteIndex = this._extToU(cnv, cnv.sharedData, byteIndex, sourceArray, sourceArrayBegin, sourceLimit, targetArray, targetArrayBegin, targetLimit, offsetsArray, offsetsArrayBegin, sourceIndex, pArgs.flush, pErrorCode);
            sourceArrayIndex = sourceArrayBegin[0];
            targetArrayIndex = targetArrayBegin[0];
            offsetsArrayIndex = offsetsArrayBegin[0];
            sourceIndex = nextSourceIndex + (sourceArrayIndex - pArgs.sourceBegin);
            if (!UErrorCode.U_FAILURE(pErrorCode[0])) continue;
        }
        cnv.toUnicodeStatus = offset;
        cnv.mode = state;
        cnv.toULength = byteIndex;
        pArgs.sourceBegin = sourceArrayIndex;
        pArgs.targetBegin = targetArrayIndex;
        pArgs.offsetsArray = offsetsArray;
        pArgs.offsetsBegin = offsetsArrayIndex;
    }

    private final boolean unassignedDouble(UConverter cnv, UConverterFromUnicodeArgs pArgs, char[] sourceArray, int sourceLimit, int sourceIndex, byte[] targetArray, SideEffectsDouble x, int[] pErrorCode) {
        pArgs.sourceArray = sourceArray;
        pArgs.sourceBegin = x.sourceArrayIndex;
        int[] sourceArrayIndex = new int[]{x.sourceArrayIndex};
        int[] targetArrayIndex = new int[]{x.targetArrayIndex};
        int[] offsetsArrayIndex = new int[]{0};
        x.c = this._extFromU(cnv, cnv.sharedData, x.c, sourceArray, sourceArrayIndex, sourceLimit, targetArray, targetArrayIndex, x.targetArrayIndex + x.targetCapacity, null, offsetsArrayIndex, sourceIndex, pArgs.flush, pErrorCode);
        x.sourceArrayIndex = sourceArrayIndex[0];
        x.targetArrayIndex = targetArrayIndex[0];
        x.nextSourceIndex += x.sourceArrayIndex - pArgs.sourceBegin;
        if (UErrorCode.U_FAILURE(pErrorCode[0])) {
            return false;
        }
        x.targetCapacity = pArgs.targetLimit - x.targetArrayIndex;
        x.sourceIndex = x.nextSourceIndex;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getTrailDouble(UConverter cnv, UConverterFromUnicodeArgs pArgs, char[] sourceArray, int sourceLimit, int sourceIndex, byte[] targetArray, int unicodeMask, SideEffectsDouble x, int[] pErrorCode) {
        if (x.sourceArrayIndex >= sourceLimit) return false;
        char trail = sourceArray[x.sourceArrayIndex];
        if (UConverterUTF16.U16_IS_TRAIL(trail)) {
            ++x.sourceArrayIndex;
            ++x.nextSourceIndex;
            x.c = UConverterUTF16.U16_GET_SUPPLEMENTARY((char)x.c, trail);
            if ((unicodeMask & 1) != 0) return true;
            return this.unassignedDouble(cnv, pArgs, sourceArray, sourceLimit, sourceIndex, targetArray, x, pErrorCode);
        }
        pErrorCode[0] = 12;
        return false;
    }

    void ucnv_MBCSDoubleFromUnicodeWithOffsets(UConverterFromUnicodeArgs pArgs, int[] pErrorCode) {
        SideEffectsDouble x;
        UConverter cnv = pArgs.converter;
        short unicodeMask = cnv.sharedData.mbcs.unicodeMask;
        char[] sourceArray = pArgs.sourceArray;
        int sourceArrayIndex = pArgs.sourceBegin;
        int sourceLimit = pArgs.sourceLimit;
        byte[] targetArray = pArgs.targetArray;
        int targetArrayIndex = pArgs.targetBegin;
        int targetCapacity = pArgs.targetLimit - pArgs.targetBegin;
        int[] offsetsArray = pArgs.offsetsArray;
        int offsetsArrayIndex = pArgs.offsetsBegin;
        char[] table = cnv.sharedData.mbcs.fromUnicodeTable;
        byte[] bytes = (cnv.options & 0x10L) != 0L ? cnv.sharedData.mbcs.swapLFNLFromUnicodeBytes : cnv.sharedData.mbcs.fromUnicodeBytes;
        int c = cnv.fromUChar32;
        int sourceIndex = c == 0 ? 0 : -1;
        int nextSourceIndex = 0;
        boolean doloop = true;
        if (c != 0 && targetCapacity > 0) {
            x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex, targetArrayIndex, targetCapacity);
            doloop = this.getTrailDouble(cnv, pArgs, sourceArray, sourceLimit, sourceIndex, targetArray, unicodeMask, x, pErrorCode);
            c = x.c;
            sourceArrayIndex = x.sourceArrayIndex;
            sourceIndex = x.sourceIndex;
            nextSourceIndex = x.nextSourceIndex;
            targetArrayIndex = x.targetArrayIndex;
            targetCapacity = x.targetCapacity;
        }
        if (doloop) {
            while (sourceArrayIndex < sourceLimit) {
                if (targetCapacity > 0) {
                    c = sourceArray[sourceArrayIndex++];
                    ++nextSourceIndex;
                    if (UConverterUTF.U_IS_SURROGATE(c) && (unicodeMask & 2) == 0) {
                        if (UConverterUTF.U_IS_SURROGATE_LEAD(c)) {
                            x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex, targetArrayIndex, targetCapacity);
                            doloop = this.getTrailDouble(cnv, pArgs, sourceArray, sourceLimit, sourceIndex, targetArray, unicodeMask, x, pErrorCode);
                            c = x.c;
                            sourceArrayIndex = x.sourceArrayIndex;
                            sourceIndex = x.sourceIndex;
                            nextSourceIndex = x.nextSourceIndex;
                            targetArrayIndex = x.targetArrayIndex;
                            targetCapacity = x.targetCapacity;
                            if (!doloop) break;
                            continue;
                        }
                        pErrorCode[0] = 12;
                        break;
                    }
                    int stage2Entry = UConverterSharedData_MBCS.MBCS_STAGE_2_FROM_U(table, c);
                    char value = UConverterSharedData_MBCS.MBCS_VALUE_2_FROM_STAGE_2(bytes, stage2Entry, c);
                    int length = ((long)value & 0xFFFFFFFFL) <= 255L ? 1 : 2;
                    if (!(UConverterSharedData_MBCS.MBCS_FROM_U_IS_ROUNDTRIP(stage2Entry, c) || UConverter.UCNV_FROM_U_USE_FALLBACK(cnv, c) && value != '\u0000')) {
                        x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex, targetArrayIndex, targetCapacity);
                        doloop = this.unassignedDouble(cnv, pArgs, sourceArray, sourceLimit, sourceIndex, targetArray, x, pErrorCode);
                        c = x.c;
                        sourceArrayIndex = x.sourceArrayIndex;
                        sourceIndex = x.sourceIndex;
                        nextSourceIndex = x.nextSourceIndex;
                        targetArrayIndex = x.targetArrayIndex;
                        targetCapacity = x.targetCapacity;
                        if (!doloop) break;
                        continue;
                    }
                    if (length == 1) {
                        targetArray[targetArrayIndex++] = (byte)value;
                        if (offsetsArray != null) {
                            offsetsArray[offsetsArrayIndex++] = sourceIndex;
                        }
                        --targetCapacity;
                    } else {
                        targetArray[targetArrayIndex++] = (byte)(value >>> 8);
                        if (2 <= targetCapacity) {
                            targetArray[targetArrayIndex++] = (byte)value;
                            if (offsetsArray != null) {
                                offsetsArray[offsetsArrayIndex++] = sourceIndex;
                                offsetsArray[offsetsArrayIndex++] = sourceIndex;
                            }
                            targetCapacity -= 2;
                        } else {
                            if (offsetsArray != null) {
                                offsetsArray[offsetsArrayIndex++] = sourceIndex;
                            }
                            cnv.charErrorBufferArray[0] = (byte)value;
                            cnv.charErrorBufferLength = 1;
                            targetCapacity = 0;
                            pErrorCode[0] = 15;
                            c = 0;
                            break;
                        }
                    }
                    c = 0;
                    sourceIndex = nextSourceIndex;
                    continue;
                }
                pErrorCode[0] = 15;
                break;
            }
        }
        cnv.fromUChar32 = c;
        pArgs.sourceArray = sourceArray;
        pArgs.sourceBegin = sourceArrayIndex;
        pArgs.targetArray = targetArray;
        pArgs.targetBegin = targetArrayIndex;
        pArgs.offsetsArray = offsetsArray;
        pArgs.offsetsBegin = offsetsArrayIndex;
    }

    void ucnv_MBCSSingleFromUnicodeWithOffsets(UConverterFromUnicodeArgs pArgs, int[] pErrorCode) {
        SideEffectsDouble x;
        UConverter cnv = pArgs.converter;
        char[] sourceArray = pArgs.sourceArray;
        int sourceArrayIndex = pArgs.sourceBegin;
        int sourceLimit = pArgs.sourceLimit;
        byte[] targetArray = pArgs.targetArray;
        int targetArrayIndex = pArgs.targetBegin;
        int targetCapacity = pArgs.targetLimit - pArgs.targetBegin;
        int[] offsetsArray = pArgs.offsetsArray;
        int offsetsArrayIndex = pArgs.offsetsBegin;
        char[] table = cnv.sharedData.mbcs.fromUnicodeTable;
        byte[] results = (cnv.options & 0x10L) != 0L ? cnv.sharedData.mbcs.swapLFNLFromUnicodeBytes : cnv.sharedData.mbcs.fromUnicodeBytes;
        char minValue = cnv.useFallback ? (char)'\u0800' : '\u0c00';
        short unicodeMask = cnv.sharedData.mbcs.unicodeMask;
        int c = cnv.fromUChar32;
        int sourceIndex = c == 0 ? 0 : -1;
        int nextSourceIndex = 0;
        boolean doloop = true;
        if (c != 0 && targetCapacity > 0) {
            x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex, targetArrayIndex, targetCapacity);
            doloop = this.getTrailDouble(cnv, pArgs, sourceArray, sourceLimit, sourceIndex, targetArray, unicodeMask, x, pErrorCode);
            c = x.c;
            sourceArrayIndex = x.sourceArrayIndex;
            sourceIndex = x.sourceIndex;
            nextSourceIndex = x.nextSourceIndex;
            targetArrayIndex = x.targetArrayIndex;
            targetCapacity = x.targetCapacity;
        }
        if (doloop) {
            while (sourceArrayIndex < sourceLimit) {
                if (targetCapacity > 0) {
                    c = sourceArray[sourceArrayIndex++];
                    ++nextSourceIndex;
                    if (UConverterUTF.U_IS_SURROGATE(c)) {
                        if (UConverterUTF.U_IS_SURROGATE_LEAD(c)) {
                            x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex, targetArrayIndex, targetCapacity);
                            doloop = this.getTrailDouble(cnv, pArgs, sourceArray, sourceLimit, sourceIndex, targetArray, unicodeMask, x, pErrorCode);
                            c = x.c;
                            sourceArrayIndex = x.sourceArrayIndex;
                            sourceIndex = x.sourceIndex;
                            nextSourceIndex = x.nextSourceIndex;
                            targetArrayIndex = x.targetArrayIndex;
                            targetCapacity = x.targetCapacity;
                            if (!doloop) break;
                            continue;
                        }
                        pErrorCode[0] = 12;
                        break;
                    }
                    char value = UConverterSharedData_MBCS.MBCS_SINGLE_RESULT_FROM_U(table, results, c);
                    if (value >= minValue) {
                        targetArray[targetArrayIndex++] = (byte)value;
                        if (offsetsArray != null) {
                            offsetsArray[offsetsArrayIndex++] = sourceIndex;
                        }
                        --targetCapacity;
                        c = 0;
                        sourceIndex = nextSourceIndex;
                        continue;
                    }
                    x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex, targetArrayIndex, targetCapacity);
                    doloop = this.unassignedDouble(cnv, pArgs, sourceArray, sourceLimit, sourceIndex, targetArray, x, pErrorCode);
                    c = x.c;
                    sourceArrayIndex = x.sourceArrayIndex;
                    sourceIndex = x.sourceIndex;
                    nextSourceIndex = x.nextSourceIndex;
                    targetArrayIndex = x.targetArrayIndex;
                    targetCapacity = x.targetCapacity;
                    if (doloop) continue;
                    break;
                }
                pErrorCode[0] = 15;
                break;
            }
        }
        cnv.fromUChar32 = c;
        pArgs.sourceArray = sourceArray;
        pArgs.sourceBegin = sourceArrayIndex;
        pArgs.targetArray = targetArray;
        pArgs.targetBegin = targetArrayIndex;
        pArgs.offsetsArray = offsetsArray;
        pArgs.offsetsBegin = offsetsArrayIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getTrailSingleBMP(char[] sourceArray, int sourceLimit, SideEffectsSingleBMP x, int[] pErrorCode) {
        if (x.sourceArrayIndex >= sourceLimit) return false;
        char trail = sourceArray[x.sourceArrayIndex];
        if (UConverterUTF16.U16_IS_TRAIL(trail)) {
            ++x.sourceArrayIndex;
        } else {
            pErrorCode[0] = 12;
            return false;
        }
        x.c = UConverterUTF16.U16_GET_SUPPLEMENTARY((char)x.c, trail);
        return true;
    }

    void ucnv_MBCSSingleFromBMPWithOffsets(UConverterFromUnicodeArgs pArgs, int[] pErrorCode) {
        SideEffectsSingleBMP x;
        UConverter cnv = pArgs.converter;
        char[] sourceArray = pArgs.sourceArray;
        int sourceArrayIndex = pArgs.sourceBegin;
        int sourceLimit = pArgs.sourceLimit;
        byte[] targetArray = pArgs.targetArray;
        int targetArrayIndex = pArgs.targetBegin;
        int targetCapacity = pArgs.targetLimit - pArgs.targetBegin;
        int[] offsetsArray = pArgs.offsetsArray;
        int offsetsArrayIndex = pArgs.offsetsBegin;
        char[] table = cnv.sharedData.mbcs.fromUnicodeTable;
        byte[] results = (cnv.options & 0x10L) != 0L ? cnv.sharedData.mbcs.swapLFNLFromUnicodeBytes : cnv.sharedData.mbcs.fromUnicodeBytes;
        char minValue = cnv.useFallback ? (char)'\u0800' : '\u0c00';
        int c = cnv.fromUChar32;
        int sourceIndex = c == 0 ? 0 : -1;
        int lastSource = sourceArrayIndex;
        int length = sourceLimit - sourceArrayIndex;
        if (length < targetCapacity) {
            targetCapacity = length;
        }
        boolean doloop = true;
        if (c != 0 && targetCapacity > 0) {
            x = new SideEffectsSingleBMP(c, sourceArrayIndex);
            doloop = this.getTrailSingleBMP(sourceArray, sourceLimit, x, pErrorCode);
            c = x.c;
            sourceArrayIndex = x.sourceArrayIndex;
        }
        if (doloop) {
            while (targetCapacity > 0) {
                char value;
                if ((value = UConverterSharedData_MBCS.MBCS_SINGLE_RESULT_FROM_U(table, results, c = sourceArray[sourceArrayIndex++])) >= minValue) {
                    targetArray[targetArrayIndex++] = (byte)value;
                    --targetCapacity;
                    c = 0;
                    continue;
                }
                if (UConverterUTF.U_IS_SURROGATE(c)) {
                    if (UConverterUTF.U_IS_SURROGATE_LEAD(c)) {
                        x = new SideEffectsSingleBMP(c, sourceArrayIndex);
                        doloop = this.getTrailSingleBMP(sourceArray, sourceLimit, x, pErrorCode);
                        c = x.c;
                        sourceArrayIndex = x.sourceArrayIndex;
                        if (!doloop) {
                            break;
                        }
                    } else {
                        pErrorCode[0] = 12;
                        break;
                    }
                }
                length = UConverterUTF16.U16_LENGTH(c);
                if (offsetsArray != null) {
                    int count = sourceArrayIndex - lastSource;
                    count -= length;
                    while (count > 0) {
                        offsetsArray[offsetsArrayIndex++] = sourceIndex++;
                        --count;
                    }
                }
                lastSource = sourceArrayIndex;
                int[] sourceBegin = new int[]{sourceArrayIndex};
                int[] targetBegin = new int[]{targetArrayIndex};
                int[] offsetsBegin = new int[]{offsetsArrayIndex};
                c = this._extFromU(cnv, cnv.sharedData, c, sourceArray, sourceBegin, sourceLimit, targetArray, targetBegin, targetArrayIndex + targetCapacity, offsetsArray, offsetsBegin, sourceIndex, pArgs.flush, pErrorCode);
                sourceArrayIndex = sourceBegin[0];
                targetArrayIndex = targetBegin[0];
                offsetsArrayIndex = offsetsBegin[0];
                sourceIndex += length + (sourceArrayIndex - lastSource);
                lastSource = sourceArrayIndex;
                if (UErrorCode.U_FAILURE(pErrorCode[0])) break;
                length = sourceLimit - sourceArrayIndex;
                targetCapacity = pArgs.targetLimit - targetArrayIndex;
                if (length >= targetCapacity) continue;
                targetCapacity = length;
            }
        }
        if (UErrorCode.U_SUCCESS(pErrorCode[0]) && sourceArrayIndex < sourceLimit && targetArrayIndex >= pArgs.targetLimit) {
            pErrorCode[0] = 15;
        }
        if (offsetsArray != null) {
            for (int count = sourceArrayIndex - lastSource; count > 0; --count) {
                offsetsArray[offsetsArrayIndex++] = sourceIndex++;
            }
        }
        cnv.fromUChar32 = c;
        pArgs.sourceArray = sourceArray;
        pArgs.sourceBegin = sourceArrayIndex;
        pArgs.targetArray = targetArray;
        pArgs.targetBegin = targetArrayIndex;
        pArgs.offsetsArray = offsetsArray;
        pArgs.offsetsBegin = offsetsArrayIndex;
    }

    private final boolean unassigned(UConverter cnv, UConverterFromUnicodeArgs pArgs, char[] sourceArray, int sourceLimit, int sourceIndex, byte[] targetArray, int[] offsets, SideEffects x, int[] pErrorCode) {
        pArgs.sourceArray = sourceArray;
        pArgs.sourceBegin = x.sourceArrayIndex;
        int[] sourceArrayIndex = new int[]{x.sourceArrayIndex};
        int[] targetArrayIndex = new int[]{x.targetArrayIndex};
        int[] offsetsArrayIndex = new int[]{0};
        x.c = this._extFromU(cnv, cnv.sharedData, x.c, sourceArray, sourceArrayIndex, sourceLimit, targetArray, targetArrayIndex, x.targetArrayIndex + x.targetCapacity, null, offsetsArrayIndex, sourceIndex, pArgs.flush, pErrorCode);
        x.sourceArrayIndex = sourceArrayIndex[0];
        x.targetArrayIndex = targetArrayIndex[0];
        x.nextSourceIndex += x.sourceArrayIndex - pArgs.sourceBegin;
        x.prevLength = (int)cnv.fromUnicodeStatus;
        if (UErrorCode.U_FAILURE(pErrorCode[0])) {
            return false;
        }
        x.targetCapacity = pArgs.targetLimit - x.targetArrayIndex;
        if (offsets != null) {
            x.prevSourceIndex = x.sourceIndex;
            x.sourceIndex = x.nextSourceIndex;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getTrail(UConverter cnv, UConverterFromUnicodeArgs pArgs, char[] sourceArray, int sourceLimit, int sourceIndex, byte[] targetArray, int unicodeMask, SideEffects x, int[] pErrorCode) {
        if (x.sourceArrayIndex >= sourceLimit) return false;
        char trail = sourceArray[x.sourceArrayIndex];
        if (UConverterUTF16.U16_IS_TRAIL(trail)) {
            ++x.sourceArrayIndex;
            ++x.nextSourceIndex;
            x.c = UConverterUTF16.U16_GET_SUPPLEMENTARY((char)x.c, trail);
            if ((unicodeMask & 1) != 0) return true;
            cnv.fromUnicodeStatus = x.prevLength;
            return this.unassigned(cnv, pArgs, sourceArray, sourceLimit, sourceIndex, targetArray, null, x, pErrorCode);
        }
        pErrorCode[0] = 12;
        return false;
    }

    void ucnv_MBCSFromUnicodeWithOffsets(UConverterFromUnicodeArgs pArgs, int[] pErrorCode) {
        SideEffects x;
        int prevLength;
        UConverter cnv = pArgs.converter;
        if (cnv.preFromUFirstCP >= 0) {
            UConverterExt.ucnv_extContinueMatchFromU(cnv, pArgs, -1, pErrorCode);
            if (UErrorCode.U_FAILURE(pErrorCode[0]) || cnv.preFromULength < 0) {
                return;
            }
        }
        short outputType = cnv.sharedData.mbcs.outputType;
        short unicodeMask = cnv.sharedData.mbcs.unicodeMask;
        if (outputType == 0 && (unicodeMask & 2) == 0) {
            if ((unicodeMask & 1) == 0) {
                this.ucnv_MBCSSingleFromBMPWithOffsets(pArgs, pErrorCode);
            } else {
                this.ucnv_MBCSSingleFromUnicodeWithOffsets(pArgs, pErrorCode);
            }
            return;
        }
        if (outputType == 1) {
            this.ucnv_MBCSDoubleFromUnicodeWithOffsets(pArgs, pErrorCode);
            return;
        }
        char[] sourceArray = pArgs.sourceArray;
        int sourceArrayIndex = pArgs.sourceBegin;
        int sourceLimit = pArgs.sourceLimit;
        byte[] targetArray = pArgs.targetArray;
        int targetArrayIndex = pArgs.targetBegin;
        int targetCapacity = pArgs.targetLimit - pArgs.targetBegin;
        int[] offsetsArray = pArgs.offsetsArray;
        int offsetsArrayIndex = pArgs.offsetsBegin;
        char[] table = cnv.sharedData.mbcs.fromUnicodeTable;
        byte[] bytes = (cnv.options & 0x10L) != 0L ? cnv.sharedData.mbcs.swapLFNLFromUnicodeBytes : cnv.sharedData.mbcs.fromUnicodeBytes;
        int c = cnv.fromUChar32;
        if (outputType == 12) {
            prevLength = (int)cnv.fromUnicodeStatus;
            if (prevLength == 0) {
                prevLength = 1;
            }
        } else {
            prevLength = 0;
        }
        int prevSourceIndex = -1;
        int sourceIndex = c == 0 ? 0 : -1;
        int nextSourceIndex = 0;
        boolean doloop = true;
        if (c != 0 && targetCapacity > 0) {
            x = new SideEffects(c, sourceArrayIndex, sourceIndex, nextSourceIndex, prevSourceIndex, targetArrayIndex, targetCapacity, prevLength);
            doloop = this.getTrail(cnv, pArgs, sourceArray, sourceLimit, sourceIndex, targetArray, unicodeMask, x, pErrorCode);
            c = x.c;
            sourceArrayIndex = x.sourceArrayIndex;
            sourceIndex = x.sourceIndex;
            nextSourceIndex = x.nextSourceIndex;
            prevSourceIndex = x.prevSourceIndex;
            targetArrayIndex = x.targetArrayIndex;
            targetCapacity = x.targetCapacity;
            prevLength = x.prevLength;
        }
        if (doloop) {
            while (sourceArrayIndex < sourceLimit) {
                if (targetCapacity > 0) {
                    int length;
                    int value;
                    c = sourceArray[sourceArrayIndex++];
                    ++nextSourceIndex;
                    if (UConverterUTF.U_IS_SURROGATE(c) && (unicodeMask & 2) == 0) {
                        if (UConverterUTF.U_IS_SURROGATE_LEAD(c)) {
                            x = new SideEffects(c, sourceArrayIndex, sourceIndex, nextSourceIndex, prevSourceIndex, targetArrayIndex, targetCapacity, prevLength);
                            doloop = this.getTrail(cnv, pArgs, sourceArray, sourceLimit, sourceIndex, targetArray, unicodeMask, x, pErrorCode);
                            c = x.c;
                            sourceArrayIndex = x.sourceArrayIndex;
                            sourceIndex = x.sourceIndex;
                            nextSourceIndex = x.nextSourceIndex;
                            prevSourceIndex = x.prevSourceIndex;
                            targetArrayIndex = x.targetArrayIndex;
                            if (!doloop) break;
                            continue;
                        }
                        pErrorCode[0] = 12;
                        break;
                    }
                    int stage2Entry = UConverterSharedData_MBCS.MBCS_STAGE_2_FROM_U(table, c);
                    switch (outputType) {
                        case 1: {
                            value = UConverterSharedData_MBCS.MBCS_VALUE_2_FROM_STAGE_2(bytes, stage2Entry, c);
                            if (((long)value & 0xFFFFFFFFL) <= 255L) {
                                length = 1;
                                break;
                            }
                            length = 2;
                            break;
                        }
                        case 12: {
                            cnv.fromUnicodeStatus = prevLength;
                            value = UConverterSharedData_MBCS.MBCS_VALUE_2_FROM_STAGE_2(bytes, stage2Entry, c);
                            if (((long)value & 0xFFFFFFFFL) <= 255L) {
                                if (value == 0 && !UConverterSharedData_MBCS.MBCS_FROM_U_IS_ROUNDTRIP(stage2Entry, c)) {
                                    length = 0;
                                    break;
                                }
                                if (prevLength <= 1) {
                                    length = 1;
                                    break;
                                }
                                value |= 0xF00;
                                length = 2;
                                prevLength = 1;
                                break;
                            }
                            if (prevLength == 2) {
                                length = 2;
                                break;
                            }
                            value |= 0xE0000;
                            length = 3;
                            prevLength = 2;
                            break;
                        }
                        case 219: {
                            value = UConverterSharedData_MBCS.MBCS_VALUE_2_FROM_STAGE_2(bytes, stage2Entry, c);
                            if (((long)value & 0xFFFFFFFFL) <= 255L) {
                                stage2Entry = 0;
                                value = 0;
                                length = 0;
                                break;
                            }
                            length = 2;
                            break;
                        }
                        case 2: {
                            byte[] pArray = bytes;
                            int pArrayIndex = UConverterSharedData_MBCS.MBCS_POINTER_3_FROM_STAGE_2(bytes, stage2Entry, c);
                            value = (pArray[pArrayIndex] & 0xFF) << 16 | (pArray[pArrayIndex + 1] & 0xFF) << 8 | pArray[pArrayIndex + 2] & 0xFF;
                            if (((long)value & 0xFFFFFFFFL) <= 255L) {
                                length = 1;
                                break;
                            }
                            if (((long)value & 0xFFFFFFFFL) <= 65535L) {
                                length = 2;
                                break;
                            }
                            length = 3;
                            break;
                        }
                        case 3: {
                            value = UConverterSharedData_MBCS.MBCS_VALUE_4_FROM_STAGE_2(bytes, stage2Entry, c);
                            if (((long)value & 0xFFFFFFFFL) <= 255L) {
                                length = 1;
                                break;
                            }
                            if (((long)value & 0xFFFFFFFFL) <= 65535L) {
                                length = 2;
                                break;
                            }
                            if (((long)value & 0xFFFFFFFFL) <= 0xFFFFFFL) {
                                length = 3;
                                break;
                            }
                            length = 4;
                            break;
                        }
                        case 8: {
                            value = UConverterSharedData_MBCS.MBCS_VALUE_2_FROM_STAGE_2(bytes, stage2Entry, c);
                            if (((long)value & 0xFFFFFFFFL) <= 255L) {
                                length = 1;
                                break;
                            }
                            if ((value & 0x8000) == 0) {
                                value |= 0x8E8000;
                                length = 3;
                                break;
                            }
                            if ((value & 0x80) == 0) {
                                value |= 0x8F0080;
                                length = 3;
                                break;
                            }
                            length = 2;
                            break;
                        }
                        case 9: {
                            byte[] pArray = bytes;
                            int pArrayIndex = UConverterSharedData_MBCS.MBCS_POINTER_3_FROM_STAGE_2(bytes, stage2Entry, c);
                            value = (pArray[pArrayIndex] & 0xFF) << 16 | (pArray[pArrayIndex + 1] & 0xFF) << 8 | pArray[pArrayIndex + 2] & 0xFF;
                            if (((long)value & 0xFFFFFFFFL) <= 255L) {
                                length = 1;
                                break;
                            }
                            if (((long)value & 0xFFFFFFFFL) <= 65535L) {
                                length = 2;
                                break;
                            }
                            if ((value & 0x800000) == 0) {
                                value |= 0x8E800000;
                                length = 4;
                                break;
                            }
                            if ((value & 0x8000) == 0) {
                                value |= 0x8F008000;
                                length = 4;
                                break;
                            }
                            length = 3;
                            break;
                        }
                        default: {
                            stage2Entry = 0;
                            value = 0;
                            length = 0;
                        }
                    }
                    if (!(UConverterSharedData_MBCS.MBCS_FROM_U_IS_ROUNDTRIP(stage2Entry, c) || UConverter.UCNV_FROM_U_USE_FALLBACK(cnv, c) && value != 0)) {
                        x = new SideEffects(c, sourceArrayIndex, sourceIndex, nextSourceIndex, prevSourceIndex, targetArrayIndex, targetCapacity, prevLength);
                        doloop = this.unassigned(cnv, pArgs, sourceArray, sourceLimit, sourceIndex, targetArray, null, x, pErrorCode);
                        c = x.c;
                        sourceArrayIndex = x.sourceArrayIndex;
                        sourceIndex = x.sourceIndex;
                        nextSourceIndex = x.nextSourceIndex;
                        prevSourceIndex = x.prevSourceIndex;
                        targetArrayIndex = x.targetArrayIndex;
                        targetCapacity = x.targetCapacity;
                        prevLength = x.prevLength;
                        if (!doloop) break;
                        continue;
                    }
                    if (length <= targetCapacity) {
                        if (offsetsArray == null) {
                            switch (length) {
                                case 4: {
                                    targetArray[targetArrayIndex++] = (byte)(value >>> 24);
                                }
                                case 3: {
                                    targetArray[targetArrayIndex++] = (byte)(value >>> 16);
                                }
                                case 2: {
                                    targetArray[targetArrayIndex++] = (byte)(value >>> 8);
                                }
                                case 1: {
                                    targetArray[targetArrayIndex++] = (byte)value;
                                }
                            }
                        } else {
                            switch (length) {
                                case 4: {
                                    targetArray[targetArrayIndex++] = (byte)(value >>> 24);
                                    offsetsArray[offsetsArrayIndex++] = sourceIndex;
                                }
                                case 3: {
                                    targetArray[targetArrayIndex++] = (byte)(value >>> 16);
                                    offsetsArray[offsetsArrayIndex++] = sourceIndex;
                                }
                                case 2: {
                                    targetArray[targetArrayIndex++] = (byte)(value >>> 8);
                                    offsetsArray[offsetsArrayIndex++] = sourceIndex;
                                }
                                case 1: {
                                    targetArray[targetArrayIndex++] = (byte)value;
                                    offsetsArray[offsetsArrayIndex++] = sourceIndex;
                                }
                            }
                        }
                        targetCapacity -= length;
                    } else {
                        byte[] charErrorBufferArray = cnv.charErrorBufferArray;
                        int charErrorBufferArrayIndex = cnv.charErrorBufferBegin;
                        switch (length -= targetCapacity) {
                            case 3: {
                                charErrorBufferArray[charErrorBufferArrayIndex++] = (byte)(value >>> 16);
                            }
                            case 2: {
                                charErrorBufferArray[charErrorBufferArrayIndex++] = (byte)(value >>> 8);
                            }
                            case 1: {
                                charErrorBufferArray[charErrorBufferArrayIndex] = (byte)value;
                            }
                        }
                        cnv.charErrorBufferLength = (byte)length;
                        value >>>= 8 * length;
                        switch (targetCapacity) {
                            case 3: {
                                targetArray[targetArrayIndex++] = (byte)(value >>> 16);
                                if (offsetsArray != null) {
                                    offsetsArray[offsetsArrayIndex++] = sourceIndex;
                                }
                            }
                            case 2: {
                                targetArray[targetArrayIndex++] = (byte)(value >>> 8);
                                if (offsetsArray != null) {
                                    offsetsArray[offsetsArrayIndex++] = sourceIndex;
                                }
                            }
                            case 1: {
                                targetArray[targetArrayIndex++] = (byte)value;
                                if (offsetsArray == null) break;
                                offsetsArray[offsetsArrayIndex++] = sourceIndex;
                            }
                        }
                        targetCapacity = 0;
                        pErrorCode[0] = 15;
                        c = 0;
                        break;
                    }
                    c = 0;
                    if (offsetsArray == null) continue;
                    prevSourceIndex = sourceIndex;
                    sourceIndex = nextSourceIndex;
                    continue;
                }
                pErrorCode[0] = 15;
                break;
            }
        }
        if (UErrorCode.U_SUCCESS(pErrorCode[0]) && outputType == 12 && prevLength == 2 && pArgs.flush && sourceArrayIndex >= sourceLimit && c == 0) {
            if (targetCapacity > 0) {
                targetArray[targetArrayIndex++] = 15;
                if (offsetsArray != null) {
                    offsetsArray[offsetsArrayIndex++] = prevSourceIndex;
                }
            } else {
                cnv.charErrorBufferArray[0] = 15;
                cnv.charErrorBufferLength = 1;
                pErrorCode[0] = 15;
            }
            prevLength = 1;
        }
        cnv.fromUChar32 = c;
        cnv.fromUnicodeStatus = prevLength;
        pArgs.sourceArray = sourceArray;
        pArgs.sourceBegin = sourceArrayIndex;
        pArgs.targetArray = targetArray;
        pArgs.targetBegin = targetArrayIndex;
        pArgs.offsetsArray = offsetsArray;
        pArgs.offsetsBegin = offsetsArrayIndex;
    }

    /*
     * WARNING - void declaration
     */
    public int ucnv_MBCSSimpleGetNextUChar(UConverterSharedData sharedData, byte[] sourceArray, int sourceBegin, int length, boolean useFallback) {
        ByteBuffer cx;
        void var12_14;
        int c;
        int entry;
        UConverter cnv = null;
        if (length <= 0) {
            return 65535;
        }
        int[][] stateTable = sharedData.mbcs.stateTable;
        char[] unicodeCodeUnits = sharedData.mbcs.unicodeCodeUnits;
        int offset = 0;
        byte state = sharedData.mbcs.dbcsOnlyState;
        int i = 0;
        while (UConverterSharedData_MBCS.MBCS_ENTRY_IS_TRANSITION(entry = stateTable[state][sourceArray[i++]])) {
            state = (byte)UConverterSharedData_MBCS.MBCS_ENTRY_TRANSITION_STATE(entry);
            offset += UConverterSharedData_MBCS.MBCS_ENTRY_TRANSITION_OFFSET(entry);
            if (i != length) continue;
            return 65535;
        }
        byte action = (byte)UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_ACTION(entry);
        if (action == 4) {
            c = unicodeCodeUnits[offset += UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE_16(entry)];
            if (c == 65534 && UConverter.UCNV_TO_U_USE_FALLBACK(cnv)) {
                c = this.ucnv_MBCSGetFallback(sharedData.mbcs, offset);
            }
        } else if (action == 0) {
            c = UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
        } else if (action == 5) {
            offset += UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
            if ((c = unicodeCodeUnits[offset++]) >= 55296) {
                if (UConverter.UCNV_TO_U_USE_FALLBACK(cnv) ? c <= 57343 : c <= 56319) {
                    c = ((c & 0x3FF) << 10) + unicodeCodeUnits[offset] + 9216;
                } else if (UConverter.UCNV_TO_U_USE_FALLBACK(cnv) ? (c & 0xFFFE) == 57344 : c == 57344) {
                    c = unicodeCodeUnits[offset];
                } else {
                    if (c == 65535) {
                        return 65535;
                    }
                    c = 65534;
                }
            }
        } else if (action == 1) {
            c = 65536 + UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE(entry);
        } else if (action == 2) {
            c = !UConverter.TO_U_USE_FALLBACK(useFallback) ? 65534 : (int)UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
        } else if (action == 3) {
            c = !UConverter.TO_U_USE_FALLBACK(useFallback) ? 65534 : 65536 + UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE(entry);
        } else if (action == 6) {
            c = 65534;
        } else {
            return 65535;
        }
        if (i != length) {
            return 65535;
        }
        if (var12_14 == 65534 && (cx = sharedData.mbcs.extIndexes) != null) {
            return UConverterExt.ucnv_extSimpleMatchToU(cx, sourceArray, sourceBegin, length, useFallback);
        }
        return (int)var12_14;
    }

    int _extFromU(UConverter cnv, UConverterSharedData sharedData, int cp_, char[] sourceArray, int[] sourceArrayBegin, int sourceLimit, byte[] targetArray, int[] targetArrayBegin, int targetLimit, int[] offsetsArray, int[] offsetsArrayBegin, int sourceIndex, boolean flush, int[] pErrorCode) {
        long cp = (long)cp_ & 0xFFFFFFFFL;
        cnv.useSubChar1 = false;
        ByteBuffer cx = sharedData.mbcs.extIndexes;
        if (cx != null && UConverterExt.ucnv_extInitialMatchFromU(cnv, cx, (int)cp, sourceArray, sourceArrayBegin, sourceLimit, targetArray, targetArrayBegin, targetLimit, offsetsArray, offsetsArrayBegin, sourceIndex, flush, pErrorCode)) {
            return 0;
        }
        if ((cnv.options & 0x8000L) != 0L) {
            long[] range = gb18030Ranges[0];
            for (int i = 0; i < gb18030Ranges.length / gb18030Ranges[0].length; ++i) {
                if (range[0] <= cp && cp <= range[1]) {
                    byte[] bytes = new byte[4];
                    long linear = range[2] - LINEAR_18030_BASE;
                    bytes[3] = (byte)(48L + (linear += cp - range[0]) % 10L);
                    bytes[2] = (byte)(129L + (linear /= 10L) % 126L);
                    bytes[1] = (byte)(48L + (linear /= 126L) % 10L);
                    bytes[0] = (byte)(129L + (linear /= 10L));
                    UConverter.ucnv_fromUWriteBytes(cnv, bytes, 0, 4, targetArray, targetArrayBegin, targetLimit, offsetsArray, offsetsArrayBegin, sourceIndex, pErrorCode);
                    return 0;
                }
                range = gb18030Ranges[i];
            }
        }
        pErrorCode[0] = 10;
        return (int)cp;
    }

    byte _extToU(UConverter cnv, UConverterSharedData sharedData, byte length, byte[] sourceArray, int[] sourceArrayBegin, int sourceLimit, char[] targetArray, int[] targetArrayBegin, int targetLimit, int[] offsetsArray, int[] offsetsArrayBegin, int sourceIndex, boolean flush, int[] pErrorCode) {
        ByteBuffer cx = sharedData.mbcs.extIndexes;
        if (cx != null && UConverterExt.ucnv_extInitialMatchToU(cnv, cx, length, sourceArray, sourceArrayBegin, sourceLimit, targetArray, targetArrayBegin, targetLimit, offsetsArray, offsetsArrayBegin, sourceIndex, flush, pErrorCode)) {
            return 0;
        }
        if (length == 4 && (cnv.options & 0x8000L) != 0L) {
            long linear = UConverterSharedData_MBCS.LINEAR_18030(cnv.toUBytesArray[0], cnv.toUBytesArray[1], cnv.toUBytesArray[2], cnv.toUBytesArray[3]);
            long[] range = gb18030Ranges[0];
            int i = 0;
            while (i < gb18030Ranges.length / gb18030Ranges[0].length) {
                if (range[2] <= linear && linear <= range[3]) {
                    pErrorCode[0] = 0;
                    linear = range[0] + (linear - range[2]);
                    cnv.ucnv_toUWriteCodePoint((int)linear, targetArray, targetArrayBegin, targetLimit, offsetsArray, offsetsArrayBegin, sourceIndex, pErrorCode);
                    return 0;
                }
                range = gb18030Ranges[++i];
            }
        }
        pErrorCode[0] = 10;
        return length;
    }

    int MBCS_ENTRY_TRANSITION(int state, int offset) {
        return state << 24 | offset;
    }

    int MBCS_ENTRY_FINAL(int state, int action, int value) {
        return Integer.MIN_VALUE | state << 24 | action << 20 | value;
    }

    static final boolean MBCS_ENTRY_IS_TRANSITION(int entry) {
        return entry >= 0;
    }

    static final boolean MBCS_ENTRY_IS_FINAL(int entry) {
        return entry < 0;
    }

    static final int MBCS_ENTRY_TRANSITION_STATE(int entry) {
        return entry >>> 24;
    }

    static final int MBCS_ENTRY_TRANSITION_OFFSET(int entry) {
        return entry & 0xFFFFFF;
    }

    static final int MBCS_ENTRY_FINAL_STATE(int entry) {
        return entry >>> 24 & 0x7F;
    }

    static final boolean MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(int entry) {
        return entry < -2146435072;
    }

    static final int MBCS_ENTRY_FINAL_ACTION(int entry) {
        return entry >>> 20 & 0xF;
    }

    static final int MBCS_ENTRY_FINAL_VALUE(int entry) {
        return entry & 0xFFFFF;
    }

    static final char MBCS_ENTRY_FINAL_VALUE_16(int entry) {
        return (char)entry;
    }

    protected final char _MBCS_SINGLE_SIMPLE_GET_NEXT_BMP(int b) {
        return UConverterSharedData_MBCS.MBCS_ENTRY_FINAL_VALUE_16(this.mbcs.stateTable[0][b & 0xFF]);
    }

    static final char MBCS_SINGLE_RESULT_FROM_U(char[] table, byte[] results, int c) {
        int i1 = table[c >>> 10] + (c >>> 4 & 0x3F);
        int i = 2 * (table[i1] + (c & 0xF));
        return (char)((results[i] & 0xFF) << 8 | results[i + 1] & 0xFF);
    }

    static int MBCS_STAGE_2_FROM_U(char[] table, int c) {
        int i = 2 * (table[c >>> 10] + (c >>> 4 & 0x3F));
        return (table[i] & 0xFFFF) << 16 | table[i + 1] & 0xFFFF;
    }

    static boolean MBCS_FROM_U_IS_ROUNDTRIP(int stage2Entry, int c) {
        return (stage2Entry & 1 << 16 + (c & 0xF)) != 0;
    }

    static char MBCS_VALUE_2_FROM_STAGE_2(byte[] bytes, int stage2Entry, int c) {
        int i = 2 * (16 * ((char)stage2Entry & 0xFFFF) + (c & 0xF));
        return (char)((bytes[i] & 0xFF) << 8 | bytes[i + 1] & 0xFF);
    }

    static int MBCS_VALUE_4_FROM_STAGE_2(byte[] bytes, int stage2Entry, int c) {
        int i = 4 * (16 * ((char)stage2Entry & 0xFFFF) + (c & 0xF));
        return (bytes[i] & 0xFF) << 24 | (bytes[i + 1] & 0xFF) << 16 | (bytes[i + 2] & 0xFF) << 8 | bytes[i + 3] & 0xFF;
    }

    static int MBCS_POINTER_3_FROM_STAGE_2(byte[] bytes, int stage2Entry, int c) {
        return (16 * ((char)stage2Entry & 0xFFFF) + (c & 0xF)) * 3;
    }

    static final long LINEAR_18030(long a, long b, long c, long d) {
        return ((a * 10L + b) * 126L + c) * 10L + d;
    }

    static final long LINEAR(long x) {
        return UConverterSharedData_MBCS.LINEAR_18030(x >>> 24, x >>> 16 & 0xFFL, x >>> 8 & 0xFFL, x & 0xFFL);
    }

    private final class SideEffects {
        int c;
        int sourceArrayIndex;
        int sourceIndex;
        int nextSourceIndex;
        int prevSourceIndex;
        int targetArrayIndex;
        int targetCapacity;
        int prevLength;

        public SideEffects(int c_, int sourceArrayIndex_, int sourceIndex_, int nextSourceIndex_, int prevSourceIndex_, int targetArrayIndex_, int targetCapacity_, int prevLength_) {
            this.c = c_;
            this.sourceArrayIndex = sourceArrayIndex_;
            this.sourceIndex = sourceIndex_;
            this.nextSourceIndex = nextSourceIndex_;
            this.prevSourceIndex = prevSourceIndex_;
            this.targetArrayIndex = targetArrayIndex_;
            this.targetCapacity = targetCapacity_;
            this.prevLength = prevLength_;
        }
    }

    private final class SideEffectsSingleBMP {
        int c;
        int sourceArrayIndex;

        public SideEffectsSingleBMP(int c_, int sourceArrayIndex_) {
            this.c = c_;
            this.sourceArrayIndex = sourceArrayIndex_;
        }
    }

    private final class SideEffectsDouble {
        int c;
        int sourceArrayIndex;
        int sourceIndex;
        int nextSourceIndex;
        int targetArrayIndex;
        int targetCapacity;

        public SideEffectsDouble(int c_, int sourceArrayIndex_, int sourceIndex_, int nextSourceIndex_, int targetArrayIndex_, int targetCapacity_) {
            this.c = c_;
            this.sourceArrayIndex = sourceArrayIndex_;
            this.sourceIndex = sourceIndex_;
            this.nextSourceIndex = nextSourceIndex_;
            this.targetArrayIndex = targetArrayIndex_;
            this.targetCapacity = targetCapacity_;
        }
    }
}

