/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.awt.geom.AffineTransform;
import java.util.List;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.AbstractSVGMatrix;
import org.apache.batik.dom.svg.AttributeInitializer;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGExternalResourcesRequiredSupport;
import org.apache.batik.dom.svg.SVGLocatableSupport;
import org.apache.batik.dom.svg.SVGOMLength;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.apache.batik.dom.svg.SVGOMRect;
import org.apache.batik.dom.svg.SVGOMTransform;
import org.apache.batik.dom.svg.SVGPreserveAspectRatioSupport;
import org.apache.batik.dom.svg.SVGSVGContext;
import org.apache.batik.dom.svg.SVGStylableElement;
import org.apache.batik.dom.svg.SVGTestsSupport;
import org.apache.batik.dom.svg.SVGZoomAndPanSupport;
import org.apache.batik.dom.util.ListNodeList;
import org.apache.batik.dom.util.XMLSupport;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.stylesheets.DocumentStyle;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.svg.SVGAngle;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedPreserveAspectRatio;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGNumber;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGStringList;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGViewSpec;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class SVGOMSVGElement
extends SVGStylableElement
implements SVGSVGElement {
    protected static final AttributeInitializer attributeInitializer = new AttributeInitializer(7);

    protected SVGOMSVGElement() {
    }

    public SVGOMSVGElement(String prefix, AbstractDocument owner) {
        super(prefix, owner);
    }

    public String getLocalName() {
        return "svg";
    }

    public SVGAnimatedLength getX() {
        return this.getAnimatedLengthAttribute(null, "x", "0", (short)2);
    }

    public SVGAnimatedLength getY() {
        return this.getAnimatedLengthAttribute(null, "y", "0", (short)1);
    }

    public SVGAnimatedLength getWidth() {
        return this.getAnimatedLengthAttribute(null, "width", "100%", (short)2);
    }

    public SVGAnimatedLength getHeight() {
        return this.getAnimatedLengthAttribute(null, "height", "100%", (short)1);
    }

    public String getContentScriptType() {
        return this.getAttributeNS(null, "contentScriptType");
    }

    public void setContentScriptType(String type) {
        this.setAttributeNS(null, "contentScriptType", type);
    }

    public String getContentStyleType() {
        return this.getAttributeNS(null, "contentStyleType");
    }

    public void setContentStyleType(String type) {
        this.setAttributeNS(null, "contentStyleType", type);
    }

    public SVGRect getViewport() {
        SVGContext ctx = this.getSVGContext();
        return new SVGOMRect(0.0f, 0.0f, ctx.getViewportWidth(), ctx.getViewportHeight());
    }

    public float getPixelUnitToMillimeterX() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    public float getPixelUnitToMillimeterY() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    public float getScreenPixelToMillimeterX() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    public float getScreenPixelToMillimeterY() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    public boolean getUseCurrentView() {
        throw new Error();
    }

    public void setUseCurrentView(boolean useCurrentView) throws DOMException {
        throw new Error();
    }

    public SVGViewSpec getCurrentView() {
        throw new Error();
    }

    public float getCurrentScale() {
        AffineTransform scrnTrans = this.getSVGContext().getScreenTransform();
        if (scrnTrans != null) {
            return (float)Math.sqrt(scrnTrans.getDeterminant());
        }
        return 1.0f;
    }

    public void setCurrentScale(float currentScale) throws DOMException {
        SVGContext context = this.getSVGContext();
        AffineTransform scrnTrans = context.getScreenTransform();
        float scale = 1.0f;
        if (scrnTrans != null) {
            scale = (float)Math.sqrt(scrnTrans.getDeterminant());
        }
        float delta = currentScale / scale;
        scrnTrans = new AffineTransform(scrnTrans.getScaleX() * (double)delta, scrnTrans.getShearY() * (double)delta, scrnTrans.getShearX() * (double)delta, scrnTrans.getScaleY() * (double)delta, scrnTrans.getTranslateX(), scrnTrans.getTranslateY());
        context.setScreenTransform(scrnTrans);
    }

    public SVGPoint getCurrentTranslate() {
        final SVGOMSVGElement svgelt = this;
        return new SVGPoint(){

            AffineTransform getScreenTransform() {
                SVGContext context = svgelt.getSVGContext();
                return context.getScreenTransform();
            }

            public float getX() {
                AffineTransform scrnTrans = this.getScreenTransform();
                return (float)scrnTrans.getTranslateX();
            }

            public float getY() {
                AffineTransform scrnTrans = this.getScreenTransform();
                return (float)scrnTrans.getTranslateY();
            }

            public void setX(float newX) {
                SVGContext context = svgelt.getSVGContext();
                AffineTransform scrnTrans = context.getScreenTransform();
                scrnTrans = new AffineTransform(scrnTrans.getScaleX(), scrnTrans.getShearY(), scrnTrans.getShearX(), scrnTrans.getScaleY(), (double)newX, scrnTrans.getTranslateY());
                context.setScreenTransform(scrnTrans);
            }

            public void setY(float newY) {
                SVGContext context = svgelt.getSVGContext();
                AffineTransform scrnTrans = context.getScreenTransform();
                scrnTrans = new AffineTransform(scrnTrans.getScaleX(), scrnTrans.getShearY(), scrnTrans.getShearX(), scrnTrans.getScaleY(), scrnTrans.getTranslateX(), (double)newY);
                context.setScreenTransform(scrnTrans);
            }

            public SVGPoint matrixTransform(SVGMatrix mat) {
                AffineTransform scrnTrans = this.getScreenTransform();
                float x = (float)scrnTrans.getTranslateX();
                float y = (float)scrnTrans.getTranslateY();
                float newX = mat.getA() * x + mat.getC() * y + mat.getE();
                float newY = mat.getB() * x + mat.getD() * y + mat.getF();
                return new SVGOMPoint(newX, newY);
            }
        };
    }

    public int suspendRedraw(int max_wait_milliseconds) {
        throw new Error();
    }

    public void unsuspendRedraw(int suspend_handle_id) throws DOMException {
        throw new Error();
    }

    public void unsuspendRedrawAll() {
        throw new Error();
    }

    public void forceRedraw() {
        throw new Error();
    }

    public void pauseAnimations() {
        throw new Error();
    }

    public void unpauseAnimations() {
        throw new Error();
    }

    public boolean animationsPaused() {
        throw new Error();
    }

    public float getCurrentTime() {
        throw new Error();
    }

    public void setCurrentTime(float seconds) {
        throw new Error();
    }

    public NodeList getIntersectionList(SVGRect rect, SVGElement referenceElement) {
        SVGSVGContext ctx = (SVGSVGContext)this.getSVGContext();
        List list = ctx.getIntersectionList(rect, (Element)referenceElement);
        return new ListNodeList(list);
    }

    public NodeList getEnclosureList(SVGRect rect, SVGElement referenceElement) {
        SVGSVGContext ctx = (SVGSVGContext)this.getSVGContext();
        List list = ctx.getEnclosureList(rect, (Element)referenceElement);
        return new ListNodeList(list);
    }

    public boolean checkIntersection(SVGElement element, SVGRect rect) {
        SVGSVGContext ctx = (SVGSVGContext)this.getSVGContext();
        return ctx.checkIntersection((Element)element, rect);
    }

    public boolean checkEnclosure(SVGElement element, SVGRect rect) {
        SVGSVGContext ctx = (SVGSVGContext)this.getSVGContext();
        return ctx.checkEnclosure((Element)element, rect);
    }

    public void deselectAll() {
        ((SVGSVGContext)this.getSVGContext()).deselectAll();
    }

    public SVGNumber createSVGNumber() {
        return new SVGNumber(){
            float value;

            public float getValue() {
                return this.value;
            }

            public void setValue(float f) {
                this.value = f;
            }
        };
    }

    public SVGLength createSVGLength() {
        return new SVGOMLength(this);
    }

    public SVGAngle createSVGAngle() {
        throw new Error();
    }

    public SVGPoint createSVGPoint() {
        return new SVGOMPoint(0.0f, 0.0f);
    }

    public SVGMatrix createSVGMatrix() {
        return new AbstractSVGMatrix(){
            AffineTransform at = new AffineTransform();

            protected AffineTransform getAffineTransform() {
                return this.at;
            }
        };
    }

    public SVGRect createSVGRect() {
        return new SVGOMRect(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public SVGTransform createSVGTransform() {
        SVGOMTransform ret = new SVGOMTransform();
        ret.setType((short)1);
        return ret;
    }

    public SVGTransform createSVGTransformFromMatrix(SVGMatrix matrix) {
        SVGOMTransform tr = new SVGOMTransform();
        tr.setMatrix(matrix);
        return tr;
    }

    public Element getElementById(String elementId) {
        return this.ownerDocument.getChildElementById((Node)((Object)this), elementId);
    }

    public SVGElement getNearestViewportElement() {
        return SVGLocatableSupport.getNearestViewportElement((Element)((Object)this));
    }

    public SVGElement getFarthestViewportElement() {
        return SVGLocatableSupport.getFarthestViewportElement((Element)((Object)this));
    }

    public SVGRect getBBox() {
        return SVGLocatableSupport.getBBox((Element)((Object)this));
    }

    public SVGMatrix getCTM() {
        return SVGLocatableSupport.getCTM((Element)((Object)this));
    }

    public SVGMatrix getScreenCTM() {
        return SVGLocatableSupport.getScreenCTM((Element)((Object)this));
    }

    public SVGMatrix getTransformToElement(SVGElement element) throws SVGException {
        return SVGLocatableSupport.getTransformToElement((Element)((Object)this), element);
    }

    public DocumentView getDocument() {
        return (DocumentView)((Object)this.getOwnerDocument());
    }

    public CSSStyleDeclaration getComputedStyle(Element elt, String pseudoElt) {
        AbstractView av = ((DocumentView)((Object)this.getOwnerDocument())).getDefaultView();
        return ((ViewCSS)av).getComputedStyle(elt, pseudoElt);
    }

    public Event createEvent(String eventType) throws DOMException {
        return ((DocumentEvent)((Object)this.getOwnerDocument())).createEvent(eventType);
    }

    public StyleSheetList getStyleSheets() {
        return ((DocumentStyle)((Object)this.getOwnerDocument())).getStyleSheets();
    }

    public CSSStyleDeclaration getOverrideStyle(Element elt, String pseudoElt) {
        return ((DocumentCSS)((Object)this.getOwnerDocument())).getOverrideStyle(elt, pseudoElt);
    }

    public String getXMLlang() {
        return XMLSupport.getXMLLang((Element)((Object)this));
    }

    public void setXMLlang(String lang) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", lang);
    }

    public String getXMLspace() {
        return XMLSupport.getXMLSpace((Element)((Object)this));
    }

    public void setXMLspace(String space) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", space);
    }

    public short getZoomAndPan() {
        return SVGZoomAndPanSupport.getZoomAndPan((Element)((Object)this));
    }

    public void setZoomAndPan(short val) {
        SVGZoomAndPanSupport.setZoomAndPan((Element)((Object)this), val);
    }

    public SVGAnimatedRect getViewBox() {
        throw new RuntimeException(" !!! TODO: getViewBox()");
    }

    public SVGAnimatedPreserveAspectRatio getPreserveAspectRatio() {
        return SVGPreserveAspectRatioSupport.getPreserveAspectRatio(this);
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        return SVGExternalResourcesRequiredSupport.getExternalResourcesRequired(this);
    }

    public SVGStringList getRequiredFeatures() {
        return SVGTestsSupport.getRequiredFeatures((Element)((Object)this));
    }

    public SVGStringList getRequiredExtensions() {
        return SVGTestsSupport.getRequiredExtensions((Element)((Object)this));
    }

    public SVGStringList getSystemLanguage() {
        return SVGTestsSupport.getSystemLanguage((Element)((Object)this));
    }

    public boolean hasExtension(String extension) {
        return SVGTestsSupport.hasExtension((Element)((Object)this), extension);
    }

    protected AttributeInitializer getAttributeInitializer() {
        return attributeInitializer;
    }

    protected Node newNode() {
        return new SVGOMSVGElement();
    }

    static {
        attributeInitializer.addAttribute("http://www.w3.org/2000/xmlns/", null, "xmlns", "http://www.w3.org/2000/svg");
        attributeInitializer.addAttribute("http://www.w3.org/2000/xmlns/", "xmlns", "xlink", "http://www.w3.org/1999/xlink");
        attributeInitializer.addAttribute(null, null, "preserveAspectRatio", "xMidYMid meet");
        attributeInitializer.addAttribute(null, null, "zoomAndPan", "magnify");
        attributeInitializer.addAttribute(null, null, "version", "1.0");
        attributeInitializer.addAttribute(null, null, "contentScriptType", "text/ecmascript");
        attributeInitializer.addAttribute(null, null, "contentStyleType", "text/css");
    }
}

