/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.lang;

import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.lang.DeclarationHandler;
import flex2.compiler.mxml.lang.NodeTypeResolver;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.mxml.reflect.Effect;
import flex2.compiler.mxml.reflect.Event;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Style;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import java.util.Iterator;

public abstract class ChildNodeHandler
extends DeclarationHandler {
    protected final TypeTable typeTable;
    protected final NodeTypeResolver nodeTypeResolver;
    protected final CoreDeclarationHandler coreDeclarationHandler;
    protected Node parent;
    protected Type parentType;
    protected Node child;
    protected int state;
    protected static final int STATE_BEFORE_DP_CHILDREN = 0;
    protected static final int STATE_IN_DP_CHILDREN = 1;
    protected static final int STATE_AFTER_DP_CHILDREN = 2;
    protected static final int NUM_STATES = 3;
    protected static final int STATE_BITS = 15;
    protected static final int INPUT_NON_DP_CHILD = 0;
    protected static final int INPUT_DP_CHILD = 1;
    protected static final int NUM_INPUTS = 2;
    protected static final int ERR_DP_LOCATION = 32768;
    protected static final int[] TRAN;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ChildNodeHandler(TypeTable typeTable) {
        this.typeTable = typeTable;
        this.nodeTypeResolver = new NodeTypeResolver(typeTable);
        this.coreDeclarationHandler = new CoreDeclarationHandler();
    }

    protected abstract void defaultPropertyElement(boolean var1);

    protected abstract void nestedDeclaration();

    protected abstract void textContent();

    protected abstract void languageNode();

    public void scanChildNodes(Node node, Type type) {
        this.resetState();
        Iterator iter = node.getChildIterator();
        while (iter.hasNext()) {
            this.invoke(node, type, (Node)iter.next());
        }
    }

    protected void invoke(Node parent, Type parentType, Node child) {
        this.parent = parent;
        this.parentType = parentType;
        this.child = child;
        if (child instanceof CDATANode) {
            if (parentType.getDefaultProperty() != null && (((CDATANode)child).inCDATA || !TextParser.isBindingExpression(child.image))) {
                this.transition(1);
                this.defaultPropertyElement(this.getError() == 32768);
            } else {
                this.transition(0);
                this.textContent();
            }
        } else if (NodeTypeResolver.isValueNode(child)) {
            String namespace = child.getNamespace();
            String localPart = child.getLocalPart();
            if (child.getAttributeCount() == 0 && namespace.equals(this.parent.getNamespace())) {
                this.coreDeclarationHandler.invoke(this.parentType, localPart);
            } else {
                this.unknown(null);
            }
        } else {
            this.transition(0);
            this.languageNode();
        }
    }

    protected final void unknown(String name) {
        if (this.parentType.getDefaultProperty() != null) {
            this.transition(1);
            this.defaultPropertyElement(this.getError() == 32768);
        } else {
            this.transition(0);
            this.nestedDeclaration();
        }
    }

    protected int getState() {
        return this.state & 0xF;
    }

    protected int getError() {
        return this.state & 0xFFFFFFF0;
    }

    protected void resetState() {
        this.state = 0;
    }

    protected void transition(int input) {
        this.state = TRAN[this.getState() * 2 + input];
    }

    static {
        $assertionsDisabled = !ChildNodeHandler.class.desiredAssertionStatus();
        TRAN = new int[]{0, 1, 2, 1, 2, 32770};
        if (!$assertionsDisabled && TRAN.length != 6) {
            throw new AssertionError();
        }
    }

    protected final class CoreDeclarationHandler
    extends DeclarationHandler {
        protected CoreDeclarationHandler() {
        }

        protected void event(Event event) {
            ChildNodeHandler.this.transition(0);
            ChildNodeHandler.this.event(event);
        }

        protected void property(Property property) {
            ChildNodeHandler.this.transition(0);
            ChildNodeHandler.this.property(property);
        }

        protected void effect(Effect effect) {
            ChildNodeHandler.this.transition(0);
            ChildNodeHandler.this.effect(effect);
        }

        protected void style(Style style) {
            ChildNodeHandler.this.transition(0);
            ChildNodeHandler.this.style(style);
        }

        protected void dynamicProperty(String name) {
            ChildNodeHandler.this.transition(0);
            ChildNodeHandler.this.dynamicProperty(name);
        }

        protected void unknown(String name) {
            ChildNodeHandler.this.unknown(name);
        }
    }
}

