/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.events;

import flex.webtier.server.j2ee.events.CompileEvent;
import flex.webtier.server.j2ee.events.SourceCodeLoader;
import flex.webtier.server.j2ee.events.SourceCodeSnippet;
import flex.webtier.services.ServiceFactory;
import flex.webtier.services.config.ServerConfiguration;
import flex.webtier.services.logging.Logger;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

public abstract class BaseOutputHandler {
    protected String sourceFileName;
    protected String defaultPath;
    protected boolean warnings = true;
    public Vector events;
    protected boolean showSourceCodeInCompilerErrors = true;
    protected boolean showStacktrace = true;
    protected boolean logCompilerErrors = true;
    protected boolean keepGeneratedAS = true;
    protected String encoding;
    protected SourceCodeLoader sourceCodeLoader;

    public BaseOutputHandler(String mxmlFileName, String rootPath, Vector events, SourceCodeLoader sourceCodeLoader) {
        ServerConfiguration cfg = ServiceFactory.getConfigurator().getServerConfiguration();
        this.showSourceCodeInCompilerErrors = cfg.getDebuggingConfiguration().showSourceInCompilerErrors();
        this.showStacktrace = cfg.getDebuggingConfiguration().showStacktrace();
        this.logCompilerErrors = cfg.getDebuggingConfiguration().logCompilerErrors();
        this.keepGeneratedAS = cfg.getFlexConfigConfiguration().getCompilerConfiguration().keepGeneratedActionScript();
        this.encoding = cfg.getFlexConfigConfiguration().getCompilerConfiguration().getActionscriptFileEncoding();
        this.sourceFileName = mxmlFileName;
        this.defaultPath = rootPath;
        this.events = events;
        this.sourceCodeLoader = sourceCodeLoader;
    }

    private void appendException(Throwable throwable, StringBuffer buf) {
        String msg;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String desc = throwable.toString();
        int pos = desc.indexOf(":");
        if (pos > -1) {
            desc = desc.substring(0, pos);
        }
        if ((msg = throwable.getMessage()) == null) {
            msg = "";
        }
        buf.append("Exception ");
        buf.append(desc);
        buf.append("\n");
        buf.append(msg);
        throwable.printStackTrace(pw);
        pos = sw.toString().indexOf(10);
        buf.append(sw.toString().substring(pos + 1));
        Throwable rootCause = null;
        try {
            Method rootCauseMethod = throwable.getClass().getMethod("getRootCause", null);
            rootCause = (Throwable)rootCauseMethod.invoke((Object)throwable, null);
        }
        catch (Exception ignorableReflectionEx) {
            // empty catch block
        }
        if (rootCause != null) {
            pw.flush();
            sw.flush();
            desc = rootCause.toString();
            pos = desc.indexOf(":");
            if (pos > -1) {
                desc = desc.substring(0, pos);
            }
            if ((msg = throwable.getMessage()) == null) {
                msg = "";
            }
            buf.append("Root Cause Exception ");
            buf.append(desc);
            buf.append(" ");
            buf.append(msg);
            buf.append("\n");
            rootCause.printStackTrace(pw);
            pos = sw.toString().indexOf(10);
            buf.append(sw.toString().substring(pos + 1));
        }
    }

    private void loadSourceCodeSnippets() {
        boolean contextLines = true;
        TreeSet<Integer> srcLineNumbers = new TreeSet<Integer>();
        for (int currentEventIndex = 0; currentEventIndex < this.events.size(); ++currentEventIndex) {
            CompileEvent ce = (CompileEvent)this.events.get(currentEventIndex);
            if (ce.path == null || ce.line == 0 || ce.sourceSnippet != null) continue;
            String path = ce.path;
            for (int j = currentEventIndex; j < this.events.size(); ++j) {
                CompileEvent ce2 = (CompileEvent)this.events.get(j);
                if (ce2.sourceSnippet != null || ce2.line == 0 || ce2.path == null || !ce2.path.equals(path)) continue;
                int l = ce2.line - 1;
                if (l < 0) {
                    l = 0;
                }
                while (l <= ce2.line + 1) {
                    srcLineNumbers.add(new Integer(l));
                    ++l;
                }
            }
            try {
                if (this.sourceCodeLoader == null) {
                    Logger logger = ServiceFactory.getLogger();
                    logger.logWarning("Skipping source code snippet because '" + ce.path + "' could not be loaded.");
                    continue;
                }
                Map srcLinesText = this.sourceCodeLoader.getSourceForLineNumbers(path, srcLineNumbers, this.encoding);
                for (int j = currentEventIndex; j < this.events.size(); ++j) {
                    CompileEvent ce2 = (CompileEvent)this.events.get(j);
                    if (ce2.line == 0 || ce2.sourceSnippet != null || ce2.path == null || !ce2.path.equals(path)) continue;
                    int startingLine = ce2.line - 1;
                    if (startingLine < 0) {
                        startingLine = 0;
                    }
                    int numberOfLines = ce2.line + 1 - startingLine + 1;
                    String[] lines = new String[numberOfLines];
                    for (int k = 0; k < numberOfLines; ++k) {
                        lines[k] = (String)srcLinesText.get(new Integer(startingLine + k));
                    }
                    ce2.sourceSnippet = new SourceCodeSnippet(startingLine, lines);
                }
                srcLineNumbers.clear();
                srcLinesText.clear();
                continue;
            }
            catch (IOException ioe) {
                Logger logger = ServiceFactory.getLogger();
                logger.logWarning("Skipping source code snippet because '" + ce.path + "' could not be loaded.");
            }
        }
    }

    private void clearSourceCodeSnippets() {
        for (int i = 0; i < this.events.size(); ++i) {
            CompileEvent ce = (CompileEvent)this.events.get(i);
            if (ce.sourceSnippet == null) continue;
            ce.sourceSnippet = null;
        }
    }

    private boolean hasException() {
        boolean exception = false;
        Enumeration enumeration = this.events.elements();
        while (enumeration.hasMoreElements() && !exception) {
            CompileEvent event = (CompileEvent)enumeration.nextElement();
            if (event.eventType != 3) continue;
            exception = true;
        }
        return exception;
    }

    public void logCompilerResults() {
        if (this.hasException() && !this.logCompilerErrors) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("Exception(s) generated while compiling " + this.sourceFileName);
            for (int i = 0; i < this.events.size(); ++i) {
                CompileEvent ce = (CompileEvent)this.events.get(i);
                if (ce.eventType != 3) continue;
                ce.exception.printStackTrace(pw);
            }
            ServiceFactory.getLogger().logError(sw.toString());
        } else if (this.events.size() != 0 && this.logCompilerErrors) {
            this.logIndividualEventsToLogger();
        }
    }

    public final void output() {
        this.logCompilerResults();
        if (this.showSourceCodeInCompilerErrors) {
            this.loadSourceCodeSnippets();
        }
        this.outputEvents();
        this.clearSourceCodeSnippets();
    }

    protected abstract void outputEvents();

    public String summary() {
        int i;
        int[] arr = new int[4];
        String[] names = new String[4];
        StringBuffer buf = new StringBuffer();
        int totalEvents = this.events.size();
        CompileEvent ce = null;
        for (i = 0; i < this.events.size(); ++i) {
            ce = (CompileEvent)this.events.get(i);
            int n = ce.eventType;
            arr[n] = arr[n] + 1;
            names[ce.eventType] = ce.getEventTypeName();
        }
        for (i = 0; i < 4; ++i) {
            if (arr[i] <= 0) continue;
            buf.append(arr[i]);
            buf.append(" ");
            buf.append(names[i]);
            if (arr[i] > 1) {
                buf.append("s");
            }
            if ((totalEvents -= arr[i]) <= 0) continue;
            buf.append(", ");
        }
        buf.append(" found.");
        return buf.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.summary());
        result.append("\n");
        for (int i = 0; i < this.events.size(); ++i) {
            CompileEvent ce = (CompileEvent)this.events.get(i);
            if (ce.eventType == 3) {
                this.appendException(ce.exception, result);
            } else {
                this.logIndividualEvent(ce, result, false);
            }
            result.append("\n");
        }
        return result.toString();
    }

    protected void logIndividualEvent(CompileEvent ce, StringBuffer sb, boolean toLogger) {
        String lineRef = ce.line == 0 ? "" : ":" + ce.line;
        String docPath = ce.path == null ? "" : ce.path;
        if (!toLogger) {
            sb.append(ce.getEventTypeName());
            sb.append(" ");
        }
        sb.append(docPath);
        sb.append(lineRef);
        sb.append("\n");
        sb.append(ce.description);
        sb.append("\n");
        if (this.keepGeneratedAS && ce.asPath != null) {
            sb.append("at ");
            sb.append(ce.asPath);
            sb.append(":");
            sb.append(ce.asLine);
            sb.append("\n");
        }
        if (ce.sourceSnippet != null) {
            sb.append("\n");
            sb.append(ce.sourceSnippet);
        }
    }

    public void logIndividualEventsToLogger() {
        Logger logger = ServiceFactory.getLogger();
        for (int i = 0; i < this.events.size(); ++i) {
            StringBuffer sb;
            CompileEvent ce = (CompileEvent)this.events.get(i);
            if (ce.eventType == 3) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ce.exception.printStackTrace(pw);
                logger.logError(sw.toString());
                continue;
            }
            if (ce.eventType == 1) {
                sb = new StringBuffer();
                this.logIndividualEvent(ce, sb, true);
                logger.logError(sb.toString());
                continue;
            }
            if (ce.eventType == 2 && logger.isWarningEnabled()) {
                sb = new StringBuffer();
                this.logIndividualEvent(ce, sb, true);
                logger.logWarning(sb.toString());
                continue;
            }
            if (ce.eventType != 0 || !logger.isInfoEnabled()) continue;
            sb = new StringBuffer();
            this.logIndividualEvent(ce, sb, true);
            logger.logInfo(sb.toString());
        }
    }
}

