/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.html;

import flex.webtier.server.j2ee.MxmlContext;
import flex.webtier.server.j2ee.URLEncoder;
import flex.webtier.server.j2ee.filemanager.HistoryFileManager;
import flex.webtier.server.j2ee.html.HistorySettings;
import flex.webtier.server.j2ee.html.JavascriptWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class HistoryRenderer {
    private HistorySettings historySettings;

    public HistoryRenderer(MxmlContext context) {
        this.historySettings = context.getHistorySettings();
    }

    public void renderJavaScriptImport(PrintWriter output, boolean firstOnPage) {
        if (firstOnPage && this.historySettings.enabled()) {
            output.println("<script language='javascript' charset='utf-8' src='" + this.historySettings.getJsUri() + "'></script>");
        }
    }

    public void renderJavaScript(PrintWriter output, boolean firstOnPage) {
        if (firstOnPage && this.historySettings.enabled()) {
            output.println("<!-- history management javascript -->");
            try {
                ByteArrayOutputStream bos = HistoryFileManager.getInstance().getHistoryJavascript();
                output.println(bos.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void renderIframe(MxmlContext context, PrintWriter output, boolean firstOnPage) {
        String historyLocation = context.isSecureRequest() ? this.historySettings.getHtmlSecureUri() : this.historySettings.getHtmlUri();
        if (firstOnPage && this.historySettings.enabled()) {
            output.println("<script language='javascript' charset='utf-8'>");
            JavascriptWriter.renderBeginDocWrite(output);
            output.print("<br>");
            output.print("<iframe src='" + historyLocation + "' name='_history' frameborder='0' scrolling='no' width='22' height='0'></iframe></br>");
            JavascriptWriter.renderEndDocWrite(output);
            output.println();
            output.println("</script>");
        }
    }

    public String renderHistoryFlashVars(MxmlContext context) {
        String history = "";
        if (this.historySettings.enabled()) {
            String historyLocation = context.isSecureRequest() ? this.historySettings.getHtmlSecureUri() : this.historySettings.getHtmlUri();
            history = "historyUrl=" + URLEncoder.encode(historyLocation) + "&lconid=\" + lc_id + \"";
        }
        return history;
    }
}

