/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.services.config;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flash.localization.XLRLocalizer;
import flex.webtier.server.j2ee.ServletPathResolver;
import flex.webtier.services.ServiceFactory;
import flex.webtier.services.config.ExceptionLogger;
import flex.webtier.services.config.RequestConfigurator;
import flex.webtier.services.config.ServerConfiguration;
import flex.webtier.services.config.ServerDefaultsConfigurator;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.FileConfigurator;
import flex2.compiler.config.SystemPropertyConfigurator;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class Configurator {
    private long configurationVersion;
    private ServletPathResolver resolver;
    private ServletContext servletContext;
    private String flexDir;
    private String fileName;
    private static ArrayList warnings = new ArrayList();
    private ServerConfiguration serverConfig;
    private ConfigurationBuffer defaultBuf;
    private ServerConfiguration defaultConfig;

    public void init(String flexDir, String fileName, long version, ServletContext servletContext) throws Exception {
        this.flexDir = flexDir;
        this.fileName = fileName;
        this.configurationVersion = version;
        this.servletContext = servletContext;
        this.serverConfig = this.loadServerConfiguration();
    }

    public static void storeWarning(String msg) {
        warnings.add(msg);
    }

    public void logStoredWarnings() {
        Iterator iterator = warnings.iterator();
        while (iterator.hasNext()) {
            String msg = (String)iterator.next();
            ServiceFactory.getLogger().logWarning(msg);
        }
        warnings.clear();
    }

    public long getVersion() {
        return this.configurationVersion;
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfig;
    }

    public ServerConfiguration loadServerConfiguration() throws ConfigurationException {
        ConfigurationBuffer serverBuffer = new ConfigurationBuffer(ServerConfiguration.class);
        serverBuffer.setToken("flexlib", this.flexDir);
        ServerDefaultsConfigurator.loadDefaults(serverBuffer, this.servletContext);
        SystemPropertyConfigurator.load((ConfigurationBuffer)serverBuffer, (String)"flex");
        FileConfigurator.load((ConfigurationBuffer)serverBuffer, (String)this.fileName, (String)"flex-webtier-config");
        ServerConfiguration config = new ServerConfiguration();
        this.resolver = new ServletPathResolver(this.servletContext);
        File configFile = new File(this.fileName);
        this.resolver.setRoot(configFile.getParent());
        config.getFlexConfigConfiguration().setConfigPathResolver((ConfigurationPathResolver)this.resolver);
        serverBuffer.commit((Object)config);
        this.defaultBuf = serverBuffer;
        this.defaultConfig = config;
        return config;
    }

    public String getMessage(ConfigurationException e) {
        LocalizationManager lm = ThreadLocalToolkit.getLocalizationManager();
        LocalizationManager localizationManager = new LocalizationManager();
        localizationManager.addLocalizer((ILocalizer)new XLRLocalizer());
        localizationManager.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
        ThreadLocalToolkit.setLocalizationManager((LocalizationManager)localizationManager);
        String message = new ExceptionLogger().getMessage((ILocalizableMessage)e);
        ThreadLocalToolkit.setLocalizationManager((LocalizationManager)lm);
        return message;
    }

    public ServerConfiguration generateConfiguration(HttpServletRequest request, File appFile, Map dependencies) throws ConfigurationException {
        ServerConfiguration newConfig = new ServerConfiguration();
        try {
            String appPath;
            int dot;
            this.loadServerConfiguration();
            long modified = new File(this.fileName).lastModified();
            modified -= modified % 1000L;
            dependencies.put(this.fileName, new Long(modified));
            String flexConfigFilePath = this.getServerConfiguration().getFlexConfigFilePath();
            if (flexConfigFilePath != null) {
                modified = new File(flexConfigFilePath).lastModified();
                modified -= modified % 1000L;
                dependencies.put(flexConfigFilePath, new Long(modified));
            }
            ConfigurationBuffer configBuf = new ConfigurationBuffer(this.defaultBuf, false);
            if (appFile != null && (dot = (appPath = appFile.getAbsolutePath()).lastIndexOf(46)) != -1) {
                try {
                    InputStream in;
                    ConfigurationBuffer projectBuf = new ConfigurationBuffer(configBuf.getChildConfigClass("flex-config"));
                    String appConfigFile = appPath.substring(0, dot) + "-config.xml";
                    VirtualFile projectFile = this.resolver.resolve(appConfigFile);
                    if (projectFile != null && (in = projectFile.getInputStream()) != null) {
                        long lastmod = projectFile.getLastModified();
                        if (lastmod != -1L) {
                            lastmod -= lastmod % 1000L;
                            dependencies.put(projectFile.getName(), new Long(lastmod));
                        }
                        FileConfigurator.load((ConfigurationBuffer)projectBuf, (Reader)new InputStreamReader(in), (String)projectFile.getName(), (String)projectFile.getParent(), (String)"flex-config");
                        configBuf.mergeChild("flex-config", projectBuf);
                    }
                }
                catch (Exception e) {
                    ServiceFactory.getLogger().logWarning(e.getMessage());
                }
            }
            ConfigurationBuffer requestBuf = new ConfigurationBuffer(ServerConfiguration.class);
            new RequestConfigurator().parse(requestBuf, this.defaultConfig, request);
            configBuf.merge(requestBuf);
            newConfig.getFlexConfigConfiguration().setConfigPathResolver((ConfigurationPathResolver)this.resolver);
            this.processProductionMode(configBuf);
            configBuf.commit((Object)newConfig);
            this.calculateServicesChecksum(newConfig, configBuf);
            newConfig.setChecksum_ts(configBuf.checksum_ts());
        }
        catch (ConfigurationException ce) {
            ConfigurationException c = new ConfigurationException(new ExceptionLogger().getMessage((ILocalizableMessage)ce));
            c.setStackTrace(ce.getStackTrace());
            throw c;
        }
        return newConfig;
    }

    public void calculateServicesChecksum(ServerConfiguration config, ConfigurationBuffer cfgbuf) {
        Map services = null;
        if (config.getFlexConfigConfiguration().getCompilerConfiguration().getServicesDependencies() != null) {
            services = config.getFlexConfigConfiguration().getCompilerConfiguration().getServicesDependencies().getConfigPaths();
        }
        if (services != null) {
            Iterator iter = services.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                cfgbuf.calculateChecksum((String)entry.getKey(), (Long)entry.getValue());
            }
        }
    }

    private void processProductionMode(ConfigurationBuffer configBuf) throws ConfigurationException {
        if (this.defaultConfig.isProductionMode()) {
            ConfigurationBuffer productionBuf = new ConfigurationBuffer(ServerConfiguration.class);
            productionBuf.setVar("flex-config.compiler.verbose-stacktraces", "false", "production-mode", -1);
            productionBuf.setVar("flex-config.compiler.show-binding-warnings", "false", "production-mode", -1);
            productionBuf.setVar("flex-config.compiler.show-deprecation-warnings", "false", "production-mode", -1);
            productionBuf.setVar("flex-config.compiler.keep-generated-actionscript", "false", "production-mode", -1);
            productionBuf.setVar("flex-config.compiler.show-actionscript-warnings", "false", "production-mode", -1);
            productionBuf.setVar("flex-config.compiler.strict", "false", "production-mode", -1);
            productionBuf.setVar("flex-config.compiler.debug", "false", "production-mode", -1);
            productionBuf.setVar("debugging.process-debug-query-params", "false", "production-mode", -1);
            productionBuf.setVar("debugging.generate-profile-swfs", "false", "production-mode", -1);
            productionBuf.setVar("debugging.keep-generated-swfs", "false", "production-mode", -1);
            productionBuf.setVar("debugging.show-all-warnings", "false", "production-mode", -1);
            productionBuf.setVar("debugging.show-override-warnings", "false", "production-mode", -1);
            productionBuf.setVar("debugging.show-source-in-compiler-errors", "false", "production-mode", -1);
            productionBuf.setVar("debugging.log-compiler-errors", "false", "production-mode", -1);
            productionBuf.setVar("debugging.create-compile-report", "false", "production-mode", -1);
            configBuf.merge(productionBuf);
        }
    }
}

