/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import macromedia.abc.BytecodeBuffer;
import macromedia.abc.DecoderException;
import macromedia.abc.IndexHistory;
import macromedia.abc.MultiName;
import macromedia.abc.QName;
import macromedia.abc.Scanner;
import macromedia.asc.util.IntegerPool;

public class ConstantPool {
    public static final Object NULL = new Object();
    BytecodeBuffer in;
    IndexHistory history;
    private int size;
    int[] intpositions;
    int[] uintpositions;
    int[] doublepositions;
    int[] strpositions;
    int[] nspositions;
    int[] nsspositions;
    int[] mnpositions;
    int intEnd;
    int uintEnd;
    int doubleEnd;
    int strEnd;
    int nsEnd;
    int nssEnd;
    int mnEnd;

    public static ConstantPool merge(ConstantPool[] constantPoolArray) {
        int n = 0;
        int n2 = constantPoolArray.length;
        for (int i = 0; i < n2; ++i) {
            n += constantPoolArray[i].mnEnd;
        }
        ConstantPool constantPool = new ConstantPool();
        constantPool.in = new BytecodeBuffer(n);
        constantPool.history = new IndexHistory(constantPoolArray);
        return constantPool;
    }

    ConstantPool() {
    }

    public ConstantPool(BytecodeBuffer bytecodeBuffer) throws DecoderException {
        this.in = bytecodeBuffer;
        this.scan();
    }

    private void scan() throws DecoderException {
        this.intpositions = Scanner.scanIntConstants(this.in);
        this.intEnd = this.in.pos();
        this.uintpositions = Scanner.scanUIntConstants(this.in);
        this.uintEnd = this.in.pos();
        this.doublepositions = Scanner.scanDoubleConstants(this.in);
        this.doubleEnd = this.in.pos();
        this.strpositions = Scanner.scanStrConstants(this.in);
        this.strEnd = this.in.pos();
        this.nspositions = Scanner.scanNsConstants(this.in);
        this.nsEnd = this.in.pos();
        this.nsspositions = Scanner.scanNsSetConstants(this.in);
        this.nssEnd = this.in.pos();
        this.mnpositions = Scanner.scanMultinameConstants(this.in);
        this.mnEnd = this.in.pos();
        this.size = (this.intpositions.length == 0 ? 0 : this.intpositions.length - 1) + (this.uintpositions.length == 0 ? 0 : this.uintpositions.length - 1) + (this.doublepositions.length == 0 ? 0 : this.doublepositions.length - 1) + (this.strpositions.length == 0 ? 0 : this.strpositions.length - 1) + (this.nspositions.length == 0 ? 0 : this.nspositions.length - 1) + (this.nsspositions.length == 0 ? 0 : this.nsspositions.length - 1) + (this.mnpositions.length == 0 ? 0 : this.mnpositions.length - 1);
    }

    public int size() {
        return this.size;
    }

    public int getInt(int n) throws DecoderException {
        if (n == 0) {
            return 0;
        }
        int n2 = this.intpositions[n];
        int n3 = this.in.pos();
        this.in.seek(n2);
        int n4 = this.in.readU32();
        this.in.seek(n3);
        return n4;
    }

    public long getLong(int n) throws DecoderException {
        if (n == 0) {
            return 0L;
        }
        int n2 = this.uintpositions[n];
        int n3 = this.in.pos();
        this.in.seek(n2);
        long l = this.in.readU32();
        this.in.seek(n3);
        return l;
    }

    public double getDouble(int n) throws DecoderException {
        if (n == 0) {
            return 0.0;
        }
        int n2 = this.doublepositions[n];
        int n3 = this.in.pos();
        this.in.seek(n2);
        double d = this.in.readDouble();
        this.in.seek(n3);
        return d;
    }

    public String getString(int n) throws DecoderException {
        if (n == 0) {
            return null;
        }
        int n2 = this.strpositions[n];
        int n3 = this.in.pos();
        this.in.seek(n2);
        String string = this.in.readString(this.in.readU32());
        this.in.seek(n3);
        if (string != null) {
            return string;
        }
        throw new DecoderException("abc Decoder Erro: problem reading UTF-8 encoded strings.");
    }

    public String getNamespaceName(int n) throws DecoderException {
        if (n == 0) {
            return null;
        }
        int n2 = this.nspositions[n];
        int n3 = this.in.pos();
        this.in.seek(n2);
        int n4 = this.in.readU8();
        String string = "";
        switch (n4) {
            case 5: 
            case 8: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = this.getString(this.in.readU32());
                break;
            }
            default: {
                throw new DecoderException("abc Decoder Error: constant pool index '" + n + "' is not a Namespace type. The actual type is '" + n4 + "'");
            }
        }
        this.in.seek(n3);
        return string;
    }

    public String[] getNamespaceSet(int n) throws DecoderException {
        if (n == 0) {
            return null;
        }
        int n2 = this.nsspositions[n];
        int n3 = this.in.pos();
        this.in.seek(n2);
        int n4 = this.in.readU32();
        String[] stringArray = new String[n4];
        for (int i = 0; i < n4; ++i) {
            stringArray[i] = this.getNamespaceName(this.in.readU32());
        }
        this.in.seek(n3);
        if (stringArray != null) {
            return stringArray;
        }
        throw new DecoderException("abc Decoder Erro: problem reading namespace set.");
    }

    public int getNamespaceIndexForQName(int n) throws DecoderException {
        if (n == 0) {
            return 0;
        }
        int n2 = this.mnpositions[n];
        int n3 = this.in.pos();
        this.in.seek(n2);
        int n4 = this.in.readU8();
        switch (n4) {
            case 7: 
            case 13: {
                int n5 = this.in.readU32();
                this.in.seek(n3);
                return n5;
            }
        }
        this.in.seek(n3);
        throw new DecoderException("abc Decoder Error: constant pool index '" + n + "' is not a QName type. The actual type is '" + n4 + "'");
    }

    public int getNamespaceKind(int n) {
        if (n == 0) {
            return -1;
        }
        int n2 = this.nspositions[n];
        int n3 = this.in.pos();
        this.in.seek(n2);
        int n4 = this.in.readU8();
        this.in.seek(n3);
        return n4;
    }

    public QName getQName(int n) throws DecoderException {
        if (n == 0) {
            return null;
        }
        int n2 = this.mnpositions[n];
        int n3 = this.in.pos();
        this.in.seek(n2);
        int n4 = this.in.readU8();
        switch (n4) {
            case 7: 
            case 13: {
                int n5 = this.in.readU32();
                int n6 = this.in.readU32();
                QName qName = this.createQName(this.getNamespaceName(n5), this.getString(n6));
                this.in.seek(n3);
                return qName;
            }
        }
        this.in.seek(n3);
        throw new DecoderException("abc Decoder Error: constant pool index '" + n + "' is not a QName type. The actual type is '" + n4 + "'");
    }

    public MultiName getMultiName(int n) throws DecoderException {
        if (n == 0) {
            return null;
        }
        int n2 = this.mnpositions[n];
        int n3 = this.in.pos();
        this.in.seek(n2);
        int n4 = this.in.readU8();
        switch (n4) {
            case 9: 
            case 14: {
                String string = this.getString(this.in.readU32());
                int n5 = this.in.readU32();
                String[] stringArray = this.getNamespaceSet(n5);
                MultiName multiName = this.createMultiName(string, stringArray);
                this.in.seek(n3);
                return multiName;
            }
        }
        this.in.seek(n3);
        throw new DecoderException("abc Decoder Error: constant constantPool index '" + n + "' is not a MultiName type. The actual type is '" + n4 + "'");
    }

    public Object getGeneralMultiname(int n) throws DecoderException {
        if (n == 0) {
            return null;
        }
        int n2 = this.mnpositions[n];
        int n3 = this.in.pos();
        this.in.seek(n2);
        int n4 = this.in.readU8();
        switch (n4) {
            case 7: 
            case 13: {
                int n5 = this.in.readU32();
                int n6 = this.in.readU32();
                QName qName = this.createQName(this.getNamespaceName(n5), this.getString(n6));
                this.in.seek(n3);
                return qName;
            }
            case 9: 
            case 14: {
                String string = this.getString(this.in.readU32());
                int n7 = this.in.readU32();
                String[] stringArray = this.getNamespaceSet(n7);
                MultiName multiName = this.createMultiName(string, stringArray);
                this.in.seek(n3);
                return multiName;
            }
            case 17: {
                this.in.seek(n3);
                return "CONSTANT_RTQnameL";
            }
            case 18: {
                this.in.seek(n3);
                return "CONSTANT_RTQnameLA";
            }
            case 27: 
            case 28: {
                int n8 = this.in.readU32();
                String[] stringArray = this.getNamespaceSet(n8);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(stringArray[i]);
                }
                this.in.seek(n3);
                return arrayList;
            }
            case 15: 
            case 16: {
                int n9 = this.in.readU32();
                String string = this.getString(n9);
                this.in.seek(n3);
                return string;
            }
        }
        this.in.seek(n3);
        throw new DecoderException("abc Decoder Error: constant pool index '" + n + "' is not a QName type. The actual type is '" + n4 + "'");
    }

    public Object get(int n, int n2) throws DecoderException {
        if (n == 0) {
            return null;
        }
        switch (n2) {
            case 1: {
                String string = this.getString(n);
                return string;
            }
            case 3: {
                Integer n3 = this.createInteger(this.getInt(n));
                return n3;
            }
            case 4: {
                Long l = this.createLong(this.getLong(n));
                return l;
            }
            case 6: {
                Double d = this.createDouble(this.getDouble(n));
                return d;
            }
            case 7: 
            case 13: {
                QName qName = this.getQName(n);
                return qName;
            }
            case 5: 
            case 8: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                String string = this.getNamespaceName(n);
                return string;
            }
            case 9: 
            case 14: {
                MultiName multiName = this.getMultiName(n);
                return multiName;
            }
            case 10: {
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            case 11: {
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            case 12: {
                Object object = NULL;
                return object;
            }
            case 15: 
            case 16: {
                Object object = this.getGeneralMultiname(n);
                return object;
            }
            case 17: {
                String string = "CONSTANT_RTQnameL";
                return string;
            }
            case 18: {
                String string = "CONSTANT_RTQnameLA";
                return string;
            }
            case 27: {
                String[] stringArray = this.getNamespaceSet(this.getInt(n));
                return stringArray;
            }
            case 28: {
                String[] stringArray = this.getNamespaceSet(this.getInt(n));
                return stringArray;
            }
            case 21: {
                String[] stringArray = this.getNamespaceSet(n);
                return stringArray;
            }
        }
        throw new DecoderException("Error: Unhandled constant type - " + n2);
    }

    private Integer createInteger(int n) {
        return IntegerPool.getNumber(n);
    }

    private Long createLong(long l) {
        return new Long(l);
    }

    private Double createDouble(double d) {
        return new Double(d);
    }

    private QName createQName(String string, String string2) {
        return new QName(string, string2);
    }

    private MultiName createMultiName(String string, String[] stringArray) {
        return new MultiName(string, stringArray);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.history.writeTo(this.in);
        this.in.writeTo(outputStream);
    }
}

