/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.security;

import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import flex.messaging.security.AppServerLoginCommand;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;

public class WebSphereLoginCommand
extends AppServerLoginCommand {
    public Principal doAuthentication(String username, Object credentials) {
        WSLCPrincipal principal = null;
        try {
            ContextManager contextManager;
            Subject subject;
            String password = this.extractPassword(credentials);
            if (password != null && (subject = (contextManager = ContextManagerFactory.getInstance()).login(contextManager.getDefaultRealm(), username, password)) != null) {
                contextManager.setCallerSubject(subject);
                principal = new WSLCPrincipal(username, contextManager, subject);
            }
        }
        catch (WSLoginFailedException wsLoginFailedException) {
        }
        catch (WSSecurityException wsSecurityException) {
            // empty catch block
        }
        return principal;
    }

    public boolean doAuthorization(Principal principal, List roles) {
        if (principal == null) {
            return false;
        }
        ContextManager contextManager = ((WSLCPrincipal)principal).getContextManager();
        UserRegistry registry = contextManager.getRegistry(contextManager.getDefaultRealm());
        try {
            ArrayList groups = new ArrayList(registry.getGroupsForUser(principal.getName()));
            groups.retainAll(roles);
            if (groups.size() > 0) {
                ContextManagerFactory.getInstance().setCallerSubject(((WSLCPrincipal)principal).getSubject());
            }
            return groups.size() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean logout(Principal principal) {
        return true;
    }

    private class WSLCPrincipal
    implements Principal {
        private String username;
        private ContextManager contextManager;
        private Subject subject;

        public WSLCPrincipal(String username, ContextManager contextManager, Subject subject) {
            this.username = username;
            this.contextManager = contextManager;
            this.subject = subject;
        }

        public String getName() {
            return this.username;
        }

        public ContextManager getContextManager() {
            return this.contextManager;
        }

        public Subject getSubject() {
            return this.subject;
        }
    }
}

