/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnderlineMetrics;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFFont;
import com.adobe.fontengine.font.cff.FontFactory;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;
import java.io.OutputStream;

public final class Cff
extends Table {
    protected final CFFFont cffFont;

    protected Cff(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        CFFFont[] cFFFontArray = FontFactory.load(fontByteArray);
        if (cFFFontArray == null || cFFFontArray.length != 1 || cFFFontArray[0] == null) {
            throw new InvalidFontException("CFFFontSet not appropriate for CFF table");
        }
        this.cffFont = cFFFontArray[0];
    }

    public CFFFont getCFFFont() {
        return this.cffFont;
    }

    String getGlyphName(int n) throws InvalidFontException, UnsupportedFontException {
        return this.cffFont.getGlyphName(n);
    }

    ROS getROS() {
        return this.cffFont.getROS();
    }

    int getGlyphCid(int n) throws InvalidFontException, UnsupportedFontException {
        return this.cffFont.getGlyphCid(n);
    }

    public Rect getGlyphBoundingBoxInMetricSpace(int n) throws UnsupportedFontException, InvalidFontException {
        return this.cffFont.getGlyphBBox(n);
    }

    public void getOutline(int n, OutlineConsumer outlineConsumer) throws UnsupportedFontException, InvalidFontException {
        this.cffFont.getGlyphOutline(n, outlineConsumer);
    }

    public Rect getFontBBox() throws UnsupportedFontException, InvalidFontException {
        return this.cffFont.getFontBBox();
    }

    Permission getEmbeddingPermission(boolean bl) throws UnsupportedFontException, InvalidFontException {
        return this.cffFont.getEmbeddingPermission(bl);
    }

    protected UnderlineMetrics getCoolTypeUnderlineMetrics(double d, double d2) throws UnsupportedFontException, InvalidFontException {
        return this.cffFont.getCoolTypeUnderlineMetrics(d, d2);
    }

    void subsetAndStream(Subset subset, OutputStream outputStream, boolean bl, Integer n) throws InvalidFontException, UnsupportedFontException, IOException {
        this.cffFont.subsetAndStream(subset, outputStream, bl, n);
    }
}

