/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.util.FileUtils;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcException;
import java.io.IOException;
import java.io.InputStream;

public class SwcFile
implements VirtualFile {
    private String path;
    private long lastModified;
    private SwcArchive archive;
    private VirtualFile virtualFile;
    private Swc swc;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SwcFile(String path, long lastModified, Swc swc, SwcArchive archive) {
        this.path = path;
        this.lastModified = lastModified;
        this.archive = archive;
        this.swc = swc;
    }

    private void createVirtualFile() {
        if (this.virtualFile == null) {
            this.virtualFile = this.archive.getFile(this.path);
            if (this.virtualFile == null) {
                throw new SwcException.MissingFile(this.path);
            }
            if (!$assertionsDisabled && !this.virtualFile.getName().equals(this.getName())) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && ((Object)this.virtualFile).hashCode() != this.hashCode()) {
                throw new AssertionError();
            }
        }
    }

    public String getName() {
        return this.swc.getLocation() + "$" + this.path;
    }

    public String getNameForReporting() {
        return this.getName();
    }

    public String getURL() {
        this.createVirtualFile();
        return this.virtualFile.getURL();
    }

    public String getParent() {
        this.createVirtualFile();
        return this.virtualFile.getParent();
    }

    public Swc getSwc() {
        return this.swc;
    }

    public boolean isDirectory() {
        return false;
    }

    public long size() {
        this.createVirtualFile();
        return this.virtualFile.size();
    }

    public String getMimeType() {
        this.createVirtualFile();
        return this.virtualFile.getMimeType();
    }

    public InputStream getInputStream() throws IOException {
        this.createVirtualFile();
        return this.virtualFile.getInputStream();
    }

    public byte[] toByteArray() throws IOException {
        throw new SwcException.UnsupportedOperation("toByteArray()", this.getClass().getName());
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public VirtualFile resolve(String relative) {
        String swcLocation;
        this.createVirtualFile();
        int sep = this.path.lastIndexOf("/");
        if (sep != -1) {
            relative = FileUtils.addPathComponents((String)this.path.substring(0, sep), (String)relative, (char)'/');
        }
        if ((swcLocation = SwcFile.getSwcLocation(relative)) != null && swcLocation.equals(this.swc.getLocation())) {
            String filePath;
            relative = filePath = SwcFile.getFilePath(relative);
        }
        return this.swc.getFile(relative);
    }

    public void close() {
        this.createVirtualFile();
        this.virtualFile.close();
    }

    public boolean equals(Object obj) {
        this.createVirtualFile();
        return ((Object)this.virtualFile).equals(obj);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isTextBased() {
        return false;
    }

    public static String getSwcLocation(String name) {
        int ind = name.indexOf(36);
        if (ind != -1) {
            return name.substring(0, ind);
        }
        return null;
    }

    public static String getFilePath(String name) {
        int ind = name.indexOf(36);
        if (ind != -1) {
            return name.substring(ind + 1);
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    static {
        $assertionsDisabled = !SwcFile.class.desiredAssertionStatus();
    }
}

