/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import macromedia.abc.BytecodeBuffer;
import macromedia.abc.Decoder;
import macromedia.abc.DecoderException;
import macromedia.abc.DefaultVisitor;
import macromedia.abc.MultiName;
import macromedia.abc.Opcodes;
import macromedia.abc.QName;
import macromedia.asc.util.Boxing;

public class Printer {
    private static Decoder decoder;
    private static String fileName;
    private static boolean showOpcodes;
    private static String className;
    private static String methodName;
    private static int startLine;
    private static int endLine;
    private static String currentClass;
    private static String currentMethod;
    private static int currentLine;

    public static void main(String[] stringArray) throws Throwable {
        if (stringArray.length == 0) {
            System.err.println("Usage: abcdump [-b] [-c mx.core:UIObject] [-m setColor] [-l 10-15] foo.abc");
            System.err.println();
            System.err.println("  -b:                     include opcodes in the output");
            System.err.println("  -c className:           restrict output to the specified class");
            System.err.println("  -m methodName:          restrict output to the specified method");
            System.err.println("  -l startLine[-endLine]: restrict output to the specified line(s)");
            return;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if ("-c".equals(stringArray[i])) {
                className = stringArray[i + 1].intern();
                ++i;
                continue;
            }
            if ("-m".equals(stringArray[i])) {
                methodName = stringArray[i + 1].intern();
                ++i;
                continue;
            }
            if ("-l".equals(stringArray[i])) {
                String string = stringArray[i + 1];
                int n2 = string.indexOf("-");
                if (n2 != -1) {
                    startLine = Integer.parseInt(string.substring(0, n2));
                    endLine = Integer.parseInt(string.substring(n2 + 1));
                } else {
                    startLine = Integer.parseInt(string);
                    endLine = startLine + 1;
                }
                ++i;
                continue;
            }
            if ("-b".equals(stringArray[i])) {
                showOpcodes = true;
                continue;
            }
            if (i != n - 1) continue;
            fileName = stringArray[i];
        }
        byte[] byArray = Printer.readBytes(new File(fileName));
        BytecodeBuffer bytecodeBuffer = new BytecodeBuffer(byArray);
        decoder = new Decoder(bytecodeBuffer);
        Printer.processScripts();
    }

    private static void processScripts() throws DecoderException {
        Decoder.ScriptInfo scriptInfo = Printer.decoder.scriptInfo;
        ABCVisitor aBCVisitor = new ABCVisitor(decoder);
        int n = scriptInfo.size();
        for (int i = 0; i < n; ++i) {
            scriptInfo.decode(i, aBCVisitor);
        }
    }

    private static void print(String string) {
        if (currentClass == className && currentMethod == methodName) {
            System.out.print(string);
        }
    }

    private static void println(String string) {
        if (currentClass == className && currentMethod == methodName) {
            System.out.println(string);
        }
    }

    private static void printOpcode(String string) {
        if (currentClass == className && currentMethod == methodName && (startLine == 0 && endLine == 0 || currentLine >= startLine && currentLine < endLine) && showOpcodes) {
            System.out.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readBytes(File file) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static class ABCVisitor
    extends DefaultVisitor {
        ABCVisitor(Decoder decoder) {
            super(decoder);
        }

        public void methodInfo(QName qName, QName[] qNameArray, String string, int n, Object[] objectArray, String[] stringArray) {
            int n2;
            int n3;
            Printer.print("<info name='" + string + "' paramTypes='");
            int n4 = n3 = qNameArray != null ? qNameArray.length : 0;
            for (n2 = 0; n2 < n3; ++n2) {
                Printer.print(qNameArray[n2] + " ");
            }
            Printer.print("'");
            if (qName != null) {
                Printer.print(" returnType='" + qName + "'");
            }
            Printer.print(" paramNames='");
            int n5 = n3 = stringArray != null ? stringArray.length : 0;
            for (n2 = 0; n2 < n3; ++n2) {
                Printer.print(stringArray[n2] + " ");
            }
            Printer.print("'");
            Printer.println("/>");
        }

        public void metadata(String string, String[] stringArray, String[] stringArray2) {
            Printer.println("<metadata/>");
        }

        public void beginVar(QName qName, int n, QName qName2, Object object) {
            Printer.print("<var name='" + qName + "'");
            if (qName2 != null) {
                Printer.print(" type='" + qName2 + "'");
            }
            Printer.println(">");
            if (object != null) {
                Printer.println("<value>" + object + "</value>");
            }
        }

        public void endVar(QName qName) {
            Printer.println("</var>");
        }

        public void beginConst(QName qName, int n, QName qName2, Object object) {
            Printer.print("<const name='" + qName + "'");
            if (qName2 != null) {
                Printer.print(" type='" + qName2 + "'");
            }
            Printer.println(">");
            if (object != null) {
                Printer.println("<value>" + object + "</value>");
            }
        }

        public void endConst(QName qName) {
            Printer.println("</const>");
        }

        public void beginGetter(int n, QName qName, int n2, int n3) {
            if (methodName != null) {
                currentMethod = qName.toString().intern();
            }
            Printer.println("<getter name='" + qName + "' dispID='" + n2 + "' attr='" + n3 + "'>");
        }

        public void endGetter(QName qName) {
            Printer.println("</getter>");
            if (methodName != null) {
                currentMethod = null;
            }
        }

        public void beginSetter(int n, QName qName, int n2, int n3) {
            if (methodName != null) {
                currentMethod = qName.toString().intern();
            }
            Printer.println("<setter name='" + qName + "' dispID='" + n2 + "' attr='" + n3 + "'>");
        }

        public void endSetter(QName qName) {
            Printer.println("</setter>");
            if (methodName != null) {
                currentMethod = null;
            }
        }

        public void beginMethod(int n, QName qName, int n2, int n3) {
            if (methodName != null) {
                currentMethod = qName.toString().intern();
            }
            Printer.println("<method name='" + qName + "' dispID='" + n2 + "' attr='" + n3 + "'>");
        }

        public void endMethod(QName qName) {
            Printer.println("</method>");
            if (methodName != null) {
                currentMethod = null;
            }
        }

        public void beginClass(QName qName, int n) {
            if (className != null) {
                currentClass = qName.toString().intern();
            }
            Printer.println("<class name='" + qName + "' slot='" + n + "'>");
        }

        public void endClass(QName qName) {
            Printer.println("</class>");
            if (className != null) {
                currentClass = null;
            }
        }

        public void beginIInit(int n) {
            Printer.println("<iinit>");
        }

        public void endIInit() {
            Printer.println("</iinit>");
        }

        public void beginCInit(int n) {
            Printer.println("<cinit>");
        }

        public void endCInit() {
            Printer.println("</cinit>");
        }

        public void beginFunction(int n, QName qName, int n2) {
            Printer.println("<function name='" + qName + "'>");
        }

        public void endFunction(QName qName) {
            Printer.println("</function>");
        }

        public void instanceInfo(QName qName, QName qName2, MultiName[] multiNameArray) {
            Printer.print("<info type='" + qName + "'");
            if (qName2 != null) {
                Printer.print(" superType='" + qName2 + "'");
            }
            Printer.println("/>");
        }

        public void classInfo(QName qName) {
        }

        public void beginABC() {
            Printer.println("<abc>");
        }

        public void endABC() {
            Printer.println("</abc>");
        }

        public void beginBody(int n, int n2, long l) {
            Printer.println("<![CDATA[");
        }

        public void endBody() {
            Printer.println("]]>");
        }

        private Object getConstantStringValue(int n) {
            try {
                return this.decoder.constantPool.getString(n);
            }
            catch (DecoderException decoderException) {
                return "decoder exception...";
            }
        }

        private Object getConstantNamespaceValue(int n) {
            try {
                return this.decoder.constantPool.getNamespaceName(n);
            }
            catch (DecoderException decoderException) {
                return "decoder exception...";
            }
        }

        private Object getConstantIntValue(int n) {
            try {
                return Boxing.valueOf(this.decoder.constantPool.getInt(n));
            }
            catch (DecoderException decoderException) {
                return "decoder exception...";
            }
        }

        private Object getConstantUIntValue(int n) {
            try {
                return this.decoder.constantPool.getLong(n);
            }
            catch (DecoderException decoderException) {
                return "decoder exception...";
            }
        }

        private Object getConstantMultinameValue(int n) {
            try {
                return this.decoder.constantPool.getGeneralMultiname(n);
            }
            catch (DecoderException decoderException) {
                return "decoder exception...";
            }
        }

        public void target(int n) {
            System.out.println("target " + n);
        }

        public void OP_returnvoid() {
            Printer.printOpcode(Opcodes.opNames[71]);
        }

        public void OP_returnvalue() {
            Printer.printOpcode(Opcodes.opNames[72]);
        }

        public void OP_nop() {
            Printer.printOpcode(Opcodes.opNames[2]);
        }

        public void OP_bkpt() {
            Printer.printOpcode(Opcodes.opNames[1]);
        }

        public void OP_timestamp() {
            Printer.printOpcode(Opcodes.opNames[243]);
        }

        public void OP_debugline(int n) {
            if (startLine != 0 && endLine != 0) {
                currentLine = n;
            }
            Printer.printOpcode(System.getProperty("line.separator") + Opcodes.opNames[240] + " linenum=" + n);
        }

        public void OP_bkptline() {
            Printer.printOpcode(Opcodes.opNames[242]);
        }

        public void OP_debug(int n, int n2, int n3, int n4) {
            Printer.printOpcode(Opcodes.opNames[239] + " di_local=" + n + " index=" + n2 + " slot=" + n3 + " linenum=" + n4);
        }

        public void OP_debugfile(int n) {
            Printer.printOpcode(Opcodes.opNames[241] + " cpool[" + n + "]" + " = " + this.getConstantStringValue(n));
        }

        public void OP_jump(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[16] + " " + n);
        }

        public void OP_pushnull() {
            Printer.printOpcode(Opcodes.opNames[32]);
        }

        public void OP_pushundefined() {
            Printer.printOpcode(Opcodes.opNames[33]);
        }

        public void OP_pushstring(int n) {
            Printer.printOpcode(Opcodes.opNames[44] + " cpool_string[" + n + "]" + " = " + this.getConstantStringValue(n));
        }

        public void OP_pushnamespace(int n) {
            Printer.printOpcode(Opcodes.opNames[49] + " cpool_namespace[" + n + "]" + " = " + this.getConstantNamespaceValue(n));
        }

        public void OP_pushint(int n) {
            Printer.printOpcode(Opcodes.opNames[45] + " cpool_int[" + n + "]" + " = " + this.getConstantIntValue(n));
        }

        public void OP_pushuint(int n) {
            Printer.printOpcode(Opcodes.opNames[46] + " cpool_uint[" + n + "]" + " = " + this.getConstantUIntValue(n));
        }

        public void OP_pushdouble(int n) {
            Printer.printOpcode(Opcodes.opNames[47] + " cpool_double[" + n + "]");
        }

        public void OP_getlocal(int n) {
            Printer.printOpcode(Opcodes.opNames[98] + " r" + n);
        }

        public void OP_pushtrue() {
            Printer.printOpcode(Opcodes.opNames[38]);
        }

        public void OP_pushfalse() {
            Printer.printOpcode(Opcodes.opNames[39]);
        }

        public void OP_pushnan() {
            Printer.printOpcode(Opcodes.opNames[40]);
        }

        public void OP_pop() {
            Printer.printOpcode(Opcodes.opNames[41]);
        }

        public void OP_dup() {
            Printer.printOpcode(Opcodes.opNames[42]);
        }

        public void OP_swap() {
            Printer.printOpcode(Opcodes.opNames[43]);
        }

        public void OP_convert_s() {
            Printer.printOpcode(Opcodes.opNames[112]);
        }

        public void OP_esc_xelem() {
            Printer.printOpcode(Opcodes.opNames[113]);
        }

        public void OP_esc_xattr() {
            Printer.printOpcode(Opcodes.opNames[114]);
        }

        public void OP_checkfilter() {
            Printer.printOpcode(Opcodes.opNames[120]);
        }

        public void OP_convert_d() {
            Printer.printOpcode(Opcodes.opNames[117]);
        }

        public void OP_convert_b() {
            Printer.printOpcode(Opcodes.opNames[118]);
        }

        public void OP_convert_o() {
            Printer.printOpcode(Opcodes.opNames[119]);
        }

        public void OP_negate() {
            Printer.printOpcode(Opcodes.opNames[144]);
        }

        public void OP_negate_i() {
            Printer.printOpcode(Opcodes.opNames[196]);
        }

        public void OP_increment() {
            Printer.printOpcode(Opcodes.opNames[145]);
        }

        public void OP_increment_i() {
            Printer.printOpcode(Opcodes.opNames[192]);
        }

        public void OP_inclocal(int n) {
            Printer.printOpcode(Opcodes.opNames[146] + " r" + n);
        }

        public void OP_kill(int n) {
            Printer.printOpcode(Opcodes.opNames[8] + " r" + n);
        }

        public void OP_inclocal_i(int n) {
            Printer.printOpcode(Opcodes.opNames[194] + " r" + n);
        }

        public void OP_decrement() {
            Printer.printOpcode(Opcodes.opNames[147]);
        }

        public void OP_decrement_i() {
            Printer.printOpcode(Opcodes.opNames[193]);
        }

        public void OP_declocal(int n) {
            Printer.printOpcode(Opcodes.opNames[148] + " r" + n);
        }

        public void OP_declocal_i(int n) {
            Printer.printOpcode(Opcodes.opNames[195] + " r" + n);
        }

        public void OP_typeof() {
            Printer.printOpcode(Opcodes.opNames[149]);
        }

        public void OP_not() {
            Printer.printOpcode(Opcodes.opNames[150]);
        }

        public void OP_bitnot() {
            Printer.printOpcode(Opcodes.opNames[151]);
        }

        public void OP_setlocal(int n) {
            Printer.printOpcode(Opcodes.opNames[99] + " r" + n);
        }

        public void OP_add() {
            Printer.printOpcode(Opcodes.opNames[160]);
        }

        public void OP_add_i() {
            Printer.printOpcode(Opcodes.opNames[197]);
        }

        public void OP_subtract() {
            Printer.printOpcode(Opcodes.opNames[161]);
        }

        public void OP_subtract_i() {
            Printer.printOpcode(Opcodes.opNames[198]);
        }

        public void OP_multiply() {
            Printer.printOpcode(Opcodes.opNames[162]);
        }

        public void OP_multiply_i() {
            Printer.printOpcode(Opcodes.opNames[199]);
        }

        public void OP_divide() {
            Printer.printOpcode(Opcodes.opNames[163]);
        }

        public void OP_modulo() {
            Printer.printOpcode(Opcodes.opNames[164]);
        }

        public void OP_lshift() {
            Printer.printOpcode(Opcodes.opNames[165]);
        }

        public void OP_rshift() {
            Printer.printOpcode(Opcodes.opNames[166]);
        }

        public void OP_urshift() {
            Printer.printOpcode(Opcodes.opNames[167]);
        }

        public void OP_bitand() {
            Printer.printOpcode(Opcodes.opNames[168]);
        }

        public void OP_bitor() {
            Printer.printOpcode(Opcodes.opNames[169]);
        }

        public void OP_bitxor() {
            Printer.printOpcode(Opcodes.opNames[170]);
        }

        public void OP_equals() {
            Printer.printOpcode(Opcodes.opNames[171]);
        }

        public void OP_strictequals() {
            Printer.printOpcode(Opcodes.opNames[172]);
        }

        public void OP_lookupswitch(int n, int[] nArray, int n2, int n3) {
            String string = "";
            int n4 = nArray.length;
            for (int i = 0; i < n4; ++i) {
                string = string + nArray[i] + ",";
            }
            Printer.printOpcode(Opcodes.opNames[27] + " defaultPos=" + n + " casePos=" + string);
        }

        public void OP_iftrue(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[17] + " " + n);
        }

        public void OP_iffalse(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[18] + " " + n);
        }

        public void OP_ifeq(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[19] + " " + n);
        }

        public void OP_ifne(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[20] + " " + n);
        }

        public void OP_ifstricteq(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[25] + " " + n);
        }

        public void OP_ifstrictne(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[26] + " " + n);
        }

        public void OP_iflt(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[21] + " " + n);
        }

        public void OP_ifle(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[22] + " " + n);
        }

        public void OP_ifgt(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[23] + " " + n);
        }

        public void OP_ifge(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[24] + " " + n);
        }

        public void OP_lessthan() {
            Printer.printOpcode(Opcodes.opNames[173]);
        }

        public void OP_lessequals() {
            Printer.printOpcode(Opcodes.opNames[174]);
        }

        public void OP_greaterthan() {
            Printer.printOpcode(Opcodes.opNames[175]);
        }

        public void OP_greaterequals() {
            Printer.printOpcode(Opcodes.opNames[176]);
        }

        public void OP_newobject(int n) {
            Printer.printOpcode(Opcodes.opNames[85] + " size=" + n);
        }

        public void OP_newarray(int n) {
            Printer.printOpcode(Opcodes.opNames[86] + " size=" + n);
        }

        public void OP_getproperty(int n) {
            Printer.printOpcode(Opcodes.opNames[102] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n));
        }

        public void OP_setproperty(int n) {
            Printer.printOpcode(Opcodes.opNames[97] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n));
        }

        public void OP_initproperty(int n) {
            Printer.printOpcode(Opcodes.opNames[104] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n));
        }

        public void OP_getdescendants(int n) {
            Printer.printOpcode(Opcodes.opNames[89] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n));
        }

        public void OP_findpropstrict(int n) {
            Printer.printOpcode(Opcodes.opNames[93] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n));
        }

        public void OP_findproperty(int n) {
            Printer.printOpcode(Opcodes.opNames[94] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n));
        }

        public void OP_finddef(int n) {
            Printer.printOpcode(Opcodes.opNames[95] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n));
        }

        public void OP_getlex(int n) {
            Printer.printOpcode(Opcodes.opNames[96] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n));
        }

        public void OP_nextname() {
            Printer.printOpcode(Opcodes.opNames[30]);
        }

        public void OP_nextvalue() {
            Printer.printOpcode(Opcodes.opNames[35]);
        }

        public void OP_hasnext() {
            Printer.printOpcode(Opcodes.opNames[31]);
        }

        public void OP_hasnext2(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[50] + " " + n + " " + n2);
        }

        public void OP_deleteproperty(int n) {
            Printer.printOpcode(Opcodes.opNames[106] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n));
        }

        public void OP_setslot(int n) {
            Printer.printOpcode(Opcodes.opNames[109] + " " + n);
        }

        public void OP_getslot(int n) {
            Printer.printOpcode(Opcodes.opNames[108] + " " + n);
        }

        public void OP_setglobalslot(int n) {
            Printer.printOpcode(Opcodes.opNames[111] + " " + n);
        }

        public void OP_getglobalslot(int n) {
            Printer.printOpcode(Opcodes.opNames[110] + " " + n);
        }

        public void OP_call(int n) {
            Printer.printOpcode(Opcodes.opNames[65] + " size=" + n);
        }

        public void OP_construct(int n) {
            Printer.printOpcode(Opcodes.opNames[66] + " size=" + n);
        }

        public void OP_newfunction(int n) {
            Printer.printOpcode(Opcodes.opNames[64] + " function=" + n);
        }

        public void OP_newclass(int n) {
            Printer.printOpcode(Opcodes.opNames[88] + " class=" + n);
        }

        public void OP_callstatic(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[68] + " method=" + n + " argc=" + n2);
        }

        public void OP_callmethod(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[67] + " dispid=" + n + " argc=" + n2);
        }

        public void OP_callproperty(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[70] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n) + " argc=" + n2);
        }

        public void OP_callproplex(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[76] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n) + " argc=" + n2);
        }

        public void OP_constructprop(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[74] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n) + " argc=" + n2);
        }

        public void OP_callsuper(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[69] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n) + " argc=" + n2);
        }

        public void OP_getsuper(int n) {
            Printer.printOpcode(Opcodes.opNames[4] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n));
        }

        public void OP_setsuper(int n) {
            Printer.printOpcode(Opcodes.opNames[5] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n));
        }

        public void OP_constructsuper(int n) {
            Printer.printOpcode(Opcodes.opNames[73] + " argc=" + n);
        }

        public void OP_pushshort(int n) {
            Printer.printOpcode(Opcodes.opNames[37] + " " + n);
        }

        public void OP_astype(int n) {
            Printer.printOpcode(Opcodes.opNames[134] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n));
        }

        public void OP_astypelate() {
            Printer.printOpcode(Opcodes.opNames[135]);
        }

        public void OP_coerce(int n) {
            Printer.printOpcode(Opcodes.opNames[128] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n));
        }

        public void OP_coerce_b() {
            Printer.printOpcode(Opcodes.opNames[129]);
        }

        public void OP_coerce_o() {
            Printer.printOpcode(Opcodes.opNames[137]);
        }

        public void OP_coerce_a() {
            Printer.printOpcode(Opcodes.opNames[130]);
        }

        public void OP_coerce_i() {
            Printer.printOpcode(Opcodes.opNames[131]);
        }

        public void OP_coerce_u() {
            Printer.printOpcode(Opcodes.opNames[136]);
        }

        public void OP_coerce_d() {
            Printer.printOpcode(Opcodes.opNames[132]);
        }

        public void OP_coerce_s() {
            Printer.printOpcode(Opcodes.opNames[133]);
        }

        public void OP_istype(int n) {
            Printer.printOpcode(Opcodes.opNames[178] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n));
        }

        public void OP_istypelate() {
            Printer.printOpcode(Opcodes.opNames[179]);
        }

        public void OP_pushbyte(int n) {
            Printer.printOpcode(Opcodes.opNames[36] + " " + n);
        }

        public void OP_getscopeobject(int n) {
            Printer.printOpcode(Opcodes.opNames[101] + " index=" + n);
        }

        public void OP_pushscope() {
            Printer.printOpcode(Opcodes.opNames[48]);
        }

        public void OP_popscope() {
            Printer.printOpcode(Opcodes.opNames[29]);
        }

        public void OP_convert_i() {
            Printer.printOpcode(Opcodes.opNames[115]);
        }

        public void OP_convert_u() {
            Printer.printOpcode(Opcodes.opNames[116]);
        }

        public void OP_throw() {
            Printer.printOpcode(Opcodes.opNames[3]);
        }

        public void OP_instanceof() {
            Printer.printOpcode(Opcodes.opNames[177]);
        }

        public void OP_in() {
            Printer.printOpcode(Opcodes.opNames[180]);
        }

        public void OP_dxns(int n) {
            Printer.printOpcode(Opcodes.opNames[6] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n));
        }

        public void OP_dxnslate() {
            Printer.printOpcode(Opcodes.opNames[7]);
        }

        public void OP_ifnlt(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[12] + " " + n);
        }

        public void OP_ifnle(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[13] + " " + n);
        }

        public void OP_ifngt(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[14] + " " + n);
        }

        public void OP_ifnge(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[15] + " " + n);
        }

        public void OP_pushwith() {
            Printer.printOpcode(Opcodes.opNames[28]);
        }

        public void OP_newactivation() {
            Printer.printOpcode(Opcodes.opNames[87]);
        }

        public void OP_newcatch(int n) {
            Printer.printOpcode(Opcodes.opNames[90] + " " + n);
        }

        public void OP_deldescendants() {
            Printer.printOpcode(Opcodes.opNames[91]);
        }

        public void OP_getglobalscope() {
            Printer.printOpcode(Opcodes.opNames[100]);
        }

        public void OP_getlocal0() {
            Printer.printOpcode(Opcodes.opNames[208]);
        }

        public void OP_getlocal1() {
            Printer.printOpcode(Opcodes.opNames[209]);
        }

        public void OP_getlocal2() {
            Printer.printOpcode(Opcodes.opNames[210]);
        }

        public void OP_getlocal3() {
            Printer.printOpcode(Opcodes.opNames[211]);
        }

        public void OP_setlocal0() {
            Printer.printOpcode(Opcodes.opNames[212]);
        }

        public void OP_setlocal1() {
            Printer.printOpcode(Opcodes.opNames[213]);
        }

        public void OP_setlocal2() {
            Printer.printOpcode(Opcodes.opNames[214]);
        }

        public void OP_setlocal3() {
            Printer.printOpcode(Opcodes.opNames[215]);
        }

        public void OP_label() {
            Printer.printOpcode(Opcodes.opNames[9]);
        }

        public void OP_pushconstant(int n) {
            Printer.printOpcode(Opcodes.opNames[34] + " " + n);
        }

        public void OP_callsupervoid(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[78] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n) + " argc=" + n2);
        }

        public void OP_callpropvoid(int n, int n2) {
            Printer.printOpcode(Opcodes.opNames[79] + " cpool[" + n + "]" + " = " + this.getConstantMultinameValue(n) + " argc=" + n2);
        }
    }
}

