/*
 * Decompiled with CFR 0.152.
 */
package flex.bootstrap;

import flex.bootstrap.BootstrapClassLoader;
import flex.webtier.server.j2ee.wrappers.J2EEWrapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class BootstrapServlet
implements Servlet {
    private Servlet servlet;
    private ServletConfig config;
    private static final HashMap classNameMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig c) throws ServletException {
        this.config = J2EEWrapper.getServletConfig(c);
        String servletClass = this.config.getInitParameter("servlet.class");
        String supportLegacy = this.config.getInitParameter("supportLegacyClassNames");
        if (servletClass != null && BootstrapServlet.supportLegacyClassNames(supportLegacy)) {
            servletClass = servletClass.trim();
            Iterator it = classNameMap.keySet().iterator();
            while (it.hasNext()) {
                String oldClass = (String)it.next();
                String newClass = (String)classNameMap.get(oldClass);
                if (!servletClass.equals(oldClass)) continue;
                servletClass = newClass;
            }
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader bootstrap = BootstrapClassLoader.getClassLoader(this.config.getServletContext());
                BootstrapClassLoader.incrementReferences();
                Thread.currentThread().setContextClassLoader(bootstrap);
                this.servlet = (Servlet)bootstrap.loadClass(servletClass).newInstance();
                this.servlet.init(this.getServletConfig());
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        req = J2EEWrapper.getRequest(req);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader bootstrap = BootstrapClassLoader.getClassLoader(this.config.getServletContext());
            Thread.currentThread().setContextClassLoader(bootstrap);
            this.servlet.service(req, resp);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader bootstrap = BootstrapClassLoader.getClassLoader(this.config.getServletContext());
            Thread.currentThread().setContextClassLoader(bootstrap);
            this.servlet.destroy();
            if (bootstrap instanceof BootstrapClassLoader) {
                ((BootstrapClassLoader)bootstrap).clear();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "Bootstrap servlet " + (this.config == null ? "" : " for " + this.config.getServletName());
    }

    private static boolean supportLegacyClassNames(String token) {
        boolean support = true;
        if (token != null && !Boolean.getBoolean(token)) {
            support = false;
        }
        return support;
    }

    static {
        classNameMap.put("flex2.server.j2ee.MxmlServlet", "flex.webtier.server.j2ee.MxmlServlet");
        classNameMap.put("flex2.server.j2ee.SwfServlet", "flex.webtier.server.j2ee.SwfServlet");
        classNameMap.put("flex.server.j2ee.ForbiddenServlet", "flex.webtier.server.j2ee.ForbiddenServlet");
        classNameMap.put("flex.server.j2ee.filemanager.FileManagerServlet", "flex.webtier.server.j2ee.filemanager.FileManagerServlet");
    }
}

