/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.Point;
import com.adobe.fontengine.font.Rect;

public final class GlyphBBoxOutlineConsumer
implements OutlineConsumer {
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private double cpx;
    private double cpy;
    private Matrix matrix;
    private final Matrix targetMatrix;

    public GlyphBBoxOutlineConsumer(Matrix matrix) {
        this.targetMatrix = matrix;
        this.matrix = null;
    }

    public void reset() {
        this.ymin = Double.POSITIVE_INFINITY;
        this.xmin = Double.POSITIVE_INFINITY;
        this.ymax = Double.NEGATIVE_INFINITY;
        this.xmax = Double.NEGATIVE_INFINITY;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix.isInverse(this.targetMatrix) ? Matrix.IDENTITY_MATRIX : matrix.multiply(this.targetMatrix);
    }

    public void moveto(double d, double d2) {
        Point point = new Point(d, d2);
        this.matrix.applyToPoint(point);
        this.cpx = point.x;
        this.cpy = point.y;
    }

    public void lineto(double d, double d2) {
        this.setXMinMax(this.cpx);
        this.setYMinMax(this.cpy);
        Point point = new Point(d, d2);
        this.matrix.applyToPoint(point);
        this.cpx = point.x;
        this.cpy = point.y;
        this.setXMinMax(this.cpx);
        this.setYMinMax(this.cpy);
    }

    private void setXMinMax(double d) {
        if (d < this.xmin) {
            this.xmin = d;
        }
        if (d > this.xmax) {
            this.xmax = d;
        }
    }

    private void setYMinMax(double d) {
        if (d < this.ymin) {
            this.ymin = d;
        }
        if (d > this.ymax) {
            this.ymax = d;
        }
    }

    private void checkCurveMinMax(double d, double d2, double d3, double d4, double d5, boolean bl) {
        if (d <= 0.0 || d > 1.0) {
            return;
        }
        double d6 = d * (d * (d * d2 + 3.0 * d3) + 3.0 * d4) + d5;
        if (bl) {
            this.setXMinMax(d6);
        } else {
            this.setYMinMax(d6);
        }
    }

    private void setCurveMinMax(double d, double d2, double d3, double d4, boolean bl) {
        double d5 = d4 - 3.0 * (d3 - d2) - d;
        double d6 = d3 - 2.0 * d2 + d;
        double d7 = d2 - d;
        if (d5 == 0.0) {
            if (d6 != 0.0) {
                this.checkCurveMinMax(-d7 / (2.0 * d6), d5, d6, d7, d, bl);
            }
            return;
        }
        double d8 = d6 * d6 - d5 * d7;
        if (d8 < 0.0) {
            return;
        }
        d8 = Math.sqrt(d8);
        this.checkCurveMinMax((-d6 + d8) / d5, d5, d6, d7, d, bl);
        this.checkCurveMinMax((-d6 - d8) / d5, d5, d6, d7, d, bl);
    }

    public void curveto(double d, double d2, double d3, double d4) {
        this.curveto(Math.round((this.cpx + 2.0 * d) / 3.0), Math.round((this.cpy + 2.0 * d2) / 3.0), Math.round((2.0 * d + d3) / 3.0), Math.round((2.0 * d2 + d4) / 3.0), d3, d4);
    }

    public void curveto(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = this.cpx;
        double d8 = this.cpy;
        Point point = new Point(d5, d6);
        this.matrix.applyToPoint(point);
        d5 = point.x;
        d6 = point.y;
        point = new Point(d, d2);
        this.matrix.applyToPoint(point);
        d = point.x;
        d2 = point.y;
        point = new Point(d3, d4);
        this.matrix.applyToPoint(point);
        d3 = point.x;
        d4 = point.y;
        double d9 = Math.min(this.cpx, d5);
        double d10 = Math.max(this.cpx, d5);
        double d11 = Math.min(this.cpy, d6);
        double d12 = Math.max(this.cpy, d6);
        double d13 = Math.min(d, d3);
        double d14 = Math.max(d, d3);
        double d15 = Math.min(d2, d4);
        double d16 = Math.max(d2, d4);
        this.cpx = d5;
        this.cpy = d6;
        if (d9 >= this.xmin && d13 >= this.xmin && d11 >= this.ymin && d15 >= this.ymin && d10 <= this.xmax && d14 <= this.xmax && d12 <= this.ymax && d16 <= this.ymax) {
            return;
        }
        if (d13 < d9 || d14 > d10) {
            this.setCurveMinMax(d7, d, d3, d5, true);
        }
        this.setXMinMax(d9);
        this.setXMinMax(d10);
        if (d15 < d11 || d16 > d12) {
            this.setCurveMinMax(d8, d2, d4, d6, false);
        }
        this.setYMinMax(d11);
        this.setYMinMax(d12);
    }

    public Rect getBBox() {
        if (this.xmin > this.xmax) {
            this.xmin = 0.0;
            this.xmax = 0.0;
        }
        if (this.ymin > this.ymax) {
            this.ymax = 0.0;
            this.ymin = 0.0;
        }
        return new Rect(this.xmin, this.ymin, this.xmax, this.ymax);
    }

    public void endchar() {
    }
}

