/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.HintedOutlineConsumer;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.postscript.SeacPhase;
import com.adobe.fontengine.font.postscript.StandardEncoding;
import com.adobe.fontengine.font.type1.Type1Font;

public final class Type1CStringParser {
    private static final int CMD_RESERVED0 = 0;
    private static final int CMD_HSTEM = 1;
    private static final int CMD_RESERVED2 = 2;
    private static final int CMD_VSTEM = 3;
    private static final int CMD_VMOVETO = 4;
    private static final int CMD_RLINETO = 5;
    private static final int CMD_HLINETO = 6;
    private static final int CMD_VLINETO = 7;
    private static final int CMD_RRCURVETO = 8;
    private static final int CMD_CLOSEPATH = 9;
    private static final int CMD_CALLSUBR = 10;
    private static final int CMD_RETURN = 11;
    private static final int CMD_ESC = 12;
    private static final int CMD_HSBW = 13;
    private static final int CMD_ENDCHAR = 14;
    private static final int CMD_MOVETO = 15;
    private static final int CMD_BLEND = 16;
    private static final int CMD_RESERVED17 = 17;
    private static final int CMD_RESERVED18 = 18;
    private static final int CMD_RESERVED19 = 19;
    private static final int CMD_RESERVED20 = 20;
    private static final int CMD_RMOVETO = 21;
    private static final int CMD_HMOVETO = 22;
    private static final int CMD_RESERVED23 = 23;
    private static final int CMD_RESERVED24 = 24;
    private static final int CMD_RESERVED25 = 25;
    private static final int CMD_RESERVED26 = 26;
    private static final int CMD_RESERVED27 = 27;
    private static final int CMD_RESERVED28 = 28;
    private static final int CMD_RESERVED29 = 29;
    private static final int CMD_VHCURVETO = 30;
    private static final int CMD_HVCURVETO = 31;
    private static final int ESC_DOTSECTION = 0;
    private static final int ESC_VSTEM3 = 1;
    private static final int ESC_HSTEM3 = 2;
    private static final int ESC_AND = 3;
    private static final int ESC_OR = 4;
    private static final int ESC_NOT = 5;
    private static final int ESC_SEAC = 6;
    private static final int ESC_SBW = 7;
    private static final int ESC_STORE = 8;
    private static final int ESC_ABS = 9;
    private static final int ESC_ADD = 10;
    private static final int ESC_SUB = 11;
    private static final int ESC_DIV = 12;
    private static final int ESC_LOAD = 13;
    private static final int ESC_NEG = 14;
    private static final int ESC_EQ = 15;
    private static final int ESC_CALLOTHER = 16;
    private static final int ESC_POP = 17;
    private static final int ESC_DROP = 18;
    private static final int ESC_RESERVED19 = 19;
    private static final int ESC_PUT = 20;
    private static final int ESC_GET = 21;
    private static final int ESC_IFELSE = 22;
    private static final int ESC_RANDOM = 23;
    private static final int ESC_MUL = 24;
    private static final int ESC_DIV2 = 25;
    private static final int ESC_SQRT = 26;
    private static final int ESC_DUP = 27;
    private static final int ESC_EXCH = 28;
    private static final int ESC_INDEX = 29;
    private static final int ESC_ROLL = 30;
    private static final int ESC_RESERVED31 = 31;
    private static final int ESC_RESERVED32 = 32;
    private static final int ESC_SETCURRENTPOINT = 33;
    private static final int OTHER_FLEX = 0;
    private static final int OTHER_PREFLEX1 = 1;
    private static final int OTHER_PREFLEX2 = 2;
    private static final int OTHER_HINTSUBS = 3;
    private static final int OTHER_RESERVED4 = 4;
    private static final int OTHER_GLOBALCOLORME = 6;
    private static final int OTHER_RESERVED7 = 7;
    private static final int OTHER_RESERVED8 = 8;
    private static final int OTHER_RESERVED9 = 9;
    private static final int OTHER_RESERVED10 = 10;
    private static final int OTHER_RESERVED11 = 11;
    private static final int OTHER_GLBCLR1 = 12;
    private static final int OTHER_GLBCLR2 = 13;
    private static final int OTHER_BLEND1 = 14;
    private static final int OTHER_BLEND2 = 15;
    private static final int OTHER_BLEND3 = 16;
    private static final int OTHER_BLEND4 = 17;
    private static final int OTHER_BLEND6 = 18;
    private static final int OTHER_STOREWV = 19;
    private static final int OTHER_ADD = 20;
    private static final int OTHER_SUB = 21;
    private static final int OTHER_MUL = 22;
    private static final int OTHER_DIV = 23;
    private static final int OTHER_PUT = 24;
    private static final int OTHER_GET = 25;
    private static final int OTHER_PSPUT = 26;
    private static final int OTHER_IFELSE = 27;
    private static final int OTHER_RANDOM = 28;
    private static final int OTHER_DUP = 29;
    private static final int OTHER_EXCH = 30;
    private static final int MAX_STACK_SIZE = 24;
    private static final int MAX_STORAGE_SIZE = 32;
    private static final int MAX_FLEX = 17;
    private SeacPhase seacPhase;
    private double seac_adx;
    private double seac_ady;
    private double currentX;
    private double currentY;
    private double lsb_x;
    private double lsb_y;
    private int stackCount;
    private double[] stack = new double[24];
    private double[] storage = new double[32];
    private int flexCount;
    private double[] flexArgs = new double[17];
    private int counterCount;
    private double[] counters = new double[194];
    private boolean inFlex;
    private boolean pendingMove;
    private boolean endcharSeen;
    private boolean pendingHintSub;
    private boolean seenHintSub;
    private boolean movetoSeen;

    private void push(double d) {
        this.stack[this.stackCount++] = d;
    }

    private double pop() {
        return this.stack[--this.stackCount];
    }

    private double index(int n) {
        return this.stack[n];
    }

    private void clearStack() {
        this.stackCount = 0;
    }

    private void pushFlex(double d) {
        this.flexArgs[this.flexCount++] = d;
    }

    private void checkFlex(int n) throws InvalidGlyphException {
        if (this.flexCount + n > 17) {
            throw new InvalidGlyphException("too many flex args");
        }
    }

    private void checkUnderflow(int n) throws InvalidGlyphException {
        if (this.stackCount < n) {
            throw new InvalidGlyphException("Stack underflow in charstring");
        }
    }

    private void checkOverflow(int n) throws InvalidGlyphException {
        if (this.stackCount + n > 24) {
            throw new InvalidGlyphException("Stack overflow in charstring");
        }
    }

    private void doAnd() throws InvalidGlyphException {
        this.checkUnderflow(2);
        double d = this.pop();
        double d2 = this.pop();
        if (d != 0.0 && d2 != 0.0) {
            this.push(1.0);
        } else {
            this.push(0.0);
        }
    }

    private void doOr() throws InvalidGlyphException {
        this.checkUnderflow(2);
        double d = this.pop();
        double d2 = this.pop();
        if (d != 0.0 || d2 != 0.0) {
            this.push(1.0);
        } else {
            this.push(0.0);
        }
    }

    private void doNot() throws InvalidGlyphException {
        this.checkUnderflow(1);
        double d = this.pop();
        if (d == 0.0) {
            this.push(1.0);
        } else {
            this.push(0.0);
        }
    }

    private void doAbs() throws InvalidGlyphException {
        this.checkUnderflow(1);
        double d = this.pop();
        if (d < 0.0) {
            this.push(-d);
        } else {
            this.push(d);
        }
    }

    private void doAdd() throws InvalidGlyphException {
        this.checkUnderflow(2);
        double d = this.pop();
        double d2 = this.pop();
        this.push(d + d2);
    }

    private void doSub() throws InvalidGlyphException {
        this.checkUnderflow(2);
        double d = this.pop();
        double d2 = this.pop();
        this.push(d2 - d);
    }

    private void doNeg() throws InvalidGlyphException {
        this.checkUnderflow(1);
        double d = this.pop();
        this.push(-d);
    }

    private void doEq() throws InvalidGlyphException {
        this.checkUnderflow(2);
        double d = this.pop();
        double d2 = this.pop();
        if (d == d2) {
            this.push(1.0);
        } else {
            this.push(0.0);
        }
    }

    private void doIfElse() throws InvalidGlyphException {
        this.checkUnderflow(4);
        double d = this.pop();
        double d2 = this.pop();
        double d3 = this.pop();
        double d4 = this.pop();
        this.push(d2 <= d ? d4 : d3);
    }

    private void doSqrt() throws InvalidGlyphException {
        this.checkUnderflow(1);
        double d = this.pop();
        if (d < 0.0) {
            throw new InvalidGlyphException("Invalid sqrt argument");
        }
        this.push(Math.sqrt(d));
    }

    private void doPut() throws InvalidGlyphException {
        this.checkUnderflow(2);
        int n = (int)this.pop();
        if (n < 0 || n >= 32) {
            throw new InvalidGlyphException("Invalid index");
        }
        this.storage[n] = this.pop();
    }

    private void doGet() throws InvalidGlyphException {
        this.checkUnderflow(1);
        int n = (int)this.pop();
        if (n < 0 || n >= 32) {
            throw new InvalidGlyphException("Invalid index");
        }
        this.push(this.storage[n]);
    }

    private void doMul() throws InvalidGlyphException {
        this.checkUnderflow(2);
        double d = this.pop();
        double d2 = this.pop();
        this.push(d * d2);
    }

    private void doDiv() throws InvalidGlyphException {
        this.checkUnderflow(2);
        double d = this.pop();
        double d2 = this.pop();
        this.push(d2 / d);
    }

    private void doDup() throws InvalidGlyphException {
        this.checkUnderflow(1);
        double d = this.pop();
        this.checkOverflow(2);
        this.push(d);
        this.push(d);
    }

    private void doExch() throws InvalidGlyphException {
        this.checkUnderflow(2);
        double d = this.pop();
        double d2 = this.pop();
        this.push(d);
        this.push(d2);
    }

    private void reverse(int n, int n2) {
        while (n < n2) {
            double d = this.stack[n];
            this.stack[n++] = this.stack[n2];
            this.stack[n2--] = d;
        }
    }

    private double shiftStem(boolean bl, double d) {
        d = this.seacPhase == SeacPhase.seacAccentPostMove || this.seacPhase == SeacPhase.seacAccentPreMove ? (d += bl ? this.seac_adx : this.seac_ady) : (d += bl ? this.lsb_x : this.lsb_y);
        return d;
    }

    private void doStem(HintedOutlineConsumer hintedOutlineConsumer, boolean bl, double d, double d2) {
        if (!this.seenHintSub && this.movetoSeen) {
            this.seenHintSub = true;
            this.pendingHintSub = true;
        }
        d = this.shiftStem(bl, d);
        hintedOutlineConsumer.stem(d, d + d2, this.pendingHintSub, bl, false);
        this.pendingHintSub = false;
    }

    private void doStem3(HintedOutlineConsumer hintedOutlineConsumer, boolean bl) throws InvalidGlyphException {
        if (!this.seenHintSub && this.movetoSeen) {
            this.seenHintSub = true;
            this.pendingHintSub = true;
        }
        this.checkUnderflow(6);
        double d = this.index(0);
        double d2 = this.index(1);
        double d3 = this.index(2);
        double d4 = this.index(3);
        double d5 = this.index(4);
        double d6 = this.index(5);
        d = this.shiftStem(bl, d);
        d3 = this.shiftStem(bl, d3);
        d5 = this.shiftStem(bl, d5);
        hintedOutlineConsumer.stem3(d, d + d2, d3, d3 + d4, d5, d5 + d6, this.pendingHintSub, bl);
        this.pendingHintSub = false;
    }

    private void doMoveto(HintedOutlineConsumer hintedOutlineConsumer, double d, double d2) {
        this.pendingMove = false;
        this.movetoSeen = true;
        if (this.seacPhase == SeacPhase.seacAccentPreMove) {
            this.currentX = this.seac_adx + d;
            this.currentY = this.seac_ady + d2;
            this.seacPhase = SeacPhase.seacAccentPostMove;
        } else {
            this.currentX += d;
            this.currentY += d2;
        }
        hintedOutlineConsumer.moveto(this.currentX, this.currentY);
    }

    private void doLineto(HintedOutlineConsumer hintedOutlineConsumer, double d, double d2) {
        if (this.pendingMove) {
            this.doMoveto(hintedOutlineConsumer, 0.0, 0.0);
        }
        this.currentX += d;
        this.currentY += d2;
        hintedOutlineConsumer.lineto(this.currentX, this.currentY);
    }

    private void doCurveto(HintedOutlineConsumer hintedOutlineConsumer, double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.pendingMove) {
            this.doMoveto(hintedOutlineConsumer, 0.0, 0.0);
        }
        double d7 = this.currentX + d;
        double d8 = this.currentY + d2;
        double d9 = d7 + d3;
        double d10 = d8 + d4;
        this.currentX = d9 + d5;
        this.currentY = d10 + d6;
        hintedOutlineConsumer.curveto(d7, d8, d9, d10, this.currentX, this.currentY);
    }

    private void doFlex(HintedOutlineConsumer hintedOutlineConsumer) {
        if (this.pendingMove) {
            this.doMoveto(hintedOutlineConsumer, 0.0, 0.0);
        }
        double d = this.currentX + this.flexArgs[0] + this.flexArgs[2];
        double d2 = this.currentY + this.flexArgs[1] + this.flexArgs[3];
        double d3 = d + this.flexArgs[4];
        double d4 = d2 + this.flexArgs[5];
        double d5 = d3 + this.flexArgs[6];
        double d6 = d4 + this.flexArgs[7];
        double d7 = d5 + this.flexArgs[8];
        double d8 = d6 + this.flexArgs[9];
        double d9 = d7 + this.flexArgs[10];
        double d10 = d8 + this.flexArgs[11];
        double d11 = d9 + this.flexArgs[12];
        double d12 = d10 + this.flexArgs[13];
        this.currentX = d11;
        this.currentY = d12;
        hintedOutlineConsumer.flex(this.flexArgs[14], d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
        if (this.seacPhase == SeacPhase.seacNone || this.seacPhase == SeacPhase.seacBase) {
            this.currentX = this.flexArgs[15];
            this.currentY = this.flexArgs[16];
        }
    }

    private boolean doWidth(HintedOutlineConsumer hintedOutlineConsumer, double d) {
        if (d < -32000.0 || d > 32000.0) {
            d /= 65536.0;
        }
        return hintedOutlineConsumer.width(d);
    }

    private int addCounterGroup(HintedOutlineConsumer hintedOutlineConsumer, int n, boolean bl, boolean bl2) {
        double d;
        double d2 = 0.0;
        while (true) {
            d = d2 + this.counters[n--];
            double d3 = this.counters[n--];
            d2 = d + d3;
            if (d3 < 0.0) break;
            hintedOutlineConsumer.stem(d, d2, bl2, bl, true);
            bl2 = false;
        }
        hintedOutlineConsumer.stem(d2, d, bl2, bl, true);
        return n;
    }

    private void addCounters(HintedOutlineConsumer hintedOutlineConsumer, boolean bl) {
        int n;
        int n2;
        for (n2 = this.stackCount - 1; n2 >= 0; --n2) {
            this.counters[this.counterCount++] = this.stack[n2];
        }
        if (!bl) {
            return;
        }
        int n3 = this.counterCount - 1;
        int n4 = (int)this.counters[n3];
        int n5 = n3 - 1;
        for (n2 = 0; n2 < n4; ++n2) {
            do {
                if ((n3 -= 2) >= 1) continue;
                return;
            } while (this.counters[n3] >= 0.0);
        }
        int n6 = --n3;
        if ((n = (int)this.counters[n6--]) == 0 && n4 == 0) {
            hintedOutlineConsumer.noCounters();
        } else {
            while (n4 > 0 || n > 0) {
                if (n4-- > 0) {
                    n5 = this.addCounterGroup(hintedOutlineConsumer, n5, false, true);
                    if (n-- <= 0) continue;
                    n6 = this.addCounterGroup(hintedOutlineConsumer, n6, true, false);
                    continue;
                }
                --n;
                n6 = this.addCounterGroup(hintedOutlineConsumer, n6, true, true);
            }
        }
    }

    private void internalParse(Type1Font type1Font, byte[] byArray, HintedOutlineConsumer hintedOutlineConsumer) throws InvalidGlyphException, UnsupportedFontException {
        block78: for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            block0 : switch (n) {
                case 0: 
                case 2: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    throw new InvalidGlyphException("illegal charstring operator");
                }
                case 1: {
                    this.checkUnderflow(2);
                    this.doStem(hintedOutlineConsumer, false, this.index(0), this.index(1));
                    break;
                }
                case 3: {
                    this.checkUnderflow(2);
                    this.doStem(hintedOutlineConsumer, true, this.index(0), this.index(1));
                    break;
                }
                case 4: {
                    this.checkUnderflow(1);
                    if (this.inFlex) {
                        this.checkFlex(2);
                        this.pushFlex(0.0);
                        this.pushFlex(this.index(0));
                        break;
                    }
                    this.doMoveto(hintedOutlineConsumer, 0.0, this.index(0));
                    break;
                }
                case 5: {
                    this.checkUnderflow(2);
                    this.doLineto(hintedOutlineConsumer, this.index(0), this.index(1));
                    break;
                }
                case 6: {
                    this.checkUnderflow(1);
                    this.doLineto(hintedOutlineConsumer, this.index(0), 0.0);
                    break;
                }
                case 7: {
                    this.checkUnderflow(1);
                    this.doLineto(hintedOutlineConsumer, 0.0, this.index(0));
                    break;
                }
                case 8: {
                    this.checkUnderflow(6);
                    this.doCurveto(hintedOutlineConsumer, this.index(0), this.index(1), this.index(2), this.index(3), this.index(4), this.index(5));
                    break;
                }
                case 9: {
                    this.pendingMove = true;
                    hintedOutlineConsumer.closepath();
                    break;
                }
                case 10: {
                    this.checkUnderflow(1);
                    int n2 = (int)this.pop();
                    if (n2 < 0 || n2 > type1Font.getNumSubrs()) {
                        throw new InvalidGlyphException("invalid subr number");
                    }
                    byte[] byArray2 = type1Font.getSubr(n2);
                    int n3 = i;
                    this.internalParse(type1Font, byArray2, hintedOutlineConsumer);
                    if (this.endcharSeen) {
                        return;
                    }
                    i = n3;
                    continue block78;
                }
                case 11: {
                    return;
                }
                case 12: {
                    if (++i >= byArray.length) {
                        throw new InvalidGlyphException("invalid esc command in charstring");
                    }
                    n = byArray[i] & 0xFF;
                    switch (n) {
                        case 0: {
                            break block0;
                        }
                        case 3: {
                            this.doAnd();
                            continue block78;
                        }
                        case 4: {
                            this.doOr();
                            continue block78;
                        }
                        case 5: {
                            this.doNot();
                            continue block78;
                        }
                        case 8: {
                            throw new UnsupportedFontException("mm not supported");
                        }
                        case 9: {
                            this.doAbs();
                            continue block78;
                        }
                        case 10: {
                            this.doAdd();
                            continue block78;
                        }
                        case 11: {
                            this.doSub();
                            continue block78;
                        }
                        case 13: {
                            throw new UnsupportedFontException("mm not supported");
                        }
                        case 14: {
                            this.doNeg();
                            continue block78;
                        }
                        case 15: {
                            this.doEq();
                            continue block78;
                        }
                        case 18: {
                            this.checkUnderflow(1);
                            --this.stackCount;
                            continue block78;
                        }
                        case 20: {
                            this.doPut();
                            continue block78;
                        }
                        case 21: {
                            this.doGet();
                            continue block78;
                        }
                        case 22: {
                            this.doIfElse();
                            continue block78;
                        }
                        case 23: {
                            continue block78;
                        }
                        case 24: {
                            this.doMul();
                            continue block78;
                        }
                        case 26: {
                            this.doSqrt();
                            continue block78;
                        }
                        case 27: {
                            this.doDup();
                            continue block78;
                        }
                        case 28: {
                            this.doExch();
                            continue block78;
                        }
                        case 29: {
                            this.checkUnderflow(1);
                            int n4 = (int)this.pop();
                            if (n4 < 0) {
                                n4 = 0;
                            }
                            if (n4 >= this.stackCount) {
                                throw new InvalidGlyphException("invalid index");
                            }
                            this.push(this.stack[this.stackCount - 1 - n4]);
                            continue block78;
                        }
                        case 30: {
                            this.checkUnderflow(2);
                            int n5 = (int)this.pop();
                            int n6 = (int)this.pop();
                            int n7 = this.stackCount - 1;
                            int n8 = this.stackCount - n6;
                            if (n6 < 0 || n8 < 0) {
                                throw new InvalidGlyphException("invalid roll");
                            }
                            if (n5 < 0) {
                                n5 = n6 - -n5 % n6;
                            }
                            this.reverse(n7 - (n5 %= n6) + 1, n7);
                            this.reverse(n8, n7 - n5);
                            this.reverse(n8, n7);
                            continue block78;
                        }
                        case 1: {
                            this.doStem3(hintedOutlineConsumer, true);
                            break block0;
                        }
                        case 2: {
                            this.doStem3(hintedOutlineConsumer, false);
                            break block0;
                        }
                        case 6: {
                            this.checkUnderflow(5);
                            String string = StandardEncoding.names[(int)this.index(3) & 0xFF];
                            String string2 = StandardEncoding.names[(int)this.index(4) & 0xFF];
                            this.seac_adx = this.lsb_x + this.index(1);
                            this.seac_ady = this.lsb_y + this.index(2);
                            this.seacPhase = SeacPhase.seacBase;
                            byte[] byArray3 = type1Font.getCharstring(type1Font.glyphName2gid(string));
                            this.internalParse(type1Font, byArray3, hintedOutlineConsumer);
                            this.endcharSeen = false;
                            this.pendingHintSub = true;
                            this.seacPhase = SeacPhase.seacAccentPreMove;
                            byArray3 = type1Font.getCharstring(type1Font.glyphName2gid(string2));
                            this.internalParse(type1Font, byArray3, hintedOutlineConsumer);
                            return;
                        }
                        case 7: {
                            if (this.seacPhase != SeacPhase.seacNone) break block0;
                            this.checkUnderflow(4);
                            this.currentY = this.lsb_y = this.index(1);
                            this.currentX = this.lsb_x = this.index(0);
                            if (this.doWidth(hintedOutlineConsumer, this.index(2))) break block0;
                            return;
                        }
                        case 12: {
                            this.doDiv();
                            continue block78;
                        }
                        case 16: {
                            this.checkUnderflow(2);
                            int n9 = (int)this.pop();
                            this.pop();
                            switch (n9) {
                                case 0: {
                                    this.checkUnderflow(3);
                                    if (this.flexCount != 14) {
                                        throw new InvalidGlyphException("missing flex arguments");
                                    }
                                    this.pushFlex(this.index(0));
                                    this.pushFlex(this.index(1));
                                    this.pushFlex(this.index(2));
                                    this.doFlex(hintedOutlineConsumer);
                                    break block0;
                                }
                                case 1: {
                                    this.flexCount = 0;
                                    this.inFlex = true;
                                    continue block78;
                                }
                                case 2: {
                                    continue block78;
                                }
                                case 3: {
                                    this.pendingHintSub = true;
                                    this.seenHintSub = true;
                                    continue block78;
                                }
                                case 6: {
                                    hintedOutlineConsumer.globalColorOn();
                                    continue block78;
                                }
                                case 12: {
                                    this.addCounters(hintedOutlineConsumer, false);
                                    break block0;
                                }
                                case 13: {
                                    this.addCounters(hintedOutlineConsumer, true);
                                    break block0;
                                }
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: {
                                    throw new UnsupportedFontException("mm not supported");
                                }
                                case 20: {
                                    this.doAdd();
                                    continue block78;
                                }
                                case 21: {
                                    this.doSub();
                                    continue block78;
                                }
                                case 22: {
                                    this.doMul();
                                    continue block78;
                                }
                                case 23: {
                                    this.doDiv();
                                    continue block78;
                                }
                                case 24: {
                                    this.doPut();
                                    continue block78;
                                }
                                case 25: {
                                    this.doGet();
                                    continue block78;
                                }
                                case 27: {
                                    this.doIfElse();
                                    continue block78;
                                }
                                case 28: {
                                    continue block78;
                                }
                                case 29: {
                                    this.doDup();
                                    continue block78;
                                }
                                case 30: {
                                    this.doExch();
                                    continue block78;
                                }
                                case 19: {
                                    throw new UnsupportedFontException("mm not supported");
                                }
                                default: {
                                    throw new InvalidGlyphException("Invalid OtherSubr");
                                }
                            }
                        }
                        case 17: {
                            continue block78;
                        }
                        case 25: {
                            this.doDiv();
                            continue block78;
                        }
                        case 33: {
                            if (this.inFlex) {
                                this.inFlex = false;
                                break block0;
                            }
                            this.checkUnderflow(2);
                            this.currentX = this.index(0);
                            this.currentY = this.index(1);
                            break block0;
                        }
                        default: {
                            throw new InvalidGlyphException("illegal operators in charstring");
                        }
                    }
                }
                case 13: {
                    if (this.seacPhase != SeacPhase.seacNone) break;
                    this.checkUnderflow(2);
                    this.currentX = this.lsb_x = this.index(0);
                    this.lsb_y = 0.0;
                    this.currentY = 0.0;
                    if (this.doWidth(hintedOutlineConsumer, this.index(1))) break;
                    return;
                }
                case 14: {
                    this.pendingMove = true;
                    this.endcharSeen = true;
                    if (this.seacPhase != SeacPhase.seacBase) {
                        hintedOutlineConsumer.endchar();
                    }
                    return;
                }
                case 15: {
                    this.checkUnderflow(2);
                    double d = this.pop();
                    this.push(this.pop() - this.currentX);
                    this.push(d - this.currentY);
                }
                case 21: {
                    this.checkUnderflow(2);
                    if (this.inFlex) {
                        this.checkFlex(2);
                        this.pushFlex(this.index(0));
                        this.pushFlex(this.index(1));
                        break;
                    }
                    this.doMoveto(hintedOutlineConsumer, this.index(0), this.index(1));
                    break;
                }
                case 22: {
                    this.checkUnderflow(1);
                    if (this.inFlex) {
                        this.checkFlex(2);
                        this.pushFlex(this.index(0));
                        this.pushFlex(0.0);
                        break;
                    }
                    this.doMoveto(hintedOutlineConsumer, this.index(0), 0.0);
                    break;
                }
                case 30: {
                    this.checkUnderflow(4);
                    this.doCurveto(hintedOutlineConsumer, 0.0, this.index(0), this.index(1), this.index(2), this.index(3), 0.0);
                    break;
                }
                case 31: {
                    this.checkUnderflow(4);
                    this.doCurveto(hintedOutlineConsumer, this.index(0), 0.0, this.index(1), this.index(2), 0.0, this.index(3));
                    break;
                }
                default: {
                    this.checkOverflow(1);
                    this.push(n - 139);
                    continue block78;
                }
                case 247: 
                case 248: 
                case 249: 
                case 250: {
                    this.checkOverflow(1);
                    if (++i >= byArray.length) {
                        throw new InvalidGlyphException("invalid esc command in charstring");
                    }
                    int n10 = byArray[i] & 0xFF;
                    this.push(108 + 256 * (n - 247) + n10);
                    continue block78;
                }
                case 251: 
                case 252: 
                case 253: 
                case 254: {
                    this.checkOverflow(1);
                    if (++i >= byArray.length) {
                        throw new InvalidGlyphException("invalid esc command in charstring");
                    }
                    int n10 = byArray[i] & 0xFF;
                    this.push(-108 - 256 * (n - 251) - n10);
                    continue block78;
                }
                case 255: {
                    this.checkOverflow(1);
                    if (i + 4 >= byArray.length) {
                        throw new InvalidGlyphException("invalid esc command in charstring");
                    }
                    int n11 = byArray[++i] & 0xFF;
                    n11 = n11 << 8 | byArray[++i] & 0xFF;
                    n11 = n11 << 8 | byArray[++i] & 0xFF;
                    n11 = n11 << 8 | byArray[++i] & 0xFF;
                    this.push(n11);
                    continue block78;
                }
            }
            this.clearStack();
        }
        hintedOutlineConsumer.endchar();
    }

    public void parse(HintedOutlineConsumer hintedOutlineConsumer, Type1Font type1Font, int n) throws InvalidGlyphException, UnsupportedFontException {
        byte[] byArray = type1Font.getCharstring(n);
        this.lsb_y = 0.0;
        this.lsb_x = 0.0;
        this.currentY = 0.0;
        this.currentX = 0.0;
        this.seacPhase = SeacPhase.seacNone;
        this.stackCount = 0;
        this.counterCount = 0;
        this.inFlex = false;
        this.pendingMove = true;
        this.endcharSeen = false;
        this.pendingHintSub = false;
        this.seenHintSub = false;
        this.movetoSeen = false;
        this.internalParse(type1Font, byArray, hintedOutlineConsumer);
    }
}

