/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Comparator;
import java.util.Set;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.SortedBag;

public class BagUtils {
    private BagUtils() {
    }

    public static Bag predicatedBag(Bag bag, Predicate predicate) {
        return new PredicatedBag(bag, predicate);
    }

    public static Bag unmodifiableBag(Bag bag) {
        return new UnmodifiableBag(bag);
    }

    public static Bag synchronizedBag(Bag bag) {
        return new SynchronizedBag(bag);
    }

    public static SortedBag predicatedSortedBag(SortedBag bag, Predicate predicate) {
        return new PredicatedSortedBag(bag, predicate);
    }

    public static SortedBag unmodifiableSortedBag(SortedBag bag) {
        return new UnmodifiableSortedBag(bag);
    }

    public static SortedBag synchronizedSortedBag(SortedBag bag) {
        return new SynchronizedSortedBag(bag);
    }

    static class UnmodifiableSortedBag
    extends UnmodifiableBag
    implements SortedBag {
        public UnmodifiableSortedBag(SortedBag bag) {
            super(bag);
        }

        public Comparator comparator() {
            return this.getSortedBag().comparator();
        }

        public Object first() {
            return this.getSortedBag().first();
        }

        public Object last() {
            return this.getSortedBag().last();
        }

        private SortedBag getSortedBag() {
            return (SortedBag)this.collection;
        }
    }

    static class SynchronizedSortedBag
    extends SynchronizedBag
    implements SortedBag {
        public SynchronizedSortedBag(SortedBag bag) {
            super(bag);
        }

        public synchronized Comparator comparator() {
            return this.getSortedBag().comparator();
        }

        public synchronized Object first() {
            return this.getSortedBag().first();
        }

        public synchronized Object last() {
            return this.getSortedBag().last();
        }

        private SortedBag getSortedBag() {
            return (SortedBag)this.collection;
        }
    }

    static class PredicatedSortedBag
    extends PredicatedBag
    implements SortedBag {
        public PredicatedSortedBag(SortedBag sb, Predicate p) {
            super(sb, p);
        }

        public Comparator comparator() {
            return this.getSortedBag().comparator();
        }

        public Object first() {
            return this.getSortedBag().first();
        }

        public Object last() {
            return this.getSortedBag().last();
        }

        private SortedBag getSortedBag() {
            return (SortedBag)this.collection;
        }
    }

    static class SynchronizedBag
    extends CollectionUtils.SynchronizedCollection
    implements Bag {
        public SynchronizedBag(Bag bag) {
            super(bag);
        }

        public synchronized boolean add(Object o, int count) {
            return this.getBag().add(o, count);
        }

        public synchronized boolean remove(Object o, int count) {
            return this.getBag().remove(o, count);
        }

        public synchronized Set uniqueSet() {
            return this.getBag().uniqueSet();
        }

        public synchronized int getCount(Object o) {
            return this.getBag().getCount(o);
        }

        private Bag getBag() {
            return (Bag)this.collection;
        }
    }

    static class UnmodifiableBag
    extends CollectionUtils.UnmodifiableCollection
    implements Bag {
        public UnmodifiableBag(Bag bag) {
            super(bag);
        }

        private Bag getBag() {
            return (Bag)this.collection;
        }

        public boolean add(Object o, int count) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o, int count) {
            throw new UnsupportedOperationException();
        }

        public Set uniqueSet() {
            return ((Bag)this.collection).uniqueSet();
        }

        public int getCount(Object o) {
            return ((Bag)this.collection).getCount(o);
        }
    }

    static class PredicatedBag
    extends CollectionUtils.PredicatedCollection
    implements Bag {
        public PredicatedBag(Bag b, Predicate p) {
            super(b, p);
        }

        public boolean add(Object o, int count) {
            this.validate(o);
            return this.getBag().add(o, count);
        }

        public boolean remove(Object o, int count) {
            return this.getBag().remove(o, count);
        }

        public Set uniqueSet() {
            return this.getBag().uniqueSet();
        }

        public int getCount(Object o) {
            return this.getBag().getCount(o);
        }

        private Bag getBag() {
            return (Bag)this.collection;
        }
    }
}

