/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.services;

import flex.license.common.InMemoryLoader;
import flex.webtier.server.j2ee.cache.CacheHelper;
import flex.webtier.services.config.Configurator;
import flex.webtier.services.extensions.ExtensionManager;
import flex.webtier.services.license.InvalidLicenseException;
import flex.webtier.services.license.LicenseService;
import flex.webtier.services.license.LicenseServiceImpl;
import flex.webtier.services.logging.Logger;
import flex.webtier.util.ServerUtil;
import flex.webtier.util.Trace;
import java.util.HashMap;

public abstract class ServiceFactory {
    private static Configurator configurator;
    private static boolean mxmlSwfExtension;
    private static ExtensionManager extensionManager;
    private static LicenseService licenseService;
    private static Logger logger;
    private static ThreadLocal threadLocalLicense;
    private static CacheHelper cacheHelper;
    protected static ServiceFactory factoryImpl;
    public static final String FLEX_LICENSE = "flexbuilder3";

    public static ServiceFactory getFactory(HashMap properties) throws Exception {
        block5: {
            String serviceClassName = "flex.webtier.oem.OEMServiceImpl";
            try {
                if (factoryImpl != null) break block5;
                try {
                    factoryImpl = (ServiceFactory)Class.forName(serviceClassName).newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    serviceClassName = ServerUtil.isDotNet() ? "flex.webtier.services.DotNetServiceImpl" : "flex.webtier.services.J2EEServiceImpl";
                    factoryImpl = (ServiceFactory)Class.forName(serviceClassName).newInstance();
                }
                factoryImpl.init(properties);
            }
            catch (Exception e) {
                if (Trace.error) {
                    e.printStackTrace();
                }
                throw new Exception("Failed to locate ServiceFactory: " + serviceClassName + "; message = " + e.getMessage());
            }
        }
        return factoryImpl;
    }

    public void init(HashMap properties) {
    }

    public abstract void start() throws Exception;

    public abstract void stop();

    public static final Configurator getConfigurator() {
        return configurator;
    }

    public static final boolean isMxmlSwfExtension() {
        return mxmlSwfExtension;
    }

    public static final LicenseService getLicenseService() {
        try {
            Object licenseObj = threadLocalLicense.get();
            if (licenseObj instanceof String) {
                String licenseStr = (String)licenseObj;
                LicenseServiceImpl license = new LicenseServiceImpl(new InMemoryLoader(licenseStr, null, null));
                license.init();
                threadLocalLicense.set(license);
                return license;
            }
            if (licenseObj instanceof LicenseServiceImpl) {
                LicenseServiceImpl license = (LicenseServiceImpl)licenseObj;
                return license;
            }
        }
        catch (InvalidLicenseException e) {
            return licenseService;
        }
        return licenseService;
    }

    public static final Logger getLogger() {
        return logger;
    }

    public static final void setConfigurator(Configurator c) {
        configurator = c;
    }

    public static final void setMxmlSwfExtension(boolean b) {
        mxmlSwfExtension = b;
    }

    public static final void setLogger(Logger l) {
        logger = l;
    }

    public static final void setLicenseService(LicenseServiceImpl l) {
        licenseService = l;
    }

    public static final ExtensionManager getExtensionManager() {
        return extensionManager;
    }

    public static final void setExtensionManager(ExtensionManager em) {
        extensionManager = em;
    }

    public static final void setThreadLocalLicense(String license) {
        if (license != null && (license = license.trim()).equals("")) {
            license = null;
        }
        threadLocalLicense.set(license);
    }

    public static final CacheHelper getCacheHelper() {
        return cacheHelper;
    }

    public static final void setCacheHelper(CacheHelper ch) {
        cacheHelper = ch;
    }

    public static void destroy() {
        configurator = null;
        extensionManager = null;
        licenseService = null;
        logger = null;
        threadLocalLicense.set(null);
        threadLocalLicense = null;
        cacheHelper = null;
        factoryImpl = null;
    }

    static {
        mxmlSwfExtension = true;
        threadLocalLicense = new ThreadLocal();
    }
}

