import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.utils.*

class FootprintTests extends SpaceCardModelTestCase {
	
    void testCreateDelete() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		assertNotNull sv
		def svc = Organization.getSupervisorCommunity()
		assertNotNull svc
		def p1 = Project.create(
				[
				 title:"hoge1",
				 creator:sv
				]
				,svc)
		assertTrue "0", ModelUtils.flush(p1)

		assertTrue "1", p1.leaveFootprint(sv) != null
		assertTrue "2", ModelUtils.flush(p1)

		assertTrue "3", p1.footprints?.size() == 1

		assertTrue "4", p1.leaveFootprint(sv) != null
		assertTrue "5", ModelUtils.flush(p1)
		assertTrue "6", p1.footprints?.size() == 1

		def fps = ModelUtils.cloneCollection(p1.footprints)
		fps.each { fp ->
			println "remove: ${fp}"
			assertTrue "7", fp.remove()
		}
		assertTrue "8", p1.footprints?.size() == 0
    }
}
