/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.OutlineConsumer2;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.TTInterpreter;
import com.adobe.fontengine.font.opentype.TTOutline;
import com.adobe.fontengine.font.opentype.TTPoint;
import com.adobe.fontengine.math.F26Dot6;

public final class TTSimpleOutline
extends TTOutline {
    public TTPoint[] points;
    public int[] contourEndPoints;
    public OTByteArray instructions;
    public int instructionsOffset;
    public int instructionsLength;
    private boolean isScaled = false;
    private boolean isInstructed = false;
    private int currentUnitsPerEm = -1;
    private Matrix currentEm2px = null;
    private int scanType;

    public void scale(int n, Matrix matrix) {
        int n2;
        if (this.isScaled && this.currentUnitsPerEm == n && matrix.equals(this.currentEm2px)) {
            return;
        }
        for (n2 = 0; n2 < this.points.length; ++n2) {
            this.points[n2].scale(n, matrix);
        }
        n2 = this.points.length - 4;
        int n3 = F26Dot6.roundHalfUp(F26Dot6.fromDouble(matrix.applyToXYGetX((double)(this.points[n2 + 1].unscaled.x - this.points[n2].unscaled.x) / (double)n, 0.0)));
        this.points[n2 + 1].hinted.x = this.points[n2].hinted.x + n3;
        this.points[n2 + 2].hinted.y = F26Dot6.round(this.points[n2 + 2].hinted.y);
        int n4 = F26Dot6.roundHalfUp(F26Dot6.fromDouble(matrix.applyToXYGetY(0.0, (double)(this.points[n2 + 3].unscaled.y - this.points[n2 + 2].unscaled.y) / (double)n)));
        this.points[n2 + 3].hinted.y = this.points[n2 + 2].hinted.y + n4;
        this.isScaled = true;
        this.currentUnitsPerEm = n;
        this.currentEm2px = matrix;
        this.isInstructed = false;
    }

    private void shiftPoints(int n, int n2, int n3, int n4) {
        for (int i = n3; i < n4; ++i) {
            this.points[i].hinted.x += n;
            this.points[i].hinted.y += n2;
        }
    }

    public int getScanType() {
        return this.scanType;
    }

    public void instruct(TTInterpreter tTInterpreter) throws InvalidGlyphException, UnsupportedFontException {
        if (this.isInstructed) {
            return;
        }
        int n = F26Dot6.roundHalfUp(this.points[this.points.length - 4].unhinted.x);
        this.shiftPoints(n - this.points[this.points.length - 4].unhinted.x, 0, 0, this.points.length);
        tTInterpreter.runGlyf(this, this.instructions, this.instructionsOffset, this.instructionsOffset + this.instructionsLength);
        this.scanType = tTInterpreter.getScanType();
        this.isInstructed = true;
    }

    TTPoint getPoint(int n) throws InvalidGlyphException {
        if (n < 0 || this.points.length <= n) {
            throw new InvalidGlyphException("attempt to access invalid point " + n + " in zone 0");
        }
        return this.points[n];
    }

    int getNumOutlinePoints() {
        return this.points.length - 4;
    }

    int getNumContours() {
        return this.contourEndPoints.length;
    }

    int getContourNextPoint(int n, int n2) throws InvalidGlyphException {
        if (++n2 > this.contourEndPoints[n]) {
            n2 = this.getContourFirstPoint(n);
        }
        return n2;
    }

    int getContourFirstPoint(int n) throws InvalidGlyphException {
        if (n < 0 || this.contourEndPoints.length <= n) {
            throw new InvalidGlyphException("attempt to access invalid contour " + n);
        }
        if (n == 0) {
            return 0;
        }
        return this.contourEndPoints[n - 1] + 1;
    }

    int getContourLastPoint(int n) throws InvalidGlyphException {
        if (n < 0 || this.contourEndPoints.length <= n) {
            throw new InvalidGlyphException("attempt to access invalid contour " + n);
        }
        return this.contourEndPoints[n];
    }

    public TTSimpleOutline getMerged() {
        return this;
    }

    public void toConsumer(OutlineConsumer outlineConsumer) throws InvalidFontException {
        for (int i = 0; i < this.contourEndPoints.length; ++i) {
            double d;
            double d2;
            TTPoint tTPoint;
            double d3;
            double d4;
            int n = this.getContourFirstPoint(i);
            int n2 = this.getContourLastPoint(i);
            TTPoint tTPoint2 = this.getPoint(n);
            double d5 = F26Dot6.toDouble(tTPoint2.hinted.x);
            double d6 = F26Dot6.toDouble(tTPoint2.hinted.y);
            if (tTPoint2.onCurve) {
                d4 = F26Dot6.toDouble(tTPoint2.hinted.x);
                d3 = F26Dot6.toDouble(tTPoint2.hinted.y);
            } else {
                tTPoint = this.getPoint(n2);
                d2 = F26Dot6.toDouble(tTPoint.hinted.x);
                d = F26Dot6.toDouble(tTPoint.hinted.y);
                if (tTPoint.onCurve) {
                    d4 = d2;
                    d3 = d;
                } else {
                    d4 = (d2 + d5) / 2.0;
                    d3 = (d + d6) / 2.0;
                }
            }
            outlineConsumer.moveto(d4, d3);
            while (n < n2) {
                tTPoint = tTPoint2;
                d2 = d5;
                d = d6;
                tTPoint2 = this.getPoint(++n);
                d5 = F26Dot6.toDouble(tTPoint2.hinted.x);
                d6 = F26Dot6.toDouble(tTPoint2.hinted.y);
                if (tTPoint2.onCurve) {
                    if (tTPoint.onCurve) {
                        outlineConsumer.lineto(d5, d6);
                        continue;
                    }
                    outlineConsumer.curveto(d2, d, d5, d6);
                    continue;
                }
                if (tTPoint.onCurve) continue;
                outlineConsumer.curveto(d2, d, (d2 + d5) / 2.0, (d + d6) / 2.0);
            }
            if (tTPoint2.onCurve) {
                if (d5 == d4 && d6 == d3) continue;
                outlineConsumer.lineto(d4, d3);
                continue;
            }
            outlineConsumer.curveto(d5, d6, d4, d3);
        }
        outlineConsumer.endchar();
    }

    public void toConsumer2(OutlineConsumer2 outlineConsumer2) throws InvalidFontException {
        outlineConsumer2.startOutline();
        for (int i = 0; i < this.contourEndPoints.length; ++i) {
            int n;
            int n2;
            outlineConsumer2.startContour();
            int n3 = this.getContourFirstPoint(i);
            int n4 = this.getContourLastPoint(i);
            TTPoint tTPoint = this.getPoint(n3);
            if (tTPoint.onCurve) {
                n2 = tTPoint.hinted.x;
                n = tTPoint.hinted.y;
            } else {
                TTPoint tTPoint2 = this.getPoint(n4);
                if (tTPoint2.onCurve) {
                    n2 = tTPoint2.hinted.x;
                    n = tTPoint2.hinted.y;
                } else {
                    n2 = (tTPoint2.hinted.x + tTPoint.hinted.x + 1) / 2;
                    n = (tTPoint2.hinted.y + tTPoint.hinted.y + 1) / 2;
                }
            }
            int n5 = n2;
            int n6 = n;
            while (n3 < n4) {
                TTPoint tTPoint3 = tTPoint;
                tTPoint = this.getPoint(++n3);
                if (tTPoint.onCurve) {
                    if (tTPoint3.onCurve) {
                        outlineConsumer2.line(n5, n6, tTPoint.hinted.x, tTPoint.hinted.y);
                        n5 = tTPoint.hinted.x;
                        n6 = tTPoint.hinted.y;
                        continue;
                    }
                    outlineConsumer2.quadraticCurve(n5, n6, tTPoint3.hinted.x, tTPoint3.hinted.y, tTPoint.hinted.x, tTPoint.hinted.y);
                    n5 = tTPoint.hinted.x;
                    n6 = tTPoint.hinted.y;
                    continue;
                }
                if (tTPoint3.onCurve) continue;
                outlineConsumer2.quadraticCurve(n5, n6, tTPoint3.hinted.x, tTPoint3.hinted.y, (tTPoint3.hinted.x + tTPoint.hinted.x + 1) / 2, (tTPoint3.hinted.y + tTPoint.hinted.y + 1) / 2);
                n5 = (tTPoint3.hinted.x + tTPoint.hinted.x + 1) / 2;
                n6 = (tTPoint3.hinted.y + tTPoint.hinted.y + 1) / 2;
            }
            if (tTPoint.onCurve) {
                if (tTPoint.hinted.x != n2 || tTPoint.hinted.y != n) {
                    outlineConsumer2.line(n5, n6, n2, n);
                }
            } else {
                outlineConsumer2.quadraticCurve(n5, n6, tTPoint.hinted.x, tTPoint.hinted.y, n2, n);
            }
            outlineConsumer2.endContour();
        }
        outlineConsumer2.endOutline();
    }

    public void translate() {
        int n = F26Dot6.roundHalfUp(this.points[this.points.length - 4].hinted.x);
        int n2 = F26Dot6.roundHalfUp(this.points[this.points.length - 4].hinted.y);
        this.shiftPoints(-n, -n2, 0, this.points.length);
    }
}

