/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement;

import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontLoader;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

final class StreamFont
extends FontImpl {
    static final long serialVersionUID = 1L;
    private final FontInputStream stream;
    private final int length;
    private final boolean wasEmbedded;
    private FontData fontRef;

    StreamFont(FontInputStream fontInputStream, int n, boolean bl) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        this.stream = fontInputStream;
        this.length = n;
        this.fontRef = this.loadFont(fontInputStream, n);
        this.wasEmbedded = bl;
    }

    private FontData loadFont(FontInputStream fontInputStream, int n) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontData[] fontDataArray = null;
        try {
            fontDataArray = FontLoader.fromStream(fontInputStream, n);
        }
        catch (IOException iOException) {
            throw new FontLoadingException(fontInputStream.toString(), iOException);
        }
        if (fontDataArray == null || fontDataArray.length == 0) {
            throw new FontLoadingException("Stream did not contain a font.");
        }
        return fontDataArray[0];
    }

    public boolean wasEmbedded() {
        return this.wasEmbedded;
    }

    protected FontData retrieveFontData() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        return this.fontRef;
    }

    public int hashCode() {
        return this.stream.hashCode() ^ this.length;
    }

    public boolean equals(Object object) {
        return object != null && this == object;
    }

    public String toString() {
        return this.stream.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws NotSerializableException {
        throw new NotSerializableException();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws NotSerializableException {
        throw new NotSerializableException();
    }
}

