/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.infontformatting.IndicFormatter;

final class DevanagariFormatter
extends IndicFormatter {
    DevanagariFormatter() {
    }

    protected int splitVowelsAndNormalize(AttributedRun attributedRun, int n, int n2) {
        while (n < n2) {
            int n3 = attributedRun.elementAt(n);
            switch (n3) {
                case 2353: {
                    if (n + 1 >= n2 || attributedRun.elementAt(n + 1) != 2381) break;
                    attributedRun.replace(new int[]{n, n + 1}, new int[]{2352, 2381, 8205});
                    ++n2;
                    n += 3;
                }
            }
            ++n;
        }
        return n2;
    }

    protected int nukta() {
        return 2364;
    }

    protected int virama() {
        return 2381;
    }

    protected boolean isConsonant(int n) {
        return 2325 <= n && n <= 2361 || 2392 <= n && n <= 2399 || 9676 == n;
    }

    protected boolean hasNukta(int n) {
        return 2345 == n || 2353 == n || 2356 == n || 2392 <= n && n <= 2399;
    }

    protected int removeNukta(int n) {
        switch (n) {
            case 2345: {
                return 2344;
            }
            case 2353: {
                return 2352;
            }
            case 2356: {
                return 2355;
            }
            case 2392: {
                return 2325;
            }
            case 2393: {
                return 2326;
            }
            case 2394: {
                return 2327;
            }
            case 2395: {
                return 2332;
            }
            case 2396: {
                return 2337;
            }
            case 2397: {
                return 2364;
            }
            case 2398: {
                return 2347;
            }
            case 2399: {
                return 2351;
            }
        }
        return n;
    }

    protected boolean isMark(int n) {
        return 2366 <= n && n <= 2380 || 2402 <= n && n <= 2403 || 2305 <= n && n <= 2307 || 2385 <= n && n <= 2388;
    }

    protected boolean isIndependentVowel(int n) {
        return 2308 <= n && n <= 2324 || 2400 <= n && n <= 2401 || 9676 == n;
    }

    protected IndicFormatter.Position getPosition(int n) {
        switch (n) {
            case 2367: {
                return IndicFormatter.Position.left;
            }
            case 2373: 
            case 2374: 
            case 2375: 
            case 2376: {
                return IndicFormatter.Position.topMatra;
            }
            case 2305: 
            case 2306: 
            case 2385: 
            case 2387: 
            case 2388: {
                return IndicFormatter.Position.topOther;
            }
            case 2369: 
            case 2370: 
            case 2371: 
            case 2372: 
            case 2386: 
            case 2402: 
            case 2403: {
                return IndicFormatter.Position.bottom;
            }
            case 2366: 
            case 2368: 
            case 2377: 
            case 2378: 
            case 2379: 
            case 2380: {
                return IndicFormatter.Position.rightMatra;
            }
            case 2307: {
                return IndicFormatter.Position.rightOther;
            }
        }
        return IndicFormatter.Position.any;
    }

    protected IndicFormatter.Shape rephLike(int n) {
        if (n == 2352) {
            return IndicFormatter.Shape.rephVowel;
        }
        return IndicFormatter.Shape.any;
    }

    protected boolean subjoins(int n) {
        return n == 2352;
    }

    protected boolean postjoins(int n) {
        return false;
    }

    protected boolean postjoinsIndependentVowels(int n) {
        return false;
    }
}

