/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Gdef;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.OTSelector;
import com.adobe.fontengine.font.opentype.Tag;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import java.io.IOException;
import java.util.Arrays;

public abstract class LookupTable
extends LayoutTable {
    protected static final LookupResult lookupNotApplied = new LookupResult(false, 0, 0);
    static final int[] noMatch = new int[0];

    public LookupTable(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray);
    }

    protected abstract int getScriptListOffset() throws InvalidFontException;

    protected abstract int getFeatureListOffset() throws InvalidFontException;

    protected abstract int getLookupListOffset() throws InvalidFontException;

    public int[][] resolveFeatureTag(int n, int n2, int[] nArray) throws InvalidFontException {
        int n3;
        int n4;
        int n5;
        int[][] nArrayArray = new int[nArray.length][];
        int n6 = this.getScriptListOffset();
        int n7 = this.data.getuint16(n6);
        int n8 = -1;
        for (n5 = 0; n5 < n7; ++n5) {
            n4 = this.data.getint32(n6 + 2 + 6 * n5);
            if (n == n4) {
                n8 = n5;
                break;
            }
            if (Tag.script_DFLT != n4) continue;
            n8 = n5;
        }
        if (n8 == -1) {
            for (n5 = 0; n5 < nArrayArray.length; ++n5) {
                nArrayArray[n5] = new int[0];
            }
            return nArrayArray;
        }
        n5 = this.data.getOffset(n6, 2 + 6 * n8 + 4);
        n4 = this.data.getuint16(n5 + 2);
        int n9 = this.data.getOffset(n5, 0);
        for (n3 = 0; n3 < n4; ++n3) {
            if ((long)n2 != this.data.getuint32(n5 + 4 + 6 * n3)) continue;
            n9 = this.data.getOffset(n5, 4 + 6 * n3 + 4);
            break;
        }
        if (n9 == 0) {
            for (n3 = 0; n3 < nArrayArray.length; ++n3) {
                nArrayArray[n3] = new int[0];
            }
            return nArrayArray;
        }
        n3 = this.getFeatureListOffset();
        for (int i = 0; i < nArray.length; ++i) {
            int n10;
            int n11;
            int n12;
            int n13 = -1;
            if (0 == nArray[i]) {
                n12 = this.data.getuint16(n9 + 2);
                n13 = n12 == 65535 ? -1 : n12;
            } else {
                n12 = this.data.getuint16(n9 + 4);
                for (n11 = 0; n11 < n12; ++n11) {
                    n10 = this.data.getuint16(n9 + 6 + 2 * n11);
                    if ((long)nArray[i] != this.data.getuint32(n3 + 2 + 6 * n10)) continue;
                    n13 = n10;
                }
            }
            if (n13 == -1) {
                nArrayArray[i] = new int[0];
                continue;
            }
            n12 = n3 + this.data.getuint16(n3 + 2 + n13 * 6 + 4);
            n11 = this.data.getuint16(n12 + 2);
            nArrayArray[i] = new int[n11];
            for (n10 = 0; n10 < n11; ++n10) {
                nArrayArray[i][n10] = this.data.getuint16(n12 + 4 + n10 * 2);
            }
            Arrays.sort(nArrayArray[i]);
            n10 = this.getLookupListOffset();
            for (int j = 0; j < n11; ++j) {
                nArrayArray[i][j] = this.data.getOffset(n10, 2 + 2 * nArrayArray[i][j]);
            }
        }
        return nArrayArray;
    }

    public boolean featureIsPresent(int n) throws InvalidFontException {
        int n2 = this.getFeatureListOffset();
        int n3 = this.data.getuint16(n2);
        for (int i = 0; i < n3; ++i) {
            if ((long)n != this.data.getuint32(n2 + 2 + 6 * i)) continue;
            return true;
        }
        return false;
    }

    public int applyLookups(int[] nArray, AttributedRun attributedRun, int n, int n2, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = this.data.getuint16(nArray[i]);
            int n4 = this.data.getuint16(nArray[i] + 2);
            int n5 = this.data.getuint16(nArray[i] + 4);
            int n6 = n;
            while (n6 < n2) {
                if (this.lookupFlagCovers(n4, gdef, attributedRun.elementAt(n6))) {
                    ++n6;
                    continue;
                }
                boolean bl = false;
                for (int j = 0; j < n5 && !bl; ++j) {
                    int n7 = this.data.getOffset(nArray[i], 6 + 2 * j);
                    LookupResult lookupResult = this.applyLookupSubtable(n3, n4, n7, attributedRun, n, n2, n6, oTSelector, gdef);
                    if (!lookupResult.applied) continue;
                    n6 = lookupResult.nextToProcess;
                    n2 += lookupResult.countAdjust;
                    bl = true;
                }
                if (bl) continue;
                ++n6;
            }
        }
        return n2;
    }

    protected abstract LookupResult applyLookupSubtable(int var1, int var2, int var3, AttributedRun var4, int var5, int var6, int var7, OTSelector var8, Gdef var9) throws InvalidFontException;

    protected LookupResult applyContextualSubtable(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getuint16(n2);
        switch (n6) {
            case 1: {
                return this.applyContextualSubtableFormat1(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
            case 2: {
                return this.applyContextualSubtableFormat2(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
            case 3: {
                return this.applyContextualSubtableFormat3(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
        }
        throw new InvalidFontException("Invalid contextual lookup subtable format (" + n6 + ")");
    }

    protected LookupResult applyContextualSubtableFormat1(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getOffset(n2, 2);
        int n7 = n5;
        int n8 = this.getCoverageIndex(attributedRun.elementAt(n7), n6);
        if (n8 == -1) {
            return lookupNotApplied;
        }
        int n9 = n2 + this.data.getuint16(n2 + 6 + n8 * 2);
        int n10 = this.data.getuint16(n9);
        for (int i = 0; i < n10; ++i) {
            int n11 = this.data.getOffset(n9, 2 + 2 * i);
            int[] nArray = this.matchOneRule(n11, n, attributedRun, n3, n4, n7, oTSelector, gdef);
            if (nArray.length == 0 || !oTSelector.isApplied(attributedRun, nArray)) continue;
            int n12 = this.data.getuint16(n11);
            int n13 = this.data.getuint16(n11 + 2);
            int n14 = n11 + 4 + 2 * (n12 - 1);
            return this.applySubLookups(n13, n14, attributedRun, n3, n4, nArray, oTSelector, gdef);
        }
        return lookupNotApplied;
    }

    protected LookupResult applyContextualSubtableFormat2(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getOffset(n2, 2);
        int n7 = this.data.getOffset(n2, 4);
        int n8 = n5;
        if (-1 == this.getCoverageIndex(attributedRun.elementAt(n8), n6)) {
            return lookupNotApplied;
        }
        int n9 = this.getClassIndex(attributedRun.elementAt(n8), n7);
        if (n9 > this.data.getuint16(n2 + 6) - 1) {
            return lookupNotApplied;
        }
        int n10 = this.data.getOffset(n2, 8 + 2 * n9);
        if (n10 == 0) {
            return lookupNotApplied;
        }
        int n11 = this.data.getuint16(n10);
        for (int i = 0; i < n11; ++i) {
            int n12 = this.data.getOffset(n10, 2 + 2 * i);
            int n13 = this.data.getuint16(n12);
            int[] nArray = this.matchOneClassRule(n12, n7, n, attributedRun, n3, n4, n8, oTSelector, gdef);
            if (nArray.length == 0 || !oTSelector.isApplied(attributedRun, nArray)) continue;
            int n14 = this.data.getuint16(n12 + 2);
            int n15 = n12 + 4 + 2 * (n13 - 1);
            return this.applySubLookups(n14, n15, attributedRun, n3, n4, nArray, oTSelector, gdef);
        }
        return lookupNotApplied;
    }

    protected LookupResult applyContextualSubtableFormat3(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6;
        int n7 = this.data.getuint16(n2 + 2);
        int n8 = n5;
        int[] nArray = new int[n7];
        for (n6 = 0; n6 < n7; ++n6) {
            if (n6 != 0) {
                while (n8 < n4 && this.lookupFlagCovers(n, gdef, attributedRun.elementAt(n8))) {
                    ++n8;
                }
            }
            if (n8 >= n4 || -1 == this.getCoverageIndex(attributedRun.elementAt(n8), this.data.getOffset(n2, 6 + 2 * n6))) {
                return lookupNotApplied;
            }
            nArray[n6] = n8++;
        }
        if (!oTSelector.isApplied(attributedRun, nArray)) {
            return lookupNotApplied;
        }
        n6 = this.data.getuint16(n2 + 4);
        int n9 = n2 + 6 + 2 * n7;
        return this.applySubLookups(n6, n9, attributedRun, n3, n4, nArray, oTSelector, gdef);
    }

    int[] matchOneRule(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getuint16(n);
        int[] nArray = new int[n6];
        nArray[0] = n5++;
        for (int i = 1; i < n6; ++i) {
            while (n5 < n4 && this.lookupFlagCovers(n2, gdef, attributedRun.elementAt(n5))) {
                ++n5;
            }
            if (n5 >= n4 || attributedRun.elementAt(n5) != this.data.getuint16(n + 4 + 2 * (i - 1))) {
                return noMatch;
            }
            nArray[i] = n5++;
        }
        return nArray;
    }

    int[] matchOneClassRule(int n, int n2, int n3, AttributedRun attributedRun, int n4, int n5, int n6, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n7 = this.data.getuint16(n);
        int[] nArray = new int[n7];
        nArray[0] = n6++;
        for (int i = 1; i < n7; ++i) {
            while (n6 < n5 && this.lookupFlagCovers(n3, gdef, attributedRun.elementAt(n6))) {
                ++n6;
            }
            if (n6 >= n5 || this.getClassIndex(attributedRun.elementAt(n6), n2) != this.data.getuint16(n + 4 + 2 * (i - 1))) {
                return noMatch;
            }
            nArray[i] = n6++;
        }
        return nArray;
    }

    protected LookupResult applyChainingContextualSubtable(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getuint16(n2);
        switch (n6) {
            case 1: {
                return this.applyChainingContextualSubtableFormat1(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
            case 2: {
                return this.applyChainingContextualSubtableFormat2(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
            case 3: {
                return this.applyChainingContextualSubtableFormat3(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
        }
        throw new InvalidFontException("Invalid ChainingContextualLookupSutable format (" + n6 + ")");
    }

    protected LookupResult applyChainingContextualSubtableFormat1(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getOffset(n2, 2);
        int n7 = n5;
        int n8 = this.getCoverageIndex(attributedRun.elementAt(n7), n6);
        if (n8 == -1) {
            return lookupNotApplied;
        }
        int n9 = this.data.getOffset(n2, 6 + 2 * n8);
        int n10 = this.data.getuint16(n9);
        for (int i = 0; i < n10; ++i) {
            int n11 = this.data.getOffset(n9, 2 + 2 * i);
            int[] nArray = this.matchOneChainRule(n11, n, attributedRun, n3, n4, n7, oTSelector, gdef);
            if (nArray.length == 0 || !oTSelector.isApplied(attributedRun, nArray)) continue;
            int n12 = this.data.getuint16(n11);
            int n13 = this.data.getuint16(n11 + 2 + 2 * n12);
            int n14 = this.data.getuint16(n11 + 4 + 2 * n12 + 2 * (n13 - 1));
            int n15 = n11 + 6 + 2 * n12 + 2 * (n13 - 1) + 2 * n14;
            int n16 = this.data.getuint16(n15);
            int n17 = n15 + 2;
            return this.applySubLookups(n16, n17, attributedRun, n3, n4, nArray, oTSelector, gdef);
        }
        return lookupNotApplied;
    }

    protected LookupResult applyChainingContextualSubtableFormat2(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getOffset(n2, 2);
        int n7 = n5;
        if (-1 == this.getCoverageIndex(attributedRun.elementAt(n7), n6)) {
            return lookupNotApplied;
        }
        int n8 = this.data.getOffset(n2, 4);
        int n9 = this.data.getOffset(n2, 6);
        int n10 = this.data.getOffset(n2, 8);
        int n11 = this.getClassIndex(attributedRun.elementAt(n7), n9);
        if (n11 > this.data.getuint16(n2 + 10) - 1) {
            return lookupNotApplied;
        }
        int n12 = this.data.getOffset(n2, 12 + 2 * n11);
        if (n12 == 0) {
            return lookupNotApplied;
        }
        int n13 = this.data.getuint16(n12);
        for (int i = 0; i < n13; ++i) {
            int n14 = this.data.getOffset(n12, 2 + 2 * i);
            int[] nArray = this.matchOneChainClassRule(n14, n8, n9, n10, n, attributedRun, n3, n4, n7, oTSelector, gdef);
            if (nArray.length == 0 || !oTSelector.isApplied(attributedRun, nArray)) continue;
            int n15 = this.data.getuint16(n14);
            int n16 = this.data.getuint16(n14 + 2 + 2 * n15);
            int n17 = this.data.getuint16(n14 + 4 + 2 * n15 + 2 * (n16 - 1));
            int n18 = n14 + 6 + 2 * n15 + 2 * (n16 - 1) + 2 * n17;
            int n19 = this.data.getuint16(n18);
            int n20 = n18 + 2;
            return this.applySubLookups(n19, n20, attributedRun, n3, n4, nArray, oTSelector, gdef);
        }
        return lookupNotApplied;
    }

    protected LookupResult applyChainingContextualSubtableFormat3(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6;
        int n7 = this.data.getuint16(n2 + 2);
        int n8 = this.data.getuint16(n2 + 4 + 2 * n7);
        int n9 = this.data.getuint16(n2 + 6 + 2 * n7 + 2 * n8);
        int n10 = n5 - 1;
        for (int i = 0; i < n7; ++i) {
            while (n3 <= n10 && this.lookupFlagCovers(n, gdef, attributedRun.elementAt(n10))) {
                --n10;
            }
            if (n10 < n3 || -1 == this.getCoverageIndex(attributedRun.elementAt(n10), this.data.getOffset(n2, 4 + 2 * i))) {
                return lookupNotApplied;
            }
            --n10;
        }
        int[] nArray = new int[n8];
        int n11 = n5;
        for (n6 = 0; n6 < n8; ++n6) {
            if (n6 != 0) {
                while (n11 < n4 && this.lookupFlagCovers(n, gdef, attributedRun.elementAt(n11))) {
                    ++n11;
                }
            }
            if (n4 <= n11 || -1 == this.getCoverageIndex(attributedRun.elementAt(n11), this.data.getOffset(n2, 6 + 2 * n7 + 2 * n6))) {
                return lookupNotApplied;
            }
            nArray[n6] = n11++;
        }
        if (!oTSelector.isApplied(attributedRun, nArray)) {
            return lookupNotApplied;
        }
        for (n6 = 0; n6 < n9; ++n6) {
            while (n11 < n4 && this.lookupFlagCovers(n, gdef, attributedRun.elementAt(n11))) {
                ++n11;
            }
            if (n4 <= n11 || -1 == this.getCoverageIndex(attributedRun.elementAt(n11), this.data.getOffset(n2, 8 + 2 * n7 + 2 * n8 + 2 * n6))) {
                return lookupNotApplied;
            }
            ++n11;
        }
        n6 = n2 + 8 + 2 * n7 + 2 * n8 + 2 * n9;
        int n12 = this.data.getuint16(n6);
        int n13 = n6 + 2;
        return this.applySubLookups(n12, n13, attributedRun, n3, n4, nArray, oTSelector, gdef);
    }

    int[] matchOneChainRule(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6;
        int n7 = this.data.getuint16(n);
        int n8 = this.data.getuint16(n + 2 + 2 * n7);
        int n9 = this.data.getuint16(n + 4 + 2 * n7 + 2 * (n8 - 1));
        int n10 = n5 - 1;
        for (int i = 0; i < n7; ++i) {
            while (n3 <= n10 && this.lookupFlagCovers(n2, gdef, attributedRun.elementAt(n10))) {
                --n10;
            }
            if (n10 < n3 || attributedRun.elementAt(n10) != this.data.getuint16(n + 2 + 2 * i)) {
                return noMatch;
            }
            --n10;
        }
        int[] nArray = new int[n8];
        nArray[0] = n5++;
        for (n6 = 1; n6 < n8; ++n6) {
            while (n5 < n4 && this.lookupFlagCovers(n2, gdef, attributedRun.elementAt(n5))) {
                ++n5;
            }
            if (n4 <= n5 || attributedRun.elementAt(n5) != this.data.getuint16(n + 4 + 2 * n7 + 2 * (n6 - 1))) {
                return noMatch;
            }
            nArray[n6] = n5++;
        }
        for (n6 = 0; n6 < n9; ++n6) {
            while (n5 < n4 && this.lookupFlagCovers(n2, gdef, attributedRun.elementAt(n5))) {
                ++n5;
            }
            if (n4 <= n5 || attributedRun.elementAt(n5) != this.data.getuint16(n + 6 + 2 * n7 + 2 * (n8 - 1) + 2 * n6)) {
                return noMatch;
            }
            ++n5;
        }
        return nArray;
    }

    int[] matchOneChainClassRule(int n, int n2, int n3, int n4, int n5, AttributedRun attributedRun, int n6, int n7, int n8, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n9;
        int n10 = this.data.getuint16(n);
        int n11 = this.data.getuint16(n + 2 + 2 * n10);
        int n12 = this.data.getuint16(n + 4 + 2 * n10 + 2 * (n11 - 1));
        int n13 = n8 - 1;
        for (int i = 0; i < n10; ++i) {
            while (n6 <= n13 && this.lookupFlagCovers(n5, gdef, attributedRun.elementAt(n13))) {
                --n13;
            }
            if (n13 < n6 || this.getClassIndex(attributedRun.elementAt(n13), n2) != this.data.getuint16(n + 2 + 2 * i)) {
                return noMatch;
            }
            --n13;
        }
        int[] nArray = new int[n11];
        nArray[0] = n8++;
        for (n9 = 1; n9 < n11; ++n9) {
            while (n8 < n7 && this.lookupFlagCovers(n5, gdef, attributedRun.elementAt(n8))) {
                ++n8;
            }
            if (n7 <= n8 || this.getClassIndex(attributedRun.elementAt(n8), n3) != this.data.getuint16(n + 4 + 2 * n10 + 2 * (n9 - 1))) {
                return noMatch;
            }
            nArray[n9] = n8++;
        }
        for (n9 = 0; n9 < n12; ++n9) {
            while (n8 < n7 && this.lookupFlagCovers(n5, gdef, attributedRun.elementAt(n8))) {
                ++n8;
            }
            if (n7 <= n8 || this.getClassIndex(attributedRun.elementAt(n8), n4) != this.data.getuint16(n + 6 + 2 * n10 + 2 * (n11 - 1) + 2 * n9)) {
                return noMatch;
            }
            ++n8;
        }
        return nArray;
    }

    protected LookupResult applyExtensionSubtable(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getuint16(n2 + 2);
        int n7 = n2 + (int)this.data.getuint32(n2 + 4);
        return this.applyLookupSubtable(n6, n, n7, attributedRun, n3, n4, n5, oTSelector, gdef);
    }

    protected LookupResult applySubLookups(int n, int n2, AttributedRun attributedRun, int n3, int n4, int[] nArray, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        LookupResult lookupResult = new LookupResult(true, nArray[nArray.length - 1] + 1, 0);
        int n5 = this.getLookupListOffset();
        block0: for (int i = 0; i < n; ++i) {
            int n6 = this.data.getuint16(n2);
            int n7 = this.data.getuint16(n2 + 2);
            n2 += 4;
            int n8 = nArray[n6];
            int n9 = this.data.getOffset(n5, 2 + 2 * n7);
            int n10 = this.data.getuint16(n9);
            int n11 = this.data.getuint16(n9 + 2);
            int n12 = this.data.getuint16(n9 + 4);
            if (this.lookupFlagCovers(n11, gdef, attributedRun.elementAt(n8))) continue;
            for (int j = 0; j < n12; ++j) {
                int n13 = this.data.getOffset(n9, 6 + 2 * j);
                LookupResult lookupResult2 = this.applyLookupSubtable(n10, n11, n13, attributedRun, n3, n4, n8, oTSelector, gdef);
                if (!lookupResult2.applied) continue;
                lookupResult.nextToProcess += lookupResult2.countAdjust;
                lookupResult.countAdjust += lookupResult2.countAdjust;
                continue block0;
            }
        }
        return lookupResult;
    }

    protected static final class LookupResult {
        public boolean applied;
        public int nextToProcess;
        public int countAdjust;

        public LookupResult(boolean bl, int n, int n2) {
            this.applied = bl;
            this.nextToProcess = n;
            this.countAdjust = n2;
        }
    }
}

