/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.DecisionCondition;
import org.jbpm.graph.node.DecisionHandler;
import org.jbpm.instantiation.Delegation;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;

public class Decision
extends Node
implements Parsable {
    static final String NEWLINE = System.getProperty("line.separator");
    static final String DECISION_CONDITION_RESULT = "decision_condition_result";
    static final long serialVersionUID = 1L;
    List decisionConditions = null;
    Delegation decisionDelegation = null;
    String decisionExpression = null;
    private static Log log = LogFactory.getLog((Class)Decision.class);

    public Decision() {
    }

    public Decision(String name) {
        super(name);
    }

    public void read(Element decisionElement, JpdlXmlReader jpdlReader) {
        String expression = decisionElement.attributeValue("expression");
        Element decisionHandlerElement = decisionElement.element("handler");
        if (expression != null) {
            this.decisionExpression = expression;
        } else if (decisionHandlerElement != null) {
            this.decisionDelegation = new Delegation();
            this.decisionDelegation.read(decisionHandlerElement, jpdlReader);
        }
    }

    String getConditionExpression(Element conditionElement) {
        String expression = conditionElement.attributeValue("expression");
        if (expression != null) {
            return expression;
        }
        return conditionElement.getText();
    }

    public void execute(ExecutionContext executionContext) {
        Transition transition = null;
        try {
            if (this.decisionDelegation != null) {
                DecisionHandler decisionHandler = (DecisionHandler)this.decisionDelegation.instantiate();
                String transitionName = decisionHandler.decide(executionContext);
                transition = this.getLeavingTransition(transitionName);
                if (transition == null) {
                    throw new JbpmException("decision '" + this.name + "' selected non existing transition '" + transitionName + "'");
                }
            } else if (this.decisionExpression != null) {
                Object result = JbpmExpressionEvaluator.evaluate(this.decisionExpression, executionContext);
                if (result == null) {
                    throw new JbpmException("decision expression '" + this.decisionExpression + "' returned null");
                }
                String transitionName = result.toString();
                transition = this.getLeavingTransition(transitionName);
                if (transition == null) {
                    throw new JbpmException("decision '" + this.name + "' selected non existing transition '" + transitionName + "'");
                }
            } else if (this.decisionConditions != null && !this.decisionConditions.isEmpty()) {
                Iterator iter = this.decisionConditions.iterator();
                while (iter.hasNext() && transition == null) {
                    DecisionCondition decisionCondition = (DecisionCondition)iter.next();
                    Object result = JbpmExpressionEvaluator.evaluate(decisionCondition.getExpression(), executionContext);
                    if (!Boolean.TRUE.equals(result)) continue;
                    if (transition != null) {
                        transition.removeConditionEnforcement();
                    }
                    String transitionName = decisionCondition.getTransitionName();
                    transition = this.getLeavingTransition(transitionName);
                }
            } else {
                Iterator iter = this.leavingTransitions.iterator();
                while (iter.hasNext() && transition == null) {
                    Object result;
                    Transition candidate = (Transition)iter.next();
                    String conditionExpression = candidate.getCondition();
                    if (conditionExpression == null || !Boolean.TRUE.equals(result = JbpmExpressionEvaluator.evaluate(conditionExpression, executionContext))) continue;
                    transition = candidate;
                }
            }
            if (transition == null) {
                transition = this.getDefaultLeavingTransition();
                log.debug((Object)("decision didn't select transition, taking default " + transition));
            }
            transition.removeConditionEnforcement();
        }
        catch (Exception exception) {
            this.raiseException(exception, executionContext);
        }
        log.debug((Object)("decision " + this.name + " is taking '" + transition + "'"));
        executionContext.leaveNode(transition);
    }

    public List getDecisionConditions() {
        return this.decisionConditions;
    }

    public void setDecisionDelegation(Delegation decisionDelegation) {
        this.decisionDelegation = decisionDelegation;
    }
}

