/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

public class FunctionSignatureNode
extends Node {
    public ParameterListNode parameter;
    public Node result;
    public TypeInfo type = null;
    public ReferenceValue typeref;
    public ListNode inits;
    public boolean no_anno;
    public boolean void_anno;

    public FunctionSignatureNode(ParameterListNode parameterListNode, Node node) {
        this.parameter = parameterListNode;
        this.result = node;
        this.typeref = null;
        this.no_anno = false;
        this.void_anno = false;
    }

    public FunctionSignatureNode(ParameterListNode parameterListNode, ListNode listNode) {
        this.parameter = parameterListNode;
        this.inits = listNode;
        this.typeref = null;
        this.no_anno = false;
        this.void_anno = false;
    }

    public Value evaluate(Context context, Evaluator evaluator) {
        if (evaluator.checkFeature(context, this)) {
            return evaluator.evaluate(context, this);
        }
        return null;
    }

    public int size() {
        return this.parameter != null ? this.parameter.size() : 0;
    }

    public String toString() {
        return "FunctionSignature";
    }

    public StringBuffer toCanonicalString(Context context, StringBuffer stringBuffer) {
        if (this.parameter != null) {
            this.parameter.toCanonicalString(context, stringBuffer);
        }
        stringBuffer.append(" result_type='");
        if (this.result != null) {
            this.result.toCanonicalString(context, stringBuffer);
        } else if (this.void_anno) {
            stringBuffer.append("void");
        } else {
            stringBuffer.append(context.noType().name.toString());
        }
        stringBuffer.append("'");
        return stringBuffer;
    }
}

