/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.util.Iterator;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.RestParameterNode;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.ObjectList;

public class ParameterListNode
extends Node {
    public ObjectList<ParameterNode> items = new ObjectList();
    public ObjectList<TypeInfo> types = new ObjectList(1);
    public ByteList decl_styles = new ByteList(1);
    public int count = -1;

    public ParameterListNode(ParameterListNode parameterListNode, ParameterNode parameterNode, int n) {
        this.items.add(parameterNode);
    }

    public Value evaluate(Context context, Evaluator evaluator) {
        if (evaluator.checkFeature(context, this)) {
            return evaluator.evaluate(context, this);
        }
        return null;
    }

    public int size() {
        if (this.count < 0) {
            this.count = 0;
            Iterator iterator = this.items.iterator();
            while (iterator.hasNext()) {
                ParameterNode parameterNode = (ParameterNode)iterator.next();
                this.count += parameterNode.size();
            }
        }
        return this.count;
    }

    public String toString() {
        return "ParameterList";
    }

    public StringBuffer toCanonicalString(Context context, StringBuffer stringBuffer) {
        ParameterNode parameterNode;
        stringBuffer.append(" param_names='");
        ParameterNode parameterNode2 = (ParameterNode)this.items.get(0);
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            parameterNode = (ParameterNode)iterator.next();
            if (parameterNode != parameterNode2) {
                stringBuffer.append(";");
            }
            stringBuffer.append(parameterNode.ref != null ? parameterNode.ref.name : "");
        }
        stringBuffer.append("'");
        stringBuffer.append(" param_types='");
        parameterNode2 = (ParameterNode)this.items.get(0);
        iterator = this.items.iterator();
        while (iterator.hasNext()) {
            parameterNode = (ParameterNode)iterator.next();
            if (parameterNode != parameterNode2) {
                stringBuffer.append(";");
            }
            if (parameterNode instanceof RestParameterNode) {
                stringBuffer.append("restParam");
                continue;
            }
            if (parameterNode.typeref == null) continue;
            Slot slot = parameterNode.typeref.getSlot(context, -78);
            stringBuffer.append(slot == null || slot.getDebugName().length() == 0 ? parameterNode.typeref.name : slot.getDebugName());
        }
        stringBuffer.append("'");
        stringBuffer.append(" param_defaults='");
        parameterNode2 = (ParameterNode)this.items.get(0);
        iterator = this.items.iterator();
        while (iterator.hasNext()) {
            parameterNode = (ParameterNode)iterator.next();
            if (parameterNode != parameterNode2) {
                stringBuffer.append(";");
            }
            if (parameterNode.init == null) {
                stringBuffer.append("undefined");
                continue;
            }
            if (parameterNode.init instanceof LiteralNumberNode) {
                stringBuffer.append(((LiteralNumberNode)parameterNode.init).value);
                continue;
            }
            if (parameterNode.init instanceof LiteralStringNode) {
                stringBuffer.append(DocCommentNode.escapeXml(((LiteralStringNode)parameterNode.init).value));
                continue;
            }
            if (parameterNode.init instanceof LiteralNullNode) {
                stringBuffer.append("null");
                continue;
            }
            if (parameterNode.init instanceof LiteralBooleanNode) {
                stringBuffer.append(((LiteralBooleanNode)parameterNode.init).value ? "true" : "false");
                continue;
            }
            stringBuffer.append("unknown");
        }
        stringBuffer.append("'");
        return stringBuffer;
    }
}

