/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.CharUtil;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTSelector;
import com.adobe.fontengine.font.opentype.OTSelectorOnElementAttribute;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.Tag;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.infontformatting.GenericFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.InFontFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.LookupsCache;
import java.util.ArrayList;

abstract class IndicFormatter
extends GenericFormatter {
    private static final ElementAttribute indicShape = new ElementAttribute("indicShape");
    private static final OTSelector everywhere = new OTSelector();
    private static final OTSelector akhnSelector = new OTSelector(){

        public boolean isApplied(AttributedRun attributedRun, int n) {
            Object object = attributedRun.getElementStyle(n, indicShape);
            return object != Shape.explicitVirama && object != Shape.half;
        }
    };
    private static final OTSelector rphfSelector = new OTSelector(){

        public boolean isApplied(AttributedRun attributedRun, int n) {
            Object object = attributedRun.getElementStyle(n, indicShape);
            return object == Shape.rephCons || object == Shape.rephVowel;
        }
    };
    private static final OTSelector blwfSelector = new OTSelectorOnElementAttribute(indicShape, Shape.subjoins, true);
    private static final OTSelector pstfSelector = new OTSelectorOnElementAttribute(indicShape, Shape.postjoins, true);
    private static final OTSelector halfSelector = new OTSelector(){

        public boolean isApplied(AttributedRun attributedRun, int n) {
            Object object = attributedRun.getElementStyle(n, indicShape);
            return object != Shape.explicitVirama;
        }
    };
    static final int[] gsubFeatures = new int[]{Tag.feature_nukt, Tag.feature_akhn, Tag.feature_rphf, Tag.feature_blwf, Tag.feature_half, Tag.feature_vatu, Tag.feature_pres, Tag.feature_abvs, Tag.feature_blws, Tag.feature_psts, Tag.feature_haln, Tag.feature_pstf};
    static final int[] gposFeatures = new int[]{Tag.feature_abvm, Tag.feature_blwm, Tag.feature_dist};

    IndicFormatter() {
    }

    protected abstract int nukta();

    protected abstract int virama();

    protected abstract int splitVowelsAndNormalize(AttributedRun var1, int var2, int var3);

    protected abstract Position getPosition(int var1);

    protected abstract boolean isConsonant(int var1);

    protected abstract boolean hasNukta(int var1);

    protected abstract int removeNukta(int var1);

    protected abstract boolean isMark(int var1);

    protected abstract boolean isIndependentVowel(int var1);

    protected abstract Shape rephLike(int var1);

    protected abstract boolean subjoins(int var1);

    protected abstract boolean postjoins(int var1);

    protected abstract boolean postjoinsIndependentVowels(int var1);

    private int processAksaraMarks(AttributedRun attributedRun, int n, int n2, Aksara aksara) {
        aksara.firstMark = n;
        while (n < n2 && this.isMark(attributedRun.elementAt(n))) {
            ++n;
        }
        aksara.limit = n;
        return n;
    }

    private int processAksaras(AttributedRun attributedRun, int n, int n2, OpenTypeFont openTypeFont) throws InvalidFontException, UnsupportedFontException {
        Aksara aksara = new Aksara();
        while (n < n2) {
            aksara.reset();
            aksara.start = n;
            if (this.isConsonant(attributedRun.elementAt(n))) {
                Object object;
                AksaraPart aksaraPart;
                while (n < n2 && this.isConsonant(attributedRun.elementAt(n))) {
                    aksaraPart = new AksaraPart();
                    aksaraPart.shape = Shape.live;
                    if (this.hasNukta(attributedRun.elementAt(n))) {
                        aksaraPart.nuktaCount = 1;
                        aksaraPart.usv = this.removeNukta(attributedRun.elementAt(n));
                    } else {
                        aksaraPart.nuktaCount = 0;
                        aksaraPart.usv = attributedRun.elementAt(n);
                    }
                    ++n;
                    while (n < n2 && this.nukta() == attributedRun.elementAt(n)) {
                        ++aksaraPart.nuktaCount;
                        ++n;
                    }
                    if (n < n2 && this.virama() == attributedRun.elementAt(n)) {
                        aksaraPart.shape = Shape.dead;
                        if (++n < n2 && 8205 == attributedRun.elementAt(n)) {
                            aksaraPart.shape = Shape.half;
                            ++n;
                        } else if (n < n2 && 8204 == attributedRun.elementAt(n)) {
                            aksaraPart.shape = Shape.explicitVirama;
                            ++n;
                        }
                    }
                    aksara.parts.add(aksaraPart);
                    if (aksaraPart.shape != Shape.live) continue;
                }
                if (aksara.parts.size() > 1) {
                    aksaraPart = (AksaraPart)aksara.parts.get(0);
                    object = this.rephLike(aksaraPart.usv);
                    if (object != Shape.any && aksaraPart.shape == Shape.dead) {
                        aksaraPart.shape = object;
                    }
                }
                for (int i = 1; i < aksara.parts.size(); ++i) {
                    object = (AksaraPart)aksara.parts.get(i);
                    AksaraPart aksaraPart2 = (AksaraPart)aksara.parts.get(i - 1);
                    if (!this.subjoins(((AksaraPart)object).usv) || ((AksaraPart)object).shape != Shape.dead && ((AksaraPart)object).shape != Shape.live || aksaraPart2.shape != Shape.dead) continue;
                    if (((AksaraPart)object).shape == Shape.live) {
                        aksaraPart2.shape = Shape.live;
                    }
                    ((AksaraPart)object).shape = Shape.subjoins;
                }
                if (aksara.parts.size() > 1) {
                    AksaraPart aksaraPart3 = (AksaraPart)aksara.parts.get(aksara.parts.size() - 1);
                    object = (AksaraPart)aksara.parts.get(aksara.parts.size() - 2);
                    if (this.postjoins(aksaraPart3.usv) && (aksaraPart3.shape == Shape.dead || aksaraPart3.shape == Shape.live) && ((AksaraPart)object).shape == Shape.dead) {
                        if (aksaraPart3.shape == Shape.live) {
                            ((AksaraPart)object).shape = Shape.live;
                        }
                        aksaraPart3.shape = Shape.postjoins;
                    }
                }
                n = this.processAksaraMarks(attributedRun, n, n2, aksara);
            } else if (this.isIndependentVowel(attributedRun.elementAt(n))) {
                AksaraPart aksaraPart = new AksaraPart();
                aksaraPart.shape = Shape.live;
                aksaraPart.usv = attributedRun.elementAt(n);
                aksaraPart.nuktaCount = 0;
                aksara.parts.add(aksaraPart);
                ++n;
                while (n + 1 < n2 && this.virama() == attributedRun.elementAt(n) && this.postjoinsIndependentVowels(attributedRun.elementAt(n + 1))) {
                    aksaraPart = new AksaraPart();
                    aksaraPart.shape = Shape.postjoins;
                    aksaraPart.usv = attributedRun.elementAt(n + 1);
                    aksaraPart.nuktaCount = 0;
                    aksara.parts.add(aksaraPart);
                    n += 2;
                }
                n = this.processAksaraMarks(attributedRun, n, n2, aksara);
            } else {
                AksaraPart aksaraPart = new AksaraPart();
                aksaraPart.shape = Shape.live;
                aksaraPart.usv = attributedRun.elementAt(n);
                aksaraPart.nuktaCount = 0;
                aksara.parts.add(aksaraPart);
                aksara.firstMark = ++n;
                aksara.limit = n;
            }
            int n3 = aksara.toGlyphs(attributedRun, openTypeFont);
            n2 += n3 - n;
            n = n3;
        }
        return n2;
    }

    protected int canRenderWithFont(OpenTypeFont openTypeFont, AttributedRun attributedRun, int n, int n2, boolean bl) throws InvalidFontException, UnsupportedFontException {
        int n3;
        int n4;
        int n5;
        int n6 = attributedRun.elementAt(n);
        if (CharUtil.isControl(n6)) {
            return 1;
        }
        if (!CharUtil.isBase(n6) || n + 1 == n2 || attributedRun.getElementStyle(n + 1, ElementAttribute.isGlyph) == Boolean.TRUE || !CharUtil.isCombining(attributedRun.elementAt(n + 1))) {
            int n7 = openTypeFont.getGlyphForChar(n6);
            return n7 == 0 ? 0 : n + 1;
        }
        for (n5 = n + 1; n5 < n2 && attributedRun.getElementStyle(n5, ElementAttribute.isGlyph) == Boolean.FALSE && CharUtil.isCombining(attributedRun.elementAt(n5)); ++n5) {
        }
        boolean bl2 = false;
        int[] nArray = new int[n5 - n];
        int[] nArray2 = new int[n5 - n];
        for (n4 = n; n4 < n5; ++n4) {
            nArray[n4 - n] = attributedRun.elementAt(n4);
            n3 = openTypeFont.getGlyphForChar(nArray[n4 - n]);
            if (n3 == 0) {
                bl2 = true;
            }
            nArray2[n4 - n] = n3;
        }
        if (bl2 && (n4 = CharUtil.compose(nArray, 0, n5 - n)) != -1 && (n3 = openTypeFont.getGlyphForChar(n4)) != 0) {
            return n5 - n;
        }
        if (bl) {
            return n5 - n;
        }
        return 0;
    }

    protected int formatOT(OpenTypeFont openTypeFont, AttributedRun attributedRun, int n, int n2, boolean bl) throws InvalidFontException, UnsupportedFontException {
        int[][] nArray;
        int n3 = IndicFormatter.getOTScriptTag((Integer)attributedRun.getElementStyle(n, InFontFormatter.scriptAttribute));
        int n4 = IndicFormatter.getOTLanguageTag((ULocale)attributedRun.getElementStyle(n, ElementAttribute.locale));
        n2 = this.splitVowelsAndNormalize(attributedRun, n, n2);
        n2 = this.processAksaras(attributedRun, n, n2, openTypeFont);
        if (openTypeFont.gsub != null) {
            nArray = LookupsCache.resolveFeatureTag(openTypeFont.gsub, n3, n4, gsubFeatures);
            n2 = openTypeFont.gsub.applyLookups(nArray[0], attributedRun, n, n2, everywhere, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[1], attributedRun, n, n2, akhnSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[2], attributedRun, n, n2, rphfSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[3], attributedRun, n, n2, blwfSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[11], attributedRun, n, n2, pstfSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[4], attributedRun, n, n2, halfSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[5], attributedRun, n, n2, everywhere, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[6], attributedRun, n, n2, everywhere, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[7], attributedRun, n, n2, everywhere, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[8], attributedRun, n, n2, everywhere, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[9], attributedRun, n, n2, everywhere, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[10], attributedRun, n, n2, everywhere, openTypeFont.gdef);
        }
        this.posFromAdvanceWidth(attributedRun, openTypeFont, n, n2);
        if (openTypeFont.gpos != null) {
            nArray = LookupsCache.resolveFeatureTag(openTypeFont.gpos, n3, n4, gposFeatures);
            n2 = openTypeFont.gpos.applyLookups(nArray[0], attributedRun, n, n2, everywhere, openTypeFont.gdef);
            n2 = openTypeFont.gpos.applyLookups(nArray[1], attributedRun, n, n2, everywhere, openTypeFont.gdef);
            n2 = openTypeFont.gpos.applyLookups(nArray[2], attributedRun, n, n2, everywhere, openTypeFont.gdef);
        }
        return n2;
    }

    final class Aksara {
        public int start;
        public int firstMark;
        public int limit;
        public ArrayList parts;

        public Aksara() {
            this.reset();
        }

        public void reset() {
            this.parts = new ArrayList();
        }

        public int nbGlyphs() {
            int n = this.limit - this.firstMark;
            for (int i = 0; i < this.parts.size(); ++i) {
                n += ((AksaraPart)this.parts.get(i)).nbGlyphs();
            }
            return n;
        }

        public int addGlyph(int[] nArray, Shape[] shapeArray, int n, int n2, Shape shape, OpenTypeFont openTypeFont) throws InvalidFontException, UnsupportedFontException {
            nArray[n] = openTypeFont.getGlyphForChar(n2);
            shapeArray[n] = shape;
            return n + 1;
        }

        public int toGlyphs(AttributedRun attributedRun, OpenTypeFont openTypeFont) throws InvalidFontException, UnsupportedFontException {
            int n;
            int n2;
            int[] nArray = new int[this.nbGlyphs()];
            Shape[] shapeArray = new Shape[nArray.length];
            int n3 = 0;
            for (int i = this.firstMark; i < this.limit; ++i) {
                int n4 = attributedRun.elementAt(i);
                if (IndicFormatter.this.getPosition(n4) != Position.left) continue;
                n3 = this.addGlyph(nArray, shapeArray, n3, n4, Shape.any, openTypeFont);
            }
            AksaraPart aksaraPart = null;
            AksaraPart aksaraPart2 = null;
            for (n2 = 0; n2 < this.parts.size(); ++n2) {
                AksaraPart aksaraPart3 = (AksaraPart)this.parts.get(n2);
                if (aksaraPart == null) {
                    aksaraPart = aksaraPart3;
                }
                aksaraPart2 = aksaraPart3;
                if (aksaraPart3.shape == Shape.rephCons || aksaraPart3.shape == Shape.rephVowel || aksaraPart3.shape == Shape.postjoins) continue;
                n3 = aksaraPart3.toGlyphs(nArray, shapeArray, n3, openTypeFont);
            }
            for (n2 = this.firstMark; n2 < this.limit; ++n2) {
                int n5 = attributedRun.elementAt(n2);
                if (IndicFormatter.this.getPosition(n5) != Position.bottom) continue;
                n3 = this.addGlyph(nArray, shapeArray, n3, n5, Shape.any, openTypeFont);
            }
            for (n2 = this.firstMark; n2 < this.limit; ++n2) {
                int n6 = attributedRun.elementAt(n2);
                if (IndicFormatter.this.getPosition(n6) != Position.topMatra) continue;
                n3 = this.addGlyph(nArray, shapeArray, n3, n6, Shape.any, openTypeFont);
            }
            if (aksaraPart.shape == Shape.rephCons) {
                n3 = aksaraPart.toGlyphs(nArray, shapeArray, n3, openTypeFont);
            }
            if (aksaraPart2.shape == Shape.postjoins) {
                n3 = aksaraPart2.toGlyphs(nArray, shapeArray, n3, openTypeFont);
            }
            for (n2 = this.firstMark; n2 < this.limit; ++n2) {
                int n7 = attributedRun.elementAt(n2);
                if (IndicFormatter.this.getPosition(n7) != Position.rightMatra) continue;
                n3 = this.addGlyph(nArray, shapeArray, n3, n7, Shape.any, openTypeFont);
            }
            if (aksaraPart.shape == Shape.rephVowel) {
                n3 = aksaraPart.toGlyphs(nArray, shapeArray, n3, openTypeFont);
            }
            for (n2 = this.firstMark; n2 < this.limit; ++n2) {
                int n8 = attributedRun.elementAt(n2);
                if (IndicFormatter.this.getPosition(n8) != Position.topOther) continue;
                n3 = this.addGlyph(nArray, shapeArray, n3, n8, Shape.any, openTypeFont);
            }
            for (n2 = this.firstMark; n2 < this.limit; ++n2) {
                int n9 = attributedRun.elementAt(n2);
                if (IndicFormatter.this.getPosition(n9) != Position.rightOther) continue;
                n3 = this.addGlyph(nArray, shapeArray, n3, n9, Shape.any, openTypeFont);
            }
            int[] nArray2 = new int[this.limit - this.start];
            for (n = 0; n < nArray2.length; ++n) {
                nArray2[n] = this.start + n;
            }
            attributedRun.replace(nArray2, nArray);
            attributedRun.setElementStyle(this.start, this.start + nArray.length, ElementAttribute.isGlyph, Boolean.TRUE);
            for (n = 0; n < nArray.length; ++n) {
                attributedRun.setElementStyle(this.start + n, indicShape, shapeArray[n]);
            }
            return this.start + nArray.length;
        }
    }

    final class AksaraPart {
        public int usv;
        public int nuktaCount;
        public Shape shape;

        AksaraPart() {
        }

        public int nbGlyphs() {
            return 1 + this.nuktaCount + (this.shape != Shape.live ? 1 : 0);
        }

        public int addGlyph(int[] nArray, Shape[] shapeArray, int n, int n2, Shape shape, OpenTypeFont openTypeFont) throws InvalidFontException, UnsupportedFontException {
            nArray[n] = openTypeFont.getGlyphForChar(n2);
            shapeArray[n] = shape;
            return n + 1;
        }

        public int toGlyphs(int[] nArray, Shape[] shapeArray, int n, OpenTypeFont openTypeFont) throws InvalidFontException, UnsupportedFontException {
            n = this.addGlyph(nArray, shapeArray, n, this.usv, this.shape, openTypeFont);
            for (int i = 0; i < this.nuktaCount; ++i) {
                n = this.addGlyph(nArray, shapeArray, n, IndicFormatter.this.nukta(), Shape.any, openTypeFont);
            }
            if (this.shape != Shape.live) {
                n = this.addGlyph(nArray, shapeArray, n, IndicFormatter.this.virama(), this.shape, openTypeFont);
            }
            return n;
        }
    }

    public static final class Position {
        private String name;
        public static final Position any = new Position("any");
        public static final Position left = new Position("left");
        public static final Position topMatra = new Position("topMatra");
        public static final Position topOther = new Position("topOther");
        public static final Position bottom = new Position("bottom");
        public static final Position rightMatra = new Position("rightMatra");
        public static final Position rightOther = new Position("rightOther");

        private Position(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class Shape {
        private String name;
        public static final Shape any = new Shape("any");
        public static final Shape live = new Shape("live");
        public static final Shape dead = new Shape("dead");
        public static final Shape half = new Shape("half");
        public static final Shape explicitVirama = new Shape("explicitVirama");
        public static final Shape rephCons = new Shape("rephCons");
        public static final Shape rephVowel = new Shape("rephVowel");
        public static final Shape vattu = new Shape("vattu");
        public static final Shape subjoins = new Shape("subjoins");
        public static final Shape postjoins = new Shape("postjoins");

        private Shape(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

