/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.math;

import com.adobe.agl.text.DecimalFormat;

public final class F26Dot6 {
    public static final int ZERO = 0;
    public static final int ONE = 64;
    public static final int ONE_HALF = 32;
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final int MIN_VALUE = Integer.MIN_VALUE;
    private static final DecimalFormat df = new DecimalFormat("0.##");

    public static int truncate(int n) {
        return n & 0xFFFFFFC0;
    }

    public static int ceiling(int n) {
        return F26Dot6.truncate(n + 64 - 1);
    }

    public static int floor(int n) {
        return F26Dot6.truncate(n);
    }

    public static int round(int n) {
        return F26Dot6.truncate(n + 32);
    }

    public static int roundHalfUp(int n) {
        return F26Dot6.truncate(n + 32);
    }

    public static int roundHalfDown(int n) {
        return F26Dot6.truncate(n + 32 - 1);
    }

    public static int negate(int n) {
        return -n;
    }

    public static int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static int add(int n, int n2) {
        return n + n2;
    }

    public static int subtract(int n, int n2) {
        return n - n2;
    }

    private static int clamp(long l) {
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }

    public static int multiply(int n, int n2) {
        return F26Dot6.clamp((long)n * (long)n2 >> 6);
    }

    public static int divide(int n, int n2) {
        return (int)((long)n << 6) / n2;
    }

    public static int multiplyByF2Dot14(int n, int n2) {
        return F26Dot6.clamp(((long)n * (long)((short)n2) >> 13) + 1L >> 1);
    }

    public static int divideByF2Dot14(int n, int n2) {
        return (int)((long)n << 14) / n2;
    }

    public static int multiplyByF16Dot16(int n, int n2) {
        return F26Dot6.clamp(((long)n * (long)n2 >> 15) + 1L >> 1);
    }

    public static int divideByF16Dot16(int n, int n2) {
        return (int)(((long)n << 16) / (long)n2);
    }

    public static int multiplyDivide(int n, int n2, int n3) {
        long l = (long)n * (long)n2;
        long l2 = n3;
        boolean bl = false;
        if (l < 0L) {
            l = -l;
            boolean bl2 = bl = !bl;
        }
        if (l2 < 0L) {
            l2 = -l2;
            bl = !bl;
        }
        long l3 = (l + l2 / 2L) / l2;
        if (bl) {
            return F26Dot6.clamp(-l3);
        }
        return F26Dot6.clamp(l3);
    }

    public static int multiplyByF2Dot14DivideByF2Dot14(int n, int n2, int n3) {
        return F26Dot6.multiplyDivide(n, n2, n3);
    }

    public static boolean isEven(int n) {
        return (n & 0x40) == 0;
    }

    public static boolean sameSign(int n, int n2) {
        return (n & Integer.MIN_VALUE) == (n2 & Integer.MIN_VALUE);
    }

    public static int min(int n, int n2) {
        return Math.min(n, n2);
    }

    public static int max(int n, int n2) {
        return Math.max(n, n2);
    }

    public static double toDouble(int n) {
        return (double)n / 64.0;
    }

    public static int fromDouble(double d) {
        return (int)Math.round(d * 64.0);
    }

    public static int toInt(int n) {
        return n >> 6;
    }

    public static int fromInt(int n) {
        return n << 6;
    }

    public static String toString(int n) {
        return df.format(F26Dot6.toDouble(n));
    }
}

