/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.IteratingOutlineConsumer;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import java.util.Iterator;

class ComparingOutlineConsumer
implements OutlineConsumer {
    Iterator compareTo;
    boolean compares = true;
    boolean hasOutlines = false;

    ComparingOutlineConsumer(IteratingOutlineConsumer iteratingOutlineConsumer) {
        this.compareTo = iteratingOutlineConsumer.iterator();
    }

    boolean equals() {
        return this.compares;
    }

    private boolean close(double d, double d2) {
        return Math.abs(d - d2) < 0.001;
    }

    public void curveto(double d, double d2, double d3, double d4, double d5, double d6) {
        this.hasOutlines = true;
        if (!this.compares) {
            return;
        }
        if (!this.compareTo.hasNext()) {
            this.compares = false;
            return;
        }
        IteratingOutlineConsumer.Element element = (IteratingOutlineConsumer.Element)this.compareTo.next();
        if (element.type != IteratingOutlineConsumer.ElementType.cube) {
            this.compares = false;
            return;
        }
        if (this.close(d, element.x1) && this.close(d2, element.y1) && this.close(d3, element.x2) && this.close(d4, element.y2) && this.close(d5, element.x3) && this.close(d6, element.y3)) {
            return;
        }
        this.compares = false;
    }

    public void curveto(double d, double d2, double d3, double d4) {
        this.hasOutlines = true;
        if (!this.compares) {
            return;
        }
        if (!this.compareTo.hasNext()) {
            this.compares = false;
            return;
        }
        IteratingOutlineConsumer.Element element = (IteratingOutlineConsumer.Element)this.compareTo.next();
        if (element.type != IteratingOutlineConsumer.ElementType.quad) {
            this.compares = false;
            return;
        }
        if (this.close(d, element.x1) && this.close(d2, element.y1) && this.close(d3, element.x2) && this.close(d4, element.y2)) {
            return;
        }
        this.compares = false;
    }

    public void endchar() {
        while (this.compareTo.hasNext()) {
            IteratingOutlineConsumer.Element element = (IteratingOutlineConsumer.Element)this.compareTo.next();
            if (element.type == IteratingOutlineConsumer.ElementType.move) continue;
            this.compares = false;
            return;
        }
    }

    private void compare1point(IteratingOutlineConsumer.ElementType elementType, double d, double d2) {
        if (!this.compares) {
            return;
        }
        if (!this.compareTo.hasNext()) {
            this.compares = false;
            return;
        }
        IteratingOutlineConsumer.Element element = (IteratingOutlineConsumer.Element)this.compareTo.next();
        if (element.type != elementType) {
            this.compares = false;
            return;
        }
        if (this.close(d, element.x1) && this.close(d2, element.y1)) {
            return;
        }
        this.compares = false;
    }

    public void lineto(double d, double d2) {
        this.hasOutlines = true;
        this.compare1point(IteratingOutlineConsumer.ElementType.line, d, d2);
    }

    public void moveto(double d, double d2) {
        this.compare1point(IteratingOutlineConsumer.ElementType.move, d, d2);
    }

    public void setMatrix(Matrix matrix) {
    }
}

