/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.HintedOutlineConsumer;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.Dict;
import com.adobe.fontengine.font.postscript.SubArrays;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class Type2CStringGenerator
implements HintedOutlineConsumer {
    private static final int MAX_STACK = 48;
    private static final int MAX_STEMS = 96;
    private static final int STANDARD_FLEX_DEPTH = 50;
    public static final double DEFAULT_NOMINAL_WIDTH = 0.0;
    public static final double DEFAULT_DEFAULT_WIDTH = 0.0;
    private static final double BOTTOM_EDGE = -21.0;
    private static final double TOP_EDGE = -20.0;
    private int currCStringIndex = 0;
    GlyphInfo[] glyphs;
    private boolean[] widthsAnalyzed;
    private double[] nominalWidth;
    private double[] defaultWidth;
    private double currentX;
    private double currentY;
    private int startOfSeqOp;
    private boolean moveToSeen;
    private int lastOpCode;
    private int stackCount;
    private double[] stack = new double[48];
    private int hintMaskIndex;
    private boolean hintMaskSeen;
    private boolean cntrMaskSeen;
    private byte[] hintmask = new byte[12];
    private byte[] cntrmask = new byte[12];

    public Type2CStringGenerator(int n, int n2) {
        this.glyphs = new GlyphInfo[n];
        this.widthsAnalyzed = new boolean[n2];
        this.nominalWidth = new double[n2];
        this.defaultWidth = new double[n2];
        for (int i = 0; i < n2; ++i) {
            this.nominalWidth[i] = 0.0;
            this.defaultWidth[i] = 0.0;
        }
        this.resetState();
    }

    private void resetState() {
        this.moveToSeen = false;
        this.lastOpCode = 0;
        this.stackCount = 0;
        this.currentX = 0.0;
        this.currentY = 0.0;
        this.startOfSeqOp = 0;
        this.hintMaskSeen = false;
        this.cntrMaskSeen = false;
        this.hintMaskIndex = -1;
        Arrays.fill(this.hintmask, (byte)0);
        Arrays.fill(this.cntrmask, (byte)0);
    }

    private void stackToCString() {
        if (this.stackCount != 0) {
            for (int i = 0; i < this.stackCount; ++i) {
                this.glyphs[this.currCStringIndex].tmpcstr.numToCString(this.stack[i]);
            }
            this.stackCount = 0;
        }
        switch (this.lastOpCode) {
            case 6: 
            case 7: 
            case 30: 
            case 31: {
                this.glyphs[this.currCStringIndex].tmpcstr.addByte(this.startOfSeqOp);
                break;
            }
            default: {
                this.glyphs[this.currCStringIndex].tmpcstr.addByte(this.lastOpCode);
            }
        }
        this.lastOpCode = 0;
    }

    private void ensureStackSpace(int n) {
        if (this.stackCount + n > 48) {
            this.stackToCString();
        }
    }

    public void newGlyph(int n, int n2, double d, double d2) {
        this.resetState();
        this.currCStringIndex = n;
        this.glyphs[n] = new GlyphInfo(n2, d);
        this.defaultWidth[n2] = d;
        this.nominalWidth[n2] = d2;
    }

    private void newHintMask() {
        if (this.lastOpCode == 0 && this.hintMaskIndex == this.glyphs[this.currCStringIndex].tmpcstr.cstrLen) {
            Arrays.fill(this.hintmask, (byte)0);
        } else {
            if (this.lastOpCode != 0) {
                this.stackToCString();
            }
            if (this.hintMaskSeen) {
                HintMask hintMask = new HintMask(this.hintMaskIndex, this.hintmask);
                this.glyphs[this.currCStringIndex].hintMasks.add(this.glyphs[this.currCStringIndex].hintMasks.size(), hintMask);
                Arrays.fill(this.hintmask, (byte)0);
            } else {
                this.hintMaskSeen = true;
            }
            this.hintMaskIndex = this.glyphs[this.currCStringIndex].tmpcstr.cstrLen;
        }
    }

    private void newCntrMask() {
        if (this.lastOpCode != 0) {
            this.stackToCString();
        }
        if (this.cntrMaskSeen) {
            CntrMask cntrMask = new CntrMask(this.cntrmask);
            this.glyphs[this.currCStringIndex].cntrMasks.add(this.glyphs[this.currCStringIndex].cntrMasks.size(), cntrMask);
            Arrays.fill(this.cntrmask, (byte)0);
        } else {
            this.cntrMaskSeen = true;
        }
    }

    private void addIdToMask(int n, byte[] byArray) {
        int n2 = n / 8;
        byArray[n2] = (byte)(byArray[n2] | 1 << n % 8);
    }

    private void checkForNewHintMask(boolean bl) {
        if (this.moveToSeen && (bl || this.glyphs[this.currCStringIndex].hints.size() == 0) || !this.moveToSeen && bl && this.glyphs[this.currCStringIndex].hints.size() > 0) {
            this.newHintMask();
        }
    }

    private void checkForNewCntrMask(boolean bl) {
        if (!this.cntrMaskSeen || bl) {
            this.newCntrMask();
        }
    }

    private void cntrHint(double d, double d2, boolean bl) {
        int n = this.glyphs[this.currCStringIndex].findHint(d, d2, bl, true);
        this.addIdToMask(n, this.cntrmask);
        if (this.hintMaskSeen) {
            this.addIdToMask(n, this.hintmask);
        } else {
            this.addIdToMask(n, this.glyphs[this.currCStringIndex].initMask);
        }
    }

    public void setMatrix(Matrix matrix) {
    }

    public void stem(double d, double d2, boolean bl, boolean bl2, boolean bl3) {
        if (!bl3) {
            this.checkForNewHintMask(bl);
        }
        int n = this.glyphs[this.currCStringIndex].findHint(d, d2, bl2, bl3);
        if (bl3) {
            this.checkForNewCntrMask(bl);
            this.addIdToMask(n, this.cntrmask);
        } else if (this.hintMaskSeen) {
            this.addIdToMask(n, this.hintmask);
        } else {
            this.addIdToMask(n, this.glyphs[this.currCStringIndex].initMask);
        }
    }

    public void stem3(double d, double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2) {
        this.checkForNewHintMask(bl);
        this.checkForNewCntrMask(false);
        this.cntrHint(d, d2, bl2);
        this.cntrHint(d3, d4, bl2);
        this.cntrHint(d5, d6, bl2);
    }

    public boolean width(double d) {
        this.glyphs[this.currCStringIndex].setWidth(d, this.nominalWidth);
        return true;
    }

    public void globalColorOn() {
        if (this.lastOpCode != 0) {
            this.stackToCString();
        }
        this.glyphs[this.currCStringIndex].tmpcstr.addByte(12);
        this.glyphs[this.currCStringIndex].tmpcstr.addByte(38);
    }

    public void noCounters() {
        this.newCntrMask();
    }

    public void noHints() {
        this.newHintMask();
    }

    public void lineto(double d, double d2) {
        if (!this.moveToSeen) {
            this.moveto(0.0, 0.0);
        }
        double d3 = d - this.currentX;
        double d4 = d2 - this.currentY;
        this.currentX = d;
        this.currentY = d2;
        if (d3 == 0.0) {
            this.ensureStackSpace(1);
            switch (this.lastOpCode) {
                default: {
                    this.stackToCString();
                }
                case 0: {
                    this.startOfSeqOp = 7;
                }
                case 6: 
            }
            this.stack[this.stackCount++] = d4;
            this.lastOpCode = 7;
        } else if (d4 == 0.0) {
            this.ensureStackSpace(1);
            switch (this.lastOpCode) {
                default: {
                    this.stackToCString();
                }
                case 0: {
                    this.startOfSeqOp = 6;
                }
                case 7: 
            }
            this.stack[this.stackCount++] = d3;
            this.lastOpCode = 6;
        } else {
            this.ensureStackSpace(2);
            switch (this.lastOpCode) {
                case 5: {
                    this.stack[this.stackCount++] = d3;
                    this.stack[this.stackCount++] = d4;
                    break;
                }
                case 8: {
                    this.stack[this.stackCount++] = d3;
                    this.stack[this.stackCount++] = d4;
                    this.lastOpCode = 24;
                    this.stackToCString();
                    break;
                }
                default: {
                    this.stackToCString();
                }
                case 0: {
                    this.stack[this.stackCount++] = d3;
                    this.stack[this.stackCount++] = d4;
                    this.lastOpCode = 5;
                }
            }
        }
    }

    private void addVHCurveTo(double d, double d2, double d3, double d4) {
        this.ensureStackSpace(4);
        switch (this.lastOpCode) {
            default: {
                this.stackToCString();
            }
            case 0: {
                this.startOfSeqOp = 30;
            }
            case 31: 
        }
        this.stack[this.stackCount++] = d;
        this.stack[this.stackCount++] = d2;
        this.stack[this.stackCount++] = d3;
        this.stack[this.stackCount++] = d4;
        this.lastOpCode = 30;
    }

    private void addVHCurveTo(double d, double d2, double d3, double d4, double d5) {
        this.ensureStackSpace(5);
        this.addVHCurveTo(d, d2, d3, d4);
        this.stack[this.stackCount++] = d5;
        this.stackToCString();
    }

    private void addVVCurveTo(double d, double d2, double d3, double d4) {
        this.ensureStackSpace(4);
        switch (this.lastOpCode) {
            default: {
                this.stackToCString();
            }
            case 0: 
            case 26: 
        }
        this.stack[this.stackCount++] = d;
        this.stack[this.stackCount++] = d2;
        this.stack[this.stackCount++] = d3;
        this.stack[this.stackCount++] = d4;
        this.lastOpCode = 26;
    }

    private void addVVCurveTo(double d, double d2, double d3, double d4, double d5) {
        this.ensureStackSpace(5);
        switch (this.lastOpCode) {
            default: {
                this.stackToCString();
            }
            case 0: 
        }
        this.stack[this.stackCount++] = d;
        this.stack[this.stackCount++] = d2;
        this.stack[this.stackCount++] = d3;
        this.stack[this.stackCount++] = d4;
        this.stack[this.stackCount++] = d5;
        this.lastOpCode = 26;
    }

    private void addHVCurveTo(double d, double d2, double d3, double d4) {
        this.ensureStackSpace(4);
        switch (this.lastOpCode) {
            default: {
                this.stackToCString();
            }
            case 0: {
                this.startOfSeqOp = 31;
            }
            case 30: 
        }
        this.stack[this.stackCount++] = d;
        this.stack[this.stackCount++] = d2;
        this.stack[this.stackCount++] = d3;
        this.stack[this.stackCount++] = d4;
        this.lastOpCode = 31;
    }

    private void addHVCurveTo(double d, double d2, double d3, double d4, double d5) {
        this.ensureStackSpace(5);
        this.addHVCurveTo(d, d2, d3, d5);
        this.stack[this.stackCount++] = d4;
        this.stackToCString();
    }

    private void addHHCurveTo(double d, double d2, double d3, double d4) {
        this.ensureStackSpace(4);
        switch (this.lastOpCode) {
            default: {
                this.stackToCString();
            }
            case 0: 
            case 27: 
        }
        this.stack[this.stackCount++] = d;
        this.stack[this.stackCount++] = d2;
        this.stack[this.stackCount++] = d3;
        this.stack[this.stackCount++] = d4;
        this.lastOpCode = 27;
    }

    private void addHHCurveTo(double d, double d2, double d3, double d4, double d5) {
        this.ensureStackSpace(5);
        switch (this.lastOpCode) {
            default: {
                this.stackToCString();
            }
            case 0: 
        }
        this.stack[this.stackCount++] = d2;
        this.stack[this.stackCount++] = d;
        this.stack[this.stackCount++] = d3;
        this.stack[this.stackCount++] = d4;
        this.stack[this.stackCount++] = d5;
        this.lastOpCode = 27;
    }

    private void addRRCurveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        this.ensureStackSpace(6);
        switch (this.lastOpCode) {
            case 5: {
                this.stack[this.stackCount++] = d;
                this.stack[this.stackCount++] = d2;
                this.stack[this.stackCount++] = d3;
                this.stack[this.stackCount++] = d4;
                this.stack[this.stackCount++] = d5;
                this.stack[this.stackCount++] = d6;
                this.lastOpCode = 25;
                this.stackToCString();
                break;
            }
            default: {
                this.stackToCString();
            }
            case 0: 
            case 8: {
                this.stack[this.stackCount++] = d;
                this.stack[this.stackCount++] = d2;
                this.stack[this.stackCount++] = d3;
                this.stack[this.stackCount++] = d4;
                this.stack[this.stackCount++] = d5;
                this.stack[this.stackCount++] = d6;
                this.lastOpCode = 8;
            }
        }
    }

    public void curveto(double d, double d2, double d3, double d4) {
        if (!this.moveToSeen) {
            this.moveto(0.0, 0.0);
        }
        this.curveto(Math.round((this.currentX + 2.0 * d) / 3.0), Math.round((this.currentY + 2.0 * d2) / 3.0), Math.round((2.0 * d + d3) / 3.0), Math.round((2.0 * d2 + d4) / 3.0), d3, d4);
    }

    public void curveto(double d, double d2, double d3, double d4, double d5, double d6) {
        if (!this.moveToSeen) {
            this.moveto(0.0, 0.0);
        }
        double d7 = d - this.currentX;
        double d8 = d3 - d;
        double d9 = d5 - d3;
        double d10 = d2 - this.currentY;
        double d11 = d4 - d2;
        double d12 = d6 - d4;
        this.currentX = d5;
        this.currentY = d6;
        if (d7 == 0.0) {
            if (d12 == 0.0) {
                this.addVHCurveTo(d10, d8, d11, d9);
            } else if (d9 == 0.0) {
                this.addVVCurveTo(d10, d8, d11, d12);
            } else {
                this.addVHCurveTo(d10, d8, d11, d9, d12);
            }
        } else if (d10 == 0.0) {
            if (d9 == 0.0) {
                this.addHVCurveTo(d7, d8, d11, d12);
            } else if (d12 == 0.0) {
                this.addHHCurveTo(d7, d8, d11, d9);
            } else {
                this.addHVCurveTo(d7, d8, d11, d9, d12);
            }
        } else if (d9 == 0.0) {
            this.addVVCurveTo(d7, d10, d8, d11, d12);
        } else if (d12 == 0.0) {
            this.addHHCurveTo(d7, d10, d8, d11, d9);
        } else {
            this.addRRCurveTo(d7, d10, d8, d11, d9, d12);
        }
    }

    private void clearMoveTo(double d, double d2) {
        this.currentX -= d;
        this.currentY -= d2;
        this.stackCount = 0;
        this.lastOpCode = 0;
    }

    public void moveto(double d, double d2) {
        switch (this.lastOpCode) {
            default: {
                this.stackToCString();
                break;
            }
            case 0: {
                break;
            }
            case 4: {
                this.clearMoveTo(0.0, this.stack[0]);
                break;
            }
            case 22: {
                this.clearMoveTo(this.stack[0], 0.0);
                break;
            }
            case 21: {
                this.clearMoveTo(this.stack[0], this.stack[1]);
            }
        }
        double d3 = d - this.currentX;
        double d4 = d2 - this.currentY;
        this.currentX = d;
        this.currentY = d2;
        if (d3 == 0.0) {
            this.stack[this.stackCount++] = d4;
            this.lastOpCode = 4;
        } else if (d4 == 0.0) {
            this.stack[this.stackCount++] = d3;
            this.lastOpCode = 22;
        } else {
            this.stack[this.stackCount++] = d3;
            this.stack[this.stackCount++] = d4;
            this.lastOpCode = 21;
        }
        this.moveToSeen = true;
    }

    public void closepath() {
    }

    private void addGeneralFlex(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        this.stack[this.stackCount++] = d2 - this.currentX;
        this.stack[this.stackCount++] = d3 - this.currentY;
        this.stack[this.stackCount++] = d4 - d2;
        this.stack[this.stackCount++] = d5 - d3;
        this.stack[this.stackCount++] = d6 - d4;
        this.stack[this.stackCount++] = d7 - d5;
        this.stack[this.stackCount++] = d8 - d6;
        this.stack[this.stackCount++] = d9 - d7;
        this.stack[this.stackCount++] = d10 - d8;
        this.stack[this.stackCount++] = d11 - d9;
        this.stack[this.stackCount++] = d12 - d10;
        this.stack[this.stackCount++] = d13 - d11;
        this.stack[this.stackCount++] = d;
        this.lastOpCode = 12;
        this.stackToCString();
        this.lastOpCode = 35;
        this.stackToCString();
        this.currentX = d12;
        this.currentY = d13;
    }

    public void flex(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        boolean bl = true;
        if (this.lastOpCode != 0) {
            this.stackToCString();
        }
        if (d != 50.0) {
            this.addGeneralFlex(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13);
            return;
        }
        if (this.currentY == d13) {
            if (d5 == d7 && d7 == d9) {
                if (this.currentY == d3 && d11 == d13) {
                    this.stack[this.stackCount++] = d2 - this.currentX;
                    this.stack[this.stackCount++] = d4 - d2;
                    this.stack[this.stackCount++] = d5 - d3;
                    this.stack[this.stackCount++] = d6 - d4;
                    this.stack[this.stackCount++] = d8 - d6;
                    this.stack[this.stackCount++] = d10 - d8;
                    this.stack[this.stackCount++] = d12 - d10;
                    this.lastOpCode = 12;
                    this.stackToCString();
                    this.lastOpCode = 34;
                    this.stackToCString();
                } else {
                    this.stack[this.stackCount++] = d2 - this.currentX;
                    this.stack[this.stackCount++] = d3 - this.currentY;
                    this.stack[this.stackCount++] = d4 - d2;
                    this.stack[this.stackCount++] = d5 - d3;
                    this.stack[this.stackCount++] = d6 - d4;
                    this.stack[this.stackCount++] = d8 - d6;
                    this.stack[this.stackCount++] = d10 - d8;
                    this.stack[this.stackCount++] = d11 - d9;
                    this.stack[this.stackCount++] = d12 - d10;
                    this.lastOpCode = 12;
                    this.stackToCString();
                    this.lastOpCode = 36;
                    this.stackToCString();
                }
                this.currentX = d12;
                this.currentY = d13;
                return;
            }
        } else if (this.currentX == d12) {
            bl = false;
        } else {
            this.addGeneralFlex(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13);
            return;
        }
        if (Math.abs(d10 - this.currentX) > Math.abs(d11 - this.currentY) != bl) {
            this.addGeneralFlex(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13);
            return;
        }
        this.stack[this.stackCount++] = d2 - this.currentX;
        this.stack[this.stackCount++] = d3 - this.currentY;
        this.stack[this.stackCount++] = d4 - d2;
        this.stack[this.stackCount++] = d5 - d3;
        this.stack[this.stackCount++] = d6 - d4;
        this.stack[this.stackCount++] = d7 - d5;
        this.stack[this.stackCount++] = d8 - d6;
        this.stack[this.stackCount++] = d9 - d7;
        this.stack[this.stackCount++] = d10 - d8;
        this.stack[this.stackCount++] = d11 - d9;
        this.stack[this.stackCount++] = bl ? d12 - d10 : d13 - d11;
        this.lastOpCode = 12;
        this.stackToCString();
        this.lastOpCode = 37;
        this.stackToCString();
        this.currentX = d12;
        this.currentY = d13;
    }

    public void endchar() {
        switch (this.lastOpCode) {
            default: {
                this.stackToCString();
                break;
            }
            case 0: 
            case 4: 
            case 21: 
            case 22: {
                this.stackCount = 0;
                this.lastOpCode = 0;
            }
        }
        this.lastOpCode = 14;
        this.stackToCString();
        this.newHintMask();
        this.newCntrMask();
    }

    private CharStrings createIndexFromCharstrings() throws InvalidFontException, UnsupportedFontException {
        int n;
        int n2 = 1;
        CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder = CFFByteArray.getCFFByteArrayBuilderInstance();
        cFFByteArrayBuilder.addCard16(this.glyphs.length);
        for (n = 0; n < this.glyphs.length; ++n) {
            n2 += this.glyphs[n].finalcstr.cstrLen;
        }
        int n3 = n2 > 0xFFFFFF ? 4 : (n2 > 65535 ? 3 : (n2 > 255 ? 2 : 1));
        cFFByteArrayBuilder.addCard8(n3);
        n2 = 1;
        for (n = 0; n < this.glyphs.length; ++n) {
            cFFByteArrayBuilder.addOffset(n3, n2);
            n2 += this.glyphs[n].finalcstr.cstrLen;
        }
        cFFByteArrayBuilder.addOffset(n3, n2);
        for (n = 0; n < this.glyphs.length; ++n) {
            cFFByteArrayBuilder.addBytes(this.glyphs[n].finalcstr.cstr, 0, this.glyphs[n].finalcstr.cstrLen);
        }
        return new CharStrings(cFFByteArrayBuilder.toCFFByteArray(), 0);
    }

    public CharStrings getCharstringIndex() throws InvalidFontException, UnsupportedFontException {
        for (int i = 0; i < this.glyphs.length; ++i) {
            this.glyphs[i].generateFullCharstring(this.defaultWidth, this.nominalWidth);
        }
        return this.createIndexFromCharstrings();
    }

    private int numsize(double d) {
        int n = (int)d;
        if ((double)n == d) {
            if (-107 <= n && n <= 107) {
                return 1;
            }
            if (-1131 <= n && n <= 1131) {
                return 2;
            }
            return 3;
        }
        return 5;
    }

    private void analyzeWidths(int n) {
        int n2;
        int n3;
        ArrayList<WidthFrequency> arrayList = new ArrayList<WidthFrequency>();
        WidthFrequency widthFrequency = new WidthFrequency();
        WidthComparator widthComparator = new WidthComparator();
        for (n3 = 0; n3 < this.glyphs.length; ++n3) {
            if (this.glyphs[n3].fd != n) continue;
            widthFrequency.width = this.glyphs[n3].width;
            n2 = Collections.binarySearch(arrayList, widthFrequency, widthComparator);
            if (n2 >= 0) {
                ++((WidthFrequency)arrayList.get((int)n2)).count;
                continue;
            }
            arrayList.add(-n2 - 1, new WidthFrequency(this.glyphs[n3].width));
        }
        if (arrayList.size() > 0) {
            if (arrayList.size() == 1) {
                this.defaultWidth[n] = ((WidthFrequency)arrayList.get((int)0)).width;
            } else {
                n2 = 0;
                int n4 = 0;
                int n5 = 0;
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    WidthFrequency widthFrequency2 = (WidthFrequency)arrayList.get(n3);
                    if (widthFrequency2.width == 0.0) continue;
                    n2 += this.numsize(widthFrequency2.width - 0.0) * widthFrequency2.count;
                }
                int n6 = n2;
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    WidthFrequency widthFrequency3;
                    int n7;
                    double d = ((WidthFrequency)arrayList.get((int)n3)).width + 107.0;
                    int n8 = 0;
                    for (n7 = 0; n7 < arrayList.size(); ++n7) {
                        widthFrequency3 = (WidthFrequency)arrayList.get(n7);
                        n8 += this.numsize(widthFrequency3.width - d) * widthFrequency3.count;
                    }
                    for (n7 = 0; n7 < arrayList.size(); ++n7) {
                        widthFrequency3 = (WidthFrequency)arrayList.get(n7);
                        int n9 = n8 - this.numsize(widthFrequency3.width - d) * widthFrequency3.count;
                        if (n9 >= n6) continue;
                        n6 = n9;
                        n4 = n3;
                        n5 = n7;
                    }
                }
                double d = ((WidthFrequency)arrayList.get((int)n5)).width;
                double d2 = ((WidthFrequency)arrayList.get((int)n4)).width + 107.0;
                int n10 = 0;
                if (d != 0.0) {
                    n10 += this.numsize(d) + Dict.Key.defaultWidthX.opCodeLength();
                }
                if (d2 != 0.0) {
                    n10 += this.numsize(d2) + Dict.Key.nominalWidthX.opCodeLength();
                }
                if (n6 + n10 < n2) {
                    this.defaultWidth[n] = d;
                    this.nominalWidth[n] = d2;
                }
            }
        }
        this.widthsAnalyzed[n] = true;
    }

    public double calculateNominalWidth(int n) {
        if (!this.widthsAnalyzed[n]) {
            this.analyzeWidths(n);
        }
        return this.nominalWidth[n];
    }

    public double calculateDefaultWidth(int n) {
        if (!this.widthsAnalyzed[n]) {
            this.analyzeWidths(n);
        }
        return this.defaultWidth[n];
    }

    static final class GlyphInfo {
        double width;
        final int fd;
        List hints = new ArrayList();
        List hintMasks = new ArrayList();
        List cntrMasks = new ArrayList();
        byte[] initMask = new byte[12];
        GrowableBuffer tmpcstr = new GrowableBuffer();
        GrowableBuffer finalcstr = new GrowableBuffer();

        GlyphInfo(int n, double d) {
            this.fd = n;
            this.width = d;
        }

        private int findHint(double d, double d2, boolean bl, boolean bl2) {
            double d3;
            double d4;
            HintComparator hintComparator = new HintComparator();
            double d5 = d2 - d;
            if (d5 < 0.0 && Double.compare(d5, -21.0) != 0 && Double.compare(d5, -20.0) != 0) {
                d4 = d2;
                d3 = d;
            } else {
                d4 = d;
                d3 = d2;
            }
            HintInfo hintInfo = new HintInfo(d3, d4, (bl ? 1 : 0) | (bl2 ? 2 : 0));
            int n = Collections.binarySearch(this.hints, hintInfo, hintComparator);
            if (n < 0) {
                if (this.cntrMasks.size() > 0 && !bl2) {
                    if (-n - 1 < this.hints.size() && hintInfo.fuzzyMatch((HintInfo)this.hints.get(-n - 1))) {
                        return ((HintInfo)this.hints.get((int)(-n - 1))).id;
                    }
                    if (-n - 1 > 0 && hintInfo.fuzzyMatch((HintInfo)this.hints.get(-n - 2))) {
                        return ((HintInfo)this.hints.get((int)(-n - 2))).id;
                    }
                }
                hintInfo.id = this.hints.size();
                this.hints.add(-n - 1, hintInfo);
                return hintInfo.id;
            }
            return ((HintInfo)this.hints.get((int)n)).id;
        }

        private static boolean maskByteSet(int n, byte[] byArray) {
            return (byArray[n / 8] & 1 << n % 8) != 0;
        }

        private static void addHintToMask(int n, byte[] byArray) {
            int n2 = n / 8;
            byArray[n2] = (byte)(byArray[n2] | 1 << 7 - n % 8);
        }

        private void writeStems(int n, int n2, int n3, boolean bl) {
            int n4 = (n2 - n + 23 - 1) / 23;
            int n5 = n2 - n - (n4 - 1) * 23;
            ListIterator listIterator = this.hints.listIterator(n);
            while (n4-- > 0) {
                double d = 0.0;
                while (n5-- > 0) {
                    HintInfo hintInfo = (HintInfo)listIterator.next();
                    this.finalcstr.numToCString(hintInfo.bottom - d);
                    this.finalcstr.numToCString(hintInfo.top - hintInfo.bottom);
                    d = hintInfo.top;
                }
                if (bl || n4 > 0) {
                    this.finalcstr.addByte(n3);
                }
                n5 = 23;
            }
        }

        private void saveStartOfCString(byte[] byArray, double[] dArray, double[] dArray2) {
            int n;
            Object object;
            int n2 = (this.hints.size() + 7) / 8;
            byte[] byArray2 = new byte[n2];
            boolean bl = false;
            boolean bl2 = false;
            int n3 = this.hints.size();
            if (this.width != dArray[this.fd]) {
                this.finalcstr.numToCString(this.width - dArray2[this.fd]);
            }
            if (n3 == 0) {
                return;
            }
            Iterator iterator = this.hints.iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                object = (HintInfo)iterator.next();
                if ((((HintInfo)object).flags & 1) != 0) break;
                ++n4;
            }
            Arrays.fill(byArray2, (byte)-1);
            if (n3 % 8 != 0) {
                byArray2[byArray2.length - 1] = (byte)(255 >> 8 - n3 % 8);
            }
            if (!SubArrays.arrayCompare(byArray2, 0, this.initMask, 0, byArray2.length)) {
                bl = true;
                bl2 = true;
            } else if (!this.hintMasks.isEmpty()) {
                bl = true;
            }
            this.writeStems(0, n4, bl ? 18 : 1, true);
            this.writeStems(n4, n3, bl ? 23 : 3, !bl2 && this.cntrMasks.isEmpty());
            iterator = this.cntrMasks.iterator();
            while (iterator.hasNext()) {
                object = (CntrMask)iterator.next();
                Arrays.fill(byArray2, (byte)0);
                this.finalcstr.addByte(20);
                for (n = 0; n < n3; ++n) {
                    if (!GlyphInfo.maskByteSet(n, ((CntrMask)object).mask)) continue;
                    GlyphInfo.addHintToMask(byArray[n], byArray2);
                }
                for (n = 0; n < byArray2.length; ++n) {
                    this.finalcstr.addByte(byArray2[n]);
                }
            }
            if (bl2) {
                Arrays.fill(byArray2, (byte)0);
                this.finalcstr.addByte(19);
                for (n = 0; n < n3; ++n) {
                    if (!GlyphInfo.maskByteSet(n, this.initMask)) continue;
                    GlyphInfo.addHintToMask(byArray[n], byArray2);
                }
                for (n = 0; n < byArray2.length; ++n) {
                    this.finalcstr.addByte(byArray2[n]);
                }
            }
        }

        private void savePathsToCString(byte[] byArray) {
            int n = (this.hints.size() + 7) / 8;
            Iterator iterator = this.hintMasks.iterator();
            int n2 = 0;
            byte[] byArray2 = new byte[n];
            int n3 = this.hints.size();
            while (iterator.hasNext()) {
                int n4;
                HintMask hintMask = (HintMask)iterator.next();
                int n5 = hintMask.indexIntoCStr;
                while (n2 < n5) {
                    this.finalcstr.addByte(this.tmpcstr.cstr[n2]);
                    ++n2;
                }
                Arrays.fill(byArray2, (byte)0);
                this.finalcstr.addByte(19);
                for (n4 = 0; n4 < n3; ++n4) {
                    if (!GlyphInfo.maskByteSet(n4, hintMask.mask)) continue;
                    GlyphInfo.addHintToMask(byArray[n4], byArray2);
                }
                for (n4 = 0; n4 < byArray2.length; ++n4) {
                    this.finalcstr.addByte(byArray2[n4]);
                }
            }
            while (n2 < this.tmpcstr.cstrLen) {
                this.finalcstr.addByte(this.tmpcstr.cstr[n2]);
                ++n2;
            }
        }

        void generateFullCharstring(double[] dArray, double[] dArray2) {
            byte[] byArray = new byte[this.hints.size()];
            Iterator iterator = this.hints.iterator();
            byte by = 0;
            while (iterator.hasNext()) {
                HintInfo hintInfo = (HintInfo)iterator.next();
                byArray[hintInfo.id] = by;
                by = (byte)(by + 1);
            }
            this.saveStartOfCString(byArray, dArray, dArray2);
            this.savePathsToCString(byArray);
        }

        void setWidth(double d, double[] dArray) {
            this.width = d + dArray[this.fd];
        }
    }

    static final class GrowableBuffer {
        byte[] cstr = new byte[200];
        int cstrLen = 0;

        GrowableBuffer() {
        }

        void ensureCStrIsBigEnough(int n) {
            if (this.cstrLen + n > this.cstr.length) {
                byte[] byArray = new byte[this.cstr.length + Math.max(n, 50)];
                System.arraycopy(this.cstr, 0, byArray, 0, this.cstrLen);
                this.cstr = byArray;
            }
        }

        void addByte(int n) {
            this.ensureCStrIsBigEnough(1);
            this.cstr[this.cstrLen++] = (byte)(n & 0xFF);
        }

        private void intToCString(int n) {
            if (-107 <= n && n <= 107) {
                this.addByte(n + 139);
            } else if (108 <= n && n <= 1131) {
                this.addByte(((n -= 108) >> 8) + 247);
                this.addByte(n);
            } else if (-1131 <= n && n <= -108) {
                this.addByte((-(n += 108) >> 8) + 251);
                this.addByte(-n);
            } else if (Short.MIN_VALUE <= n && n <= Short.MAX_VALUE) {
                this.addByte(28);
                this.addByte(n >> 8);
                this.addByte(n);
            }
        }

        void numToCString(double d) {
            int n = (int)d;
            if ((double)n == d) {
                this.intToCString(n);
                return;
            }
            int n2 = (int)(d * 65536.0 + (d < 0.0 ? -0.5 : 0.5));
            this.addByte(255);
            this.addByte(n2 >> 24);
            this.addByte(n2 >> 16);
            this.addByte(n2 >> 8);
            this.addByte(n2);
        }
    }

    private static class CntrMask {
        byte[] mask = new byte[12];

        CntrMask(byte[] byArray) {
            System.arraycopy(byArray, 0, this.mask, 0, byArray.length);
        }
    }

    private static class HintMask {
        final int indexIntoCStr;
        final byte[] mask = new byte[12];

        HintMask(int n, byte[] byArray) {
            this.indexIntoCStr = n;
            System.arraycopy(byArray, 0, this.mask, 0, byArray.length);
        }
    }

    private static class HintComparator
    implements Comparator {
        private HintComparator() {
        }

        public int compare(Object object, Object object2) {
            HintInfo hintInfo = (HintInfo)object;
            HintInfo hintInfo2 = (HintInfo)object2;
            int n = (hintInfo.flags & 1) - (hintInfo2.flags & 1);
            if (n != 0) {
                return n;
            }
            if (hintInfo.bottom < hintInfo2.bottom) {
                return -1;
            }
            if (hintInfo.bottom > hintInfo2.bottom) {
                return 1;
            }
            if (hintInfo.top < hintInfo2.top) {
                return -1;
            }
            if (hintInfo.top > hintInfo2.top) {
                return 1;
            }
            return 0;
        }
    }

    private static class HintInfo {
        final double top;
        final double bottom;
        final int flags;
        int id;
        static final int VERTICAL_STEM = 1;
        static final int CNTR_STEM = 2;

        HintInfo(double d, double d2, int n) {
            this.top = d;
            this.bottom = d2;
            this.flags = n;
        }

        boolean fuzzyMatch(HintInfo hintInfo) {
            return (hintInfo.flags & 2) != 0 && (this.flags & 1) == (hintInfo.flags & 1) && Math.abs(this.bottom - hintInfo.bottom) < 2.0 && Math.abs(this.top - hintInfo.top) < 2.0;
        }
    }

    private static class WidthComparator
    implements Comparator {
        private WidthComparator() {
        }

        public int compare(Object object, Object object2) {
            WidthFrequency widthFrequency = (WidthFrequency)object;
            WidthFrequency widthFrequency2 = (WidthFrequency)object2;
            return (int)(widthFrequency.width - widthFrequency2.width);
        }
    }

    private static class WidthFrequency {
        double width;
        int count;

        WidthFrequency(double d) {
            this.width = d;
            this.count = 1;
        }

        WidthFrequency() {
            this.count = 0;
        }
    }
}

