/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Orientation;
import com.adobe.fontengine.font.opentype.Table;
import com.adobe.fontengine.font.opentype.Tag;
import java.io.IOException;

public final class Base
extends Table {
    protected Base(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray);
        int n = this.getTableMajorVersion();
        if (n != 1) {
            throw new UnsupportedFontException("'BASE' tables with major version " + n + "are not supported");
        }
    }

    public int getTableMajorVersion() throws InvalidFontException {
        return this.data.getuint16(0);
    }

    public int getTableMinorVersion() throws InvalidFontException {
        return this.data.getuint16(2);
    }

    public int getBaselinePosition(Orientation orientation, int n, int n2) throws InvalidFontException {
        int n3;
        int n4;
        int n5 = this.data.getOffset(0, orientation == Orientation.HORIZONTAL ? 4 : 6);
        if (n5 == 0) {
            return Integer.MAX_VALUE;
        }
        int n6 = this.data.getOffset(n5, 0);
        if (n6 == 0) {
            return Integer.MAX_VALUE;
        }
        int n7 = -1;
        int n8 = this.data.getuint16(n6);
        for (n4 = 0; n4 < n8; ++n4) {
            if (this.data.getuint32(n6 + 2 + 4 * n4) != (long)n2) continue;
            n7 = n4;
            break;
        }
        if (n7 == -1) {
            return Integer.MAX_VALUE;
        }
        n4 = this.data.getOffset(n5, 2);
        int n9 = this.data.getuint16(n4);
        int n10 = -1;
        for (n3 = 0; n3 < n9; ++n3) {
            if (Tag.script_DFLT == n || this.data.getuint32(n4 + 2 + 6 * n3) == (long)n) {
                n10 = n3;
                break;
            }
            if (n10 != -1 || this.data.getuint32(n4 + 2 + 6 * n3) != (long)Tag.script_DFLT) continue;
            n10 = n3;
            break;
        }
        if (n10 == -1) {
            return Integer.MAX_VALUE;
        }
        n3 = this.data.getOffset(n4, 2 + 6 * n10 + 4);
        int n11 = this.data.getOffset(n3, 0);
        if (n11 == 0) {
            return Integer.MAX_VALUE;
        }
        int n12 = this.data.getOffset(n11, 4 + 2 * n7);
        return this.data.getint16(n12 + 2);
    }
}

