/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem;

import flash.util.FileUtils;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.tools.oem.VirtualLocalFile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class VirtualLocalFileSystem {
    private final Map files = new HashMap();

    public final VirtualLocalFile create(String name, String text, File parent, long lastModified) {
        VirtualLocalFile f = new VirtualLocalFile(name, text, parent, lastModified, this);
        this.files.put(name, f);
        return f;
    }

    public final boolean update(String name, String text, long lastModified) {
        VirtualLocalFile f = (VirtualLocalFile)this.files.get(name);
        if (f != null) {
            f.text = text;
            f.lastModified = lastModified;
            return true;
        }
        return false;
    }

    final VirtualFile resolve(VirtualLocalFile base, String name) {
        VirtualLocalFile f = (VirtualLocalFile)this.files.get(name);
        if (f != null) {
            return f;
        }
        String fullName = this.constructName(base, name);
        f = (VirtualLocalFile)this.files.get(fullName);
        if (f != null) {
            return f;
        }
        File absolute = FileUtil.openFile(name);
        if (absolute != null && FileUtils.exists((File)absolute)) {
            return new LocalFile(absolute);
        }
        File relative = FileUtil.openFile(fullName);
        if (relative != null && FileUtils.exists((File)relative)) {
            return new LocalFile(relative);
        }
        return null;
    }

    private String constructName(VirtualLocalFile base, String relativeName) {
        return FileUtil.getCanonicalPath(FileUtil.openFile(base.getParent() + File.separator + relativeName));
    }
}

