/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee;

import flex.webtier.services.ServiceFactory;

public class FileNameGenerator {
    private static String mxmlExt;
    private static String swfExt;
    private static String mxmlSwfExt;
    private static String asExt;
    private static String asSwfExt;

    private static String stripSuffixes(String fileName) {
        int index = -1;
        if (mxmlExt == null) {
            mxmlExt = ServiceFactory.getExtensionManager().getMxmlExt();
        }
        if (fileName.lastIndexOf(mxmlExt) != -1) {
            index = fileName.lastIndexOf(mxmlExt);
        } else if (fileName.lastIndexOf(asExt) != -1) {
            index = fileName.lastIndexOf(asExt);
        } else if (fileName.lastIndexOf(46) != -1) {
            index = fileName.lastIndexOf(46);
        }
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    public static String sourceFileName(String fileName) {
        if (mxmlExt == null) {
            mxmlExt = ServiceFactory.getExtensionManager().getMxmlExt();
        }
        if (asExt == null) {
            asExt = ServiceFactory.getExtensionManager().getAsExt();
        }
        if (fileName.lastIndexOf(asExt) != -1) {
            return FileNameGenerator.stripSuffixes(fileName) + asExt;
        }
        return FileNameGenerator.stripSuffixes(fileName) + mxmlExt;
    }

    public static String generatedSwfFileName(String fileName) {
        if (swfExt == null) {
            swfExt = ServiceFactory.getExtensionManager().getSwfExt();
        }
        return FileNameGenerator.stripSuffixes(fileName) + swfExt;
    }

    public static String swfFileName(String fileName) {
        if (mxmlSwfExt == null) {
            mxmlSwfExt = ServiceFactory.getExtensionManager().getMxmlSwfExt();
        }
        if (asExt == null) {
            asExt = ServiceFactory.getExtensionManager().getAsExt();
        }
        if (asSwfExt == null) {
            asSwfExt = ServiceFactory.getExtensionManager().getAsSwfExt();
        }
        if (swfExt == null) {
            swfExt = ServiceFactory.getExtensionManager().getSwfExt();
        }
        if (fileName.lastIndexOf(asExt) != -1) {
            return FileNameGenerator.stripSuffixes(fileName) + asSwfExt;
        }
        if (ServiceFactory.isMxmlSwfExtension()) {
            return FileNameGenerator.stripSuffixes(fileName) + mxmlSwfExt;
        }
        return FileNameGenerator.stripSuffixes(fileName) + swfExt;
    }
}

