/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.filemanager;

import flex.webtier.server.j2ee.HttpCache;
import flex.webtier.server.j2ee.filemanager.DetectionFileManager;
import flex.webtier.server.j2ee.filemanager.HistoryFileManager;
import flex.webtier.server.j2ee.filemanager.InternalFile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileManagerServlet
extends HttpServlet {
    static final long serialVersionUID = -8523981448482998200L;
    private static Map internalFiles = null;
    private static boolean initialized = false;
    private DetectionFileManager detectionFileManager = new DetectionFileManager();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (internalFiles == null) {
            internalFiles = new HashMap(20);
        }
        try {
            HistoryFileManager.getInstance().init(internalFiles);
            this.detectionFileManager.init(internalFiles);
        }
        catch (IOException ioe) {
            throw new ServletException("Error obtaining internal files");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String actionName = request.getParameter("action");
            if (!initialized) {
                this.initializeDynamicFiles(request);
            }
            if (actionName != null) {
                if (actionName.equals(HistoryFileManager.HISTORY_ACTION_HTML) || actionName.equals(HistoryFileManager.HISTORY_ACTION_HTML_SECURE)) {
                    this.sendHtml(actionName, request, response);
                } else if (actionName.equals(HistoryFileManager.HISTORY_ACTION_SWF)) {
                    this.sendSwf(HistoryFileManager.HISTORY_ACTION_SWF, request, response);
                } else if (actionName.equals(DetectionFileManager.DETECTION_ACTION_SWF)) {
                    this.sendSwf(DetectionFileManager.DETECTION_ACTION_SWF, request, response);
                } else if (actionName.equals(HistoryFileManager.HISTORY_ACTION_JS)) {
                    this.sendJS(HistoryFileManager.HISTORY_ACTION_JS, request, response);
                } else if (actionName.equals(DetectionFileManager.DETECTION_ACTION_JS)) {
                    this.sendJS(DetectionFileManager.DETECTION_ACTION_JS, request, response);
                }
            } else {
                this.sendFile(request.getPathInfo(), request, response);
            }
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage());
        }
    }

    private void initializeDynamicFiles(HttpServletRequest request) {
        try {
            HistoryFileManager.getInstance().initializeDynamicFiles(request, internalFiles);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.detectionFileManager.initializeDynamicFiles(request, internalFiles);
        initialized = true;
    }

    private void sendFile(String filename, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (filename == null) {
            response.sendError(404);
        } else if (filename.endsWith("swf")) {
            this.sendSwf(filename, request, response);
        } else if (filename.endsWith("html") || filename.endsWith("mxml")) {
            this.sendHtml(filename, request, response);
        } else if (filename.endsWith("gif")) {
            this.sendGif(filename, request, response);
        } else if (filename.endsWith("js")) {
            this.sendJS(filename, request, response);
        } else {
            response.sendError(404);
        }
    }

    private void sendHtml(String name, HttpServletRequest request, HttpServletResponse response) throws IOException {
        InternalFile file = (InternalFile)internalFiles.get(name);
        long modifiedSince = request.getDateHeader("If-Modified-Since");
        if (file == null) {
            response.sendError(404);
        } else if (Math.abs(file.getLastModified() - modifiedSince) < 1000L) {
            response.setStatus(304);
        } else {
            ServletOutputStream out = response.getOutputStream();
            HttpCache.setCacheHeaders(true, 1L, file.getLastModified(), response);
            response.setContentType("text/html;charset=UTF-8");
            response.setContentLength(file.getBytes().size());
            try {
                file.getBytes().writeTo((OutputStream)out);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    private void sendGif(String name, HttpServletRequest request, HttpServletResponse response) throws IOException {
        InternalFile file = (InternalFile)internalFiles.get(name);
        long modifiedSince = request.getDateHeader("If-Modified-Since");
        if (file == null) {
            response.sendError(404);
        } else if (Math.abs(file.getLastModified() - modifiedSince) < 1000L) {
            response.setStatus(304);
        } else {
            ServletOutputStream out = response.getOutputStream();
            HttpCache.setCacheHeaders(true, 1L, file.getLastModified(), response);
            response.setContentType("image/gif");
            response.setContentLength(file.getBytes().size());
            try {
                file.getBytes().writeTo((OutputStream)out);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    private void sendSwf(String name, HttpServletRequest request, HttpServletResponse response) throws IOException {
        InternalFile file = (InternalFile)internalFiles.get(name);
        long modifiedSince = request.getDateHeader("If-Modified-Since");
        if (file == null) {
            response.sendError(404);
        } else if (Math.abs(file.getLastModified() - modifiedSince) < 1000L) {
            response.setStatus(304);
        } else {
            ServletOutputStream out = response.getOutputStream();
            HttpCache.setCacheHeaders(true, 1L, file.getLastModified(), response);
            response.setContentType("application/x-shockwave-flash");
            response.setContentLength(file.getBytes().size());
            try {
                file.getBytes().writeTo((OutputStream)out);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    private void sendJS(String name, HttpServletRequest request, HttpServletResponse response) throws IOException {
        InternalFile file = (InternalFile)internalFiles.get(name);
        long modifiedSince = request.getDateHeader("If-Modified-Since");
        if (file == null) {
            response.sendError(404);
        } else if (Math.abs(file.getLastModified() - modifiedSince) < 1000L) {
            response.setStatus(304);
        } else {
            ServletOutputStream out = response.getOutputStream();
            HttpCache.setCacheHeaders(true, 1L, file.getLastModified(), response);
            response.setContentType("application/x-javascript");
            response.setContentLength(file.getBytes().size());
            try {
                file.getBytes().writeTo((OutputStream)out);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }
}

