/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.util;

import flex.webtier.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class ObjectUtil {
    private static Hashtable primitiveClasses_ = new Hashtable();

    public static Field findField(Object instance, String name) {
        try {
            return instance.getClass().getField(name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Method findMethod(Object instance, String name, Class[] params) {
        try {
            return instance.getClass().getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Object getValue(Object instance, String fieldName) throws IllegalAccessException, InvocationTargetException {
        Field f = ObjectUtil.findField(instance, fieldName);
        if (f != null) {
            return f.get(instance);
        }
        Method get = ObjectUtil.findMethod(instance, "get".concat(fieldName = StringUtils.upperCaseFirstInitial(fieldName)), new Class[0]);
        if (get == null && (get = ObjectUtil.findMethod(instance, "is".concat(fieldName), new Class[0])) == null) {
            return null;
        }
        return get.invoke(instance, (Object[])new Class[0]);
    }

    public static void setValue(Object instance, Object value, Field field) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ObjectUtil.setValue(instance, field.getName(), field.getType(), value);
    }

    public static void setValue(Object instance, String fieldName, Class fieldClass, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Field f = ObjectUtil.findField(instance, fieldName);
        if (f != null) {
            f.set(instance, value);
        } else {
            Class[] params = new Class[]{fieldClass};
            Method set = ObjectUtil.findMethod(instance, "set".concat(fieldName = StringUtils.upperCaseFirstInitial(fieldName)), params);
            if (set == null && (set = ObjectUtil.findMethod(instance, "set".concat(fieldName), params)) == null) {
                throw new NoSuchMethodException("set".concat(fieldName) + " with args " + params[0].getName());
            }
            Object[] args = new Object[]{value};
            set.invoke(instance, args);
        }
    }

    public static String replaceVars(Object instance, String s) {
        if (s == null) {
            return null;
        }
        StringBuffer out = new StringBuffer(2 * s.length());
        int i = 0;
        int len = s.length();
        do {
            int j;
            if ((j = s.indexOf(123, i)) == -1) {
                j = len;
                out.append(s.substring(i, j));
                break;
            }
            if (j > i) {
                out.append(s.substring(i, j));
            }
            if ((i = s.indexOf(125, j)) == -1) {
                i = len;
                out.append(s.substring(j, i));
                break;
            }
            String name = s.substring(j + 1, i);
            Object value = null;
            try {
                value = ObjectUtil.getValue(instance, name);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            if (value != null) {
                out.append(value);
                continue;
            }
            out.append('{').append(name).append('}');
        } while (++i < len);
        return out.toString();
    }

    public static String getClassName(Object instance) {
        String packageName = instance.getClass().getName();
        int index = packageName.lastIndexOf(46);
        if (index >= 0) {
            return packageName.substring(index + 1);
        }
        return packageName;
    }

    static {
        primitiveClasses_.put(Character.TYPE.getName(), Character.TYPE);
        primitiveClasses_.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primitiveClasses_.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveClasses_.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveClasses_.put(Long.TYPE.getName(), Long.TYPE);
        primitiveClasses_.put(Short.TYPE.getName(), Short.TYPE);
        primitiveClasses_.put(Float.TYPE.getName(), Float.TYPE);
        primitiveClasses_.put(Double.TYPE.getName(), Double.TYPE);
    }
}

